/**
 * Die Klasse GrafischeOberflaeche. Diese Klasse ist das Herzstueck der
 * grafischen Oberflaeche. Natuerlich muessen deshalb die Klassen AWT und
 * AWT.EVENT importiert werden. Die Klasse ist abgeleitet von Frame und
 * implementiert den ActionListener.
 * @author Alexander Schneider, Christian Ongyert, Tobias Kieneinger
*/

package GrafischeOberflaeche;

import java.awt.*;
import java.awt.event.*;
import Steuerung.*;

public class GrafischeOberflaeche
  extends Frame
  implements ActionListener
{
  /**
   * Die Variablen-Deklaration erfolgt hier. Die Variablen die hier stehen
   * benoetigt die ganze Klasse. "Button buttonStarten" z. B. wird veraendert
   * Deshalb muessen diese Variablen hier stehen.
   * @author Alexander Schneiderm, Christian Ongyert, Tobias Kieninger
  */

  private String Betriebssystem;
  private String SchriftwahlTextArea;
  private String SchriftwahlGrafik;
  private String SchriftwahlMenues;
  private String confName;

  private boolean kursivTextArea;
  private boolean kursivGrafik;
  private boolean kursivMenues;
  private boolean fettTextArea;
  private boolean fettGrafik;
  private boolean fettMenues;

  private int SchriftgroesseTextArea;
  private int SchriftgroesseGrafik;
  private int SchriftgroesseMenues;
  private int SchriftstilTextArea=0;
  private int SchriftstilGrafik=0;
  private int SchriftstilMenues=0;

  private float x=0;
  private float y=0;

  private HauptMenue Menue;
  private Button buttonStarten;
  private Button buttonStopWeiter;
  private Button buttonLoeschen;
  private TextArea TextAusgabe;
  private FirstThread Bearbeitung;
  private Grafik GrafischeAusgabe;

  private Grafik zeichnen;
  private Steuerung Start;

  public GrafischeOberflaeche(String _confName)
  {
    super("Fertigungsstrasse");

    confName = _confName;

    /**
     * Hier wird die Bildschirmaufloesung geholt und das Fenster auf 3/4 der
     * Bildschirmaufloesung angepasst.
    */

    Toolkit tk=Toolkit.getDefaultToolkit();
    Dimension Dim=tk.getScreenSize();
    float MonitorWeite=Dim.width;
    float MonitorHoehe=Dim.height;
    setSize(((int)MonitorWeite/4)*3, ((int)MonitorHoehe/4)*3);
    setLocation((int)MonitorWeite/8, (int)MonitorHoehe/8);
    setResizable(false);
    String Schriftarten[] = Toolkit.getDefaultToolkit().getFontList();
    for (int i=0;i<Schriftarten.length;i++)
    {
      if (Schriftarten[i].equals("Monospaced"))
      {
        SchriftwahlTextArea=Schriftarten[i];
        break;
      }
      else
      {
        SchriftwahlTextArea=Schriftarten[0];
      }
    }
    SchriftwahlGrafik=SchriftwahlTextArea;
    SchriftwahlMenues=SchriftwahlTextArea;

    /**
     * Es wird ueberprueft, auf welchem Betriebssystem man sich befindet und
     * dementsprechend die x und y Werte fuer die Bildschirmaufloesung
     * anderst berechnet, da es unter Linux Probleme gemacht hat.
    */

    Betriebssystem=System.getProperty("os.name");

    if ((Betriebssystem.equals("Windows 95")) || (Betriebssystem.equals
        ("Windows 98")) || (Betriebssystem.equals("Windows NT")) ||
        (Betriebssystem.equals("Windows nt")))
    {
      x=(MonitorWeite/1024);
      y=(MonitorHoehe/768);
    }
    else
    {
      x=(MonitorWeite/1152);
      y=(MonitorHoehe/864);
    }

    SchriftgroesseTextArea=(int) (16*x);
    SchriftgroesseGrafik=SchriftgroesseTextArea-3;
    SchriftgroesseMenues=SchriftgroesseTextArea;
    Font Menues=new Font(SchriftwahlMenues,SchriftstilMenues,SchriftgroesseMenues);
    int Zeilen,
        Spalten;
    Spalten=60;
    Zeilen=12;

    /**
     * Hier wird die MenuBar gesetzt und bestimmte Menue Punkte deaktiviert.
    */

    setMenuBar(Menue=new HauptMenue(this));
    Menue.MenueProgramm.getItem(1).setEnabled(false);
    Menue.MenueProgramm.getItem(2).setEnabled(false);

    /**
     * Hier werden die Panels fuer die Buttons und TextArea festgelegt. Die
     * Schriftgroesse wird berechnet und dir Zeilen und Spaltenanzahl fuer
     * die TextArea werden angegeben. Dann werden die ganzen Buttons und die
     * TextArea erstellt. Die Buttons und die TextArea befinden sich in einem
     * verschachtelten Layout.
    */

    Panel Text=new Panel();
    Panel Buttons=new Panel();
    Panel Sueden=new Panel();

    Buttons.setLayout(new GridLayout(3,1,0,5));
    buttonStarten=new Button("Starten");
    buttonStarten.setFont(Menues);
    buttonStarten.addActionListener(this);
    Buttons.add(buttonStarten);
    buttonStopWeiter=new Button("Stop");
    buttonStopWeiter.setFont(Menues);
    buttonStopWeiter.setEnabled(false);
    buttonStopWeiter.addActionListener(this);
    Buttons.add(buttonStopWeiter);
    buttonLoeschen=new Button("Lschen");
    buttonLoeschen.setFont(Menues);
    buttonLoeschen.setEnabled(false);
    buttonLoeschen.addActionListener(this);
    Buttons.add(buttonLoeschen);

    TextAusgabe=new TextArea("",Zeilen,Spalten);
    TextAusgabe.setBackground(Color.cyan);
    TextAusgabe.setForeground(Color.black);
    TextAusgabe.setFont(new Font(SchriftwahlTextArea,SchriftstilMenues,SchriftgroesseTextArea));
    TextAusgabe.append("Informatik Praktikum CE2 SS99\n");
    TextAusgabe.append("=============================\n");
    TextAusgabe.setEditable(false);
    Text.add(TextAusgabe);

    zeichnen=new Grafik(x,y,SchriftwahlGrafik,SchriftstilGrafik,SchriftgroesseGrafik);
    Start=new Steuerung(TextAusgabe,zeichnen,x,y,SchriftgroesseGrafik,confName);
    Start.erstelleFertigung();
    zeichnen.setMaschine(Start);

    Sueden.setLayout(new FlowLayout(FlowLayout.LEFT,5,0));
    Sueden.add(Text);
    Sueden.add(Buttons);
    setLayout(new BorderLayout());
    add("Center",zeichnen);
    add("South",Sueden);

    setVisible(true);
    addWindowListener(new WindowAdapter()
    {
      public void windowClosing(WindowEvent event)
      {
        setVisible(false);
        dispose();
        System.exit(0);
      }
    });
  }

  /**
   * Bei den Methoden Starten, Stop, Weiter, Loeschen werden einfach nur die
   * Buttons und Menue Punkte aktiviert und deaktiviert bzw. der Name ge-
   * aendert. Die Methode Starten erstellt zusaetzlich ein Objekt der Klasse
   * FirstThread und started das Thread. In den anderen Methoden wird das
   * Thread angehalten, weiterlaufen gelassen bzw. gestoppt.
  */

  void Starten()
  {
    Menue.MenueProgramm.getItem(0).setEnabled(false);
    Menue.MenueProgramm.getItem(1).setEnabled(true);
    Menue.MenueProgramm.getItem(2).setEnabled(true);

    buttonStarten.setEnabled(false);
    buttonStopWeiter.setEnabled(true);
    buttonLoeschen.setEnabled(true);

    Bearbeitung=new FirstThread(Start);
    Bearbeitung.setTextAusgabe(TextAusgabe);
    Bearbeitung.start();
  }

  void Stop()
  {
    Menue.MenueProgramm.getItem(1).setLabel("Weiter");
    buttonStopWeiter.setLabel("Weiter");
    Bearbeitung.suspend();
    Start.unterbrechen();
  }

  void Weiter()
  {
    Menue.MenueProgramm.getItem(1).setLabel("Stop");
    buttonStopWeiter.setLabel("Stop");
    Bearbeitung.resume();
    Start.fortfuehren();
  }

  void Loeschen()
  {
    Menue.MenueProgramm.getItem(1).setLabel("Stop");
    buttonStopWeiter.setLabel("Stop");

    Menue.MenueProgramm.getItem(0).setEnabled(true);
    Menue.MenueProgramm.getItem(1).setEnabled(false);
    Menue.MenueProgramm.getItem(2).setEnabled(false);

    buttonStarten.setEnabled(true);
    buttonStopWeiter.setEnabled(false);
    buttonLoeschen.setEnabled(false);

    Bearbeitung.stop();
    Start.stoppen();

    TextAusgabe.setText("");
    TextAusgabe.append("Informatik Praktikum CE2 SS99\n");
    TextAusgabe.append("=============================\n");
    Start.erstelleFertigung();
    zeichnen.repaint();
  }

  /**
   * Die Methode ActionPerformed dient zur Event-Behandlung. D.H. wenn ein
   * Button oder ein Menue Punkt mit der Maus betaetigt wird, wird ueber-
   * prueft, welcher gedrueckt wurde und ein entsprechendes Ereignis aus-
   * gefuehrt.
  */

  public void actionPerformed(ActionEvent event)
  {
    String Auswahl=event.getActionCommand();
    if (Auswahl.equals("Starten"))
    {
      Starten();
      try
      {
        if (!Bearbeitung.isAlive())
        {
          Stop();
        }
      }
      catch (NullPointerException e) {}
    }
    if (Auswahl.equals("Stop"))
    {
      Stop();
    }
    if (Auswahl.equals("Weiter"))
    {
      Weiter();
    }
    if (Auswahl.equals("Lschen"))
    {
      Loeschen();
    }
    if (Auswahl.equals("Beenden"))
    {
      setVisible(false);
      dispose();
      System.exit(0);
    }

    if (Auswahl.equals("TextArea"))
    {
      Schriftart Schrift=new Schriftart("TextArea",x,SchriftwahlTextArea,SchriftwahlMenues,SchriftgroesseTextArea,
                                        SchriftgroesseMenues,SchriftstilMenues,kursivTextArea,fettTextArea,this);
      Schrift.setVisible(true);
      SchriftwahlTextArea=Schrift.getSchriftart();
      SchriftgroesseTextArea=Schrift.getSchriftgroesse();
      SchriftstilTextArea=Schrift.getSchriftstil();
      kursivTextArea=Schrift.getKursiv();
      fettTextArea=Schrift.getFett();
      TextAusgabe.setFont(new Font(SchriftwahlTextArea,SchriftstilTextArea,SchriftgroesseTextArea));
    }

    if (Auswahl.equals("Menues"))
    {
      Schriftart Schrift=new Schriftart("Menues",x,SchriftwahlMenues,SchriftwahlMenues,SchriftgroesseMenues,
                                        SchriftgroesseMenues,SchriftstilMenues,kursivMenues,fettMenues,this);
      Schrift.setVisible(true);
      SchriftwahlMenues=Schrift.getSchriftart();
      SchriftgroesseMenues=Schrift.getSchriftgroesse();
      SchriftstilMenues=Schrift.getSchriftstil();
      kursivMenues=Schrift.getKursiv();
      fettMenues=Schrift.getFett();
      buttonStarten.setFont(new Font(SchriftwahlMenues,SchriftstilMenues,SchriftgroesseMenues));
      buttonStopWeiter.setFont(new Font(SchriftwahlMenues,SchriftstilMenues,SchriftgroesseMenues));
      buttonLoeschen.setFont(new Font(SchriftwahlMenues,SchriftstilMenues,SchriftgroesseMenues));
    }

    if (Auswahl.equals("Grafik"))
    {
      Schriftart Schrift=new Schriftart("Grafik",x,SchriftwahlGrafik,SchriftwahlMenues,SchriftgroesseGrafik,
                                        SchriftgroesseMenues,SchriftstilMenues,kursivGrafik,fettGrafik,this);
      Schrift.setVisible(true);
      SchriftwahlGrafik=Schrift.getSchriftart();
      SchriftgroesseGrafik=Schrift.getSchriftgroesse();
      SchriftstilGrafik=Schrift.getSchriftstil();
      kursivGrafik=Schrift.getKursiv();
      fettGrafik=Schrift.getFett();
      zeichnen.setFont(new Font(SchriftwahlGrafik,SchriftstilGrafik,SchriftgroesseGrafik));
    }

    if (Auswahl.equals("Hilfe"))
    {
      Hilfe help=new Hilfe(SchriftwahlMenues,SchriftstilMenues,SchriftgroesseMenues);
      help.setVisible(true);
    }
    if (Auswahl.equals("Info"))
    {
      Info inf=new Info(SchriftwahlMenues,SchriftstilMenues,SchriftgroesseMenues);
      inf.setVisible(true);
    }
  }
}
