/**
 * Die Klasse Hilfe beinhaltet ein neues Fenster in dem einfach nur ein Text
 * steht. Zum schliessen des Fenster wird ein Button erstellt. Um eine Maus-
 * aktion wirksam werden zu lassen wird auch der ActionListener implementiert.
 * @author Alexander Schneider, Christian Ongyert, Tobias Kieninger
*/

package GrafischeOberflaeche;

import java.awt.*;
import java.awt.event.*;

public class Hilfe
  extends Frame
  implements ActionListener
{
  public Hilfe(String SchriftwahlMenues,int SchriftstilMenues,int SchriftgroesseMenues)
  {
    super("Hilfe");

    Toolkit tk=Toolkit.getDefaultToolkit();
    Dimension Dim=tk.getScreenSize();
    float MonitorWeite=Dim.width;
    float MonitorHoehe=Dim.height;
    setSize(((int)MonitorWeite/4)*3, ((int)MonitorHoehe/4)*3);
    setLocation((int)((MonitorWeite/8)+((MonitorWeite/1024)*100)),
                (int)((MonitorHoehe/8)+((MonitorHoehe/768)*50)));

    Panel panel1=new Panel();
    panel1.setLayout(new GridLayout(4,1));
    panel1.setBackground(Color.cyan);
    panel1.setForeground(Color.black);
    Font Menues=new Font(SchriftwahlMenues,SchriftstilMenues,SchriftgroesseMenues);
    Label label1=new Label(" Wenn man um dieses Programm zu bedienen");
    label1.setFont(Menues);
    Label label2=new Label(" Hilfe bentigt, sollte man den PC besser");
    label2.setFont(Menues);
    Label label3=new Label(" verkaufen, oder einem der Programmierer");
    label3.setFont(Menues);
    Label label4=new Label(" schenken.");
    label4.setFont(Menues);
    panel1.add(label1);
    panel1.add(label2);
    panel1.add(label3);
    panel1.add(label4);

    Panel panel2=new Panel();
    panel2.setLayout(new FlowLayout(FlowLayout.CENTER));
    panel2.setBackground(Color.cyan);
    panel2.setForeground(Color.black);
    panel2.setFont(Menues);
    Button button=new Button();
    button=new Button("schlieen");
    button.addActionListener(this);
    panel2.add(button);

    setLayout(new BorderLayout());
    add("Center",panel1);
    add("South",panel2);
    addWindowListener(new WindowAdapter()
    {
      public void windowClosing(WindowEvent event)
      {
        endDialog();     
      }
    });
    pack();
    setResizable(false);
  }

  public void actionPerformed(ActionEvent event)
  {
    String Auswahl=event.getActionCommand();
    if (Auswahl.equals("schlieen"))
    {
      endDialog();
    }
  }

  void endDialog()
  {
    setVisible(false);
    dispose();
  }
}
