/**
 * Die Klasse Schriftart dient zur Aenderung der Schriftart. Die Variablen
 * stehen im Kopf, da sie fuer mehrere Methoden verwendet werden. Waehlt
 * man eine Schriftart und benutzt den Abbruch-Button, so aendert sich die
 * Schriftart nicht. Sie wird nur uebernommen, wenn man den OK-Button be-
 * taetigt. Die Auswahl der Schriftart wird in einer CheckboxGroup gemacht,
 * so dass nur eine Schriftart aktiv gewaehlt werden kann.
 * @author Alexander Schneider, Christian Ongyert, Tobias Kieninger
*/

package GrafischeOberflaeche;

import java.awt.*;
import java.awt.event.*;

public class Schriftart
  extends Dialog
  implements ActionListener, ItemListener
{
  private String Schriftwahl;
  private String SchriftwahlMenues;
  private String gewaehlteGroesse;
  private String welcheSchriftart;
  private String sSchriftgroessen[];

  private int Schriftgroesse;
  private int SchriftgroesseMenues;
  private int SchriftgroesseSave;
  private int Schriftstil;
  private int SchriftstilMenues;
  private int iSchriftgroessen[];

  private float x;

  private boolean kursiv;
  private boolean kursivMenues;
  private boolean fett;
  private boolean fettMenues;
  private boolean kursivSave;
  private boolean fettSave;
  private boolean geaendertGroesse=false;
  private boolean geaendertStil=false;

  private Checkbox Box1;
  private Checkbox Box2; 
  private Choice choice1;
  private CheckboxGroup Group1;

  public Schriftart(String welcheSchriftart,float _x,String _Schriftwahl,String _SchriftwahlMenues,int _Schriftgroesse,
                    int _SchriftgroesseMenues,int _SchriftstilMenues,boolean _kursiv,boolean _fett,Frame parent)
  {
    super(parent,"Schriftart-"+welcheSchriftart,true);
    Toolkit tk=Toolkit.getDefaultToolkit();
    Dimension Dim=tk.getScreenSize();
    String Schriftarten[] = Toolkit.getDefaultToolkit().getFontList();
    float MonitorWeite=Dim.width;
    float MonitorHoehe=Dim.height;
    setSize(((int)MonitorWeite/4)*3, ((int)MonitorHoehe/4)*3);
    setLocation((int)((MonitorWeite/8)+((MonitorWeite/1024)*100)),
                (int)((MonitorHoehe/8)+((MonitorHoehe/768)*50)));

    Schriftwahl=_Schriftwahl;
    SchriftwahlMenues=_SchriftwahlMenues;
    Schriftgroesse=_Schriftgroesse;
    gewaehlteGroesse=String.valueOf(Schriftgroesse);
    SchriftgroesseMenues=_SchriftgroesseMenues;
    SchriftstilMenues=_SchriftstilMenues;
    kursiv=_kursiv;
    fett=_fett;
    x=_x;

    /**
     * Berechnung der Schriftgroessen
    */

    iSchriftgroessen=new int [8];
    sSchriftgroessen=new String [8];
    for (int i=0;i<iSchriftgroessen.length;i++)
    {
      if (welcheSchriftart.equals("Grafik"))
      {
        iSchriftgroessen[i]=(int) (11*x)+i-3;
      }
      else
      {
        iSchriftgroessen[i]=(int) (11*x)+i+2;
      }
    }

    /**
     * Erstellen der Schriftarten Checkboxes.
    */
 
    Panel panel1=new Panel();
    Panel panel2=new Panel();
    Panel panel3=new Panel();
    Panel panel4=new Panel();
    Panel panel5=new Panel();
    Panel panel6=new Panel();
    Panel panel7=new Panel();
    Panel panel8=new Panel();

    panel1.setBackground(Color.cyan);
    panel1.setForeground(Color.black);
    panel1.setLayout(new FlowLayout(FlowLayout.LEFT));
    panel2.setBackground(Color.cyan);
    panel2.setForeground(Color.black);
    panel2.setLayout(new FlowLayout());
    panel3.setBackground(Color.cyan);
    panel3.setForeground(Color.black);
    panel3.setLayout(new GridLayout(Schriftarten.length,1));
    panel4.setBackground(Color.cyan);
    panel4.setForeground(Color.black);
    panel4.setLayout(new FlowLayout(FlowLayout.LEFT));
    panel5.setBackground(Color.cyan);
    panel5.setForeground(Color.black);
    panel5.setLayout(new FlowLayout(FlowLayout.LEFT));
    panel6.setBackground(Color.cyan);
    panel6.setForeground(Color.black);
    panel6.setLayout(new FlowLayout());
    panel7.setBackground(Color.cyan);
    panel7.setForeground(Color.black);
    panel7.setLayout(new FlowLayout());
    panel8.setBackground(Color.cyan);
    panel8.setForeground(Color.black);
    panel8.setLayout(new GridLayout(4,1));

    Group1=new CheckboxGroup();

    for (int i=0;i<Schriftarten.length;i++)
    {
      Checkbox cbg=new Checkbox((String)Schriftarten[i],Group1,getAktiveSchriftart(Schriftarten[i]));
      cbg.setFont(new Font((String)Schriftarten[i],SchriftstilMenues,SchriftgroesseMenues));
      panel3.add(cbg);
      panel1.add(panel3);
    }

    /**
     * Erstellen der Buttons.
    */
    
    panel2.setFont(new Font(SchriftwahlMenues,SchriftstilMenues,SchriftgroesseMenues));
    Button button=new Button();
    button=new Button("OK");
    button.addActionListener(this);
    panel2.add(button);
    button=new Button("Abbruch");
    button.addActionListener(this);
    panel2.add(button);

    panel4.setFont(new Font(SchriftwahlMenues,Font.ITALIC,SchriftgroesseMenues));
    Box1=new Checkbox("kursiv",kursiv);
    Box1.addItemListener(this);
    panel4.add(Box1);
    panel5.setFont(new Font(SchriftwahlMenues,Font.BOLD,SchriftgroesseMenues));
    Box2=new Checkbox("fett",fett);
    Box2.addItemListener(this);
    panel5.add(Box2);

    Label label=new Label("Schriftgre: "+gewaehlteGroesse);
    panel6.setFont(new Font(SchriftwahlMenues,SchriftstilMenues,SchriftgroesseMenues));
    panel6.add(label);

    choice1=new Choice();
    choice1.addItemListener(this);
/*
    choice1.addItem("10");
    choice1.addItem("11");
    choice1.addItem("12");
    choice1.addItem("14");
    choice1.addItem("16");
    choice1.addItem("18");
    choice1.addItem("20");
    choice1.addItem("22");
    choice1.addItem("24");
    choice1.addItem("25");
    choice1.addItem("26");
*/
    for (int i=0;i<sSchriftgroessen.length;i++)
    {
      sSchriftgroessen[i]=String.valueOf(iSchriftgroessen[i]);
      choice1.addItem(sSchriftgroessen[i]);
    }
    choice1.select(gewaehlteGroesse);
    panel7.setFont(new Font(SchriftwahlMenues,SchriftstilMenues,SchriftgroesseMenues));
    panel7.add(choice1);

    panel8.add(panel4);
    panel8.add(panel5);
    panel8.add(panel6);
    panel8.add(panel7);
    panel1.add(panel8);

    setBackground(Color.cyan);
    setLayout(new BorderLayout());
    add("Center",panel1);
    add("South",panel2);

    addWindowListener(new WindowAdapter()
    {
      public void windowClosing(WindowEvent event)
      {
        endDialog();     
      }
    });
    pack();
    setResizable(false);
  }

  public void itemStateChanged(ItemEvent event)
  {
    String getEvent=(String)event.getItem();
    if ((getEvent.equals("kursiv")) || (getEvent.equals("fett")))
    {
      if (Box1.getState())
      {
        kursivSave=true;
      }
      else
      {
        kursivSave=false;
      }
      if (Box2.getState())
      {
        fettSave=true;
      }
      else
      {
        fettSave=false;
      }
      geaendertStil=true;
    }
    else
    {
      String Groesse=choice1.getSelectedItem();
      SchriftgroesseSave=Integer.valueOf(Groesse).intValue();
      geaendertGroesse=true;
    }
  }

  /**
   * Hier wird ueberprueft, welcher Button gedrueckt wurde. Wurde der OK
   * Button getrueckt, wird die Schriftart geaendert. Andernfalls wird das
   * Fenster ohne Aenderung verlassen.
  */

  public void actionPerformed(ActionEvent event)
  {
    String Auswahl=event.getActionCommand();
    if (Auswahl.equals("Abbruch"))
    {
      endDialog();
    }
    if (Auswahl.equals("OK"))
    {
      getAenderungen();
      endDialog();
    }
  }

  void endDialog()
  {
    setVisible(false);
    dispose();
    ((Window)getParent()).toFront();
    getParent().requestFocus();
  }

  /**
   * Hier wird die Schriftart an die Klasse GrafischeOberflaeche zurueck ge-
   * geben.
  */

  void getAenderungen()
  {
    Checkbox SchriftParameter=Group1.getSelectedCheckbox();
    Schriftwahl=SchriftParameter.getLabel();
    if (geaendertGroesse)
    { 
      Schriftgroesse=SchriftgroesseSave;
    }
    if (geaendertStil)
    {
      kursiv=kursivSave;
      fett=fettSave;
    }
  }

  String getSchriftart()
  {
    return Schriftwahl;
  }

  int getSchriftgroesse()
  {
    return Schriftgroesse;
  }

  int getSchriftstil()
  {
    if ((!kursiv) && (!fett))
    {
      Schriftstil=0;
    }
    if ((!kursiv) && (fett))
    {
      Schriftstil=1;
    }
    if ((kursiv) && (!fett))
    {
      Schriftstil=2;
    }
    if ((kursiv) && (fett))
    {
      Schriftstil=3;
    }
    return Schriftstil;
  }

  boolean getKursiv()
  {
    return kursiv;
  }

  boolean getFett()
  {
    return fett;
  }

  /**
   * Hier wird die aktuelle Schriftart gesetzt, so dass die zuletzt gewaehlte
   * Schriftart angezeigt wird.
  */

  boolean getAktiveSchriftart(String Schriftart)
  {
    if (Schriftwahl==Schriftart)
    {
      return true;
    }
    else
    {
      return false;
    }
  }
}
