/**
 * Die Klasse Fertigungsmodul ist die Oberklasse aller weiteren Klassen.
 * Durch sie ist es moeglich, die Werkstuecke durch die Abteilungen durch-
 * zureichen. Hier wird nur der Nachfolger bestimmt und die Methoden Eingang
 * und Ausgang bekannt gemacht. Ausserdem werden alle Objekte und Variablen,die von 
 * den abgeleiteten Klassen benoetigt werden deklariert.
 * @author Alexander Schneider, Christian Ongyert, Tobias Kieninger
*/

package Steuerung;

import java.util.*;
import java.awt.*;
import GrafischeOberflaeche.*;

public abstract class Fertigungsmodul extends Thread
{
  protected Fertigungsmodul Nachfolger;
  protected Werkstueck Rohling;
  protected TextArea TextAusgabe;
  protected Grafik zeichnen;
  protected Delay Warten;

  protected String Name;
  protected int Schriftgroesse;

  protected Vector WerkstueckListe;
  protected boolean inArbeit;
  protected boolean Bereit=true;

  public Fertigungsmodul(Fertigungsmodul _Nachfolger,Werkstueck _Rohling,
                         TextArea _TextAusgabe,Grafik _zeichnen,Delay _Warten,
                         String _Name,int _Schriftgroesse)
  {
    Nachfolger = _Nachfolger;
    Rohling = _Rohling;
    TextAusgabe = _TextAusgabe;
    zeichnen = _zeichnen;
    Warten = _Warten;

    Name = _Name;
    Schriftgroesse = _Schriftgroesse;

    WerkstueckListe = new Vector();
  }

  protected boolean getStatus()
  {
    return Bereit;
  }

  protected abstract void Eingang(Werkstueck _Rohling);

  protected void Ausgang()
  {
    Nachfolger.Eingang(Rohling);
    inArbeit=false;
  }
}
