/**
 * Die Klasse Fliessband wird benoetigt, um zwischen den Maschinen eine Verbindung
 * herzustellen. Die Klasse ist natuerlich von Fertigungsmodul abgeleitet und fuer die 
 * Textausgabe bekommt sie die Methode TextAusgabe uebergeben. Saemtliche Objekte, die
 * von jeder Klasse, die von Fertigungsmodul abgeleitet sind benoetigt werden, werden mit
 * super() an den Konstruktor der Klasse Fertigungsmodul uebergeben. Dort werden sie als
 * protected deklariert, um von allen Klassen aus zugreifen zu koennen.
 * @author Alexander Schneider, Christian Ongyert, Tobias Kieninger
*/

package Steuerung;

import java.awt.*;
import GrafischeOberflaeche.*;

public class Fliessband extends Fertigungsmodul
{
  private Fertigungsmodul Nachfolger1;

  public Fliessband(Fertigungsmodul _Nachfolger1,Werkstueck _Rohling,TextArea _TextAusgabe,
                    Grafik _zeichnen,Delay _Warten,int _Schriftgroesse,String _Name)
  {
    super(_Nachfolger1,_Rohling,_TextAusgabe,_zeichnen,_Warten,_Name,_Schriftgroesse);
    Nachfolger1 = _Nachfolger1;
  }

/**
 * Um eine parallel-Bearbeitung verwirklichen zu koennen, wird die run-Methode
 * implementiert.
 */

  public void run()
  {
    while (true)
    {
      if (!WerkstueckListe.isEmpty())
        Bearbeiten();
      Warten.Zeit(50);
    }
  }

/**
 * Die draw-Methode zeichnet die Fliessbaender. Man haette diese Methode in Fertigungs-
 * modul implementieren koennen, jedoch sollen sich die einzelnen Module selber zeichnen.
 * So mu man eben in jedem Modul die draw-Methode implementieren. Sie bekommt die
 * x-Position, y-Position, weite und hoehe uebergeben.
 */

  public void draw(int xBeginPos,int yBeginPos,int xEndPos,int yEndPos,Graphics Grafik)
  {
    if (inArbeit)
    {
      Grafik.setColor(new Color(255,0,0));
    }
    else
      Grafik.setColor(new Color(0,0,0));
    Grafik.drawLine(xBeginPos,yBeginPos,xEndPos,yEndPos);
    Grafik.setColor(new Color(0,0,0));
  }    

/**
 * Im Ausgang wird ein Werkstueck der WerkstueckListe an den Nachfolger weitergegeben, 
 * vorausgesetzt es sind Werkstuecke in der Liste vorhanden. Hier gilt das Prinzip, was
 * auch sinnvoll ist: First in - First out.
 */

  protected void Ausgang()
  {
    if (!WerkstueckListe.isEmpty())
    {
      Nachfolger1.Eingang((Werkstueck)WerkstueckListe.firstElement());
      WerkstueckListe.removeElementAt(0);
      zeichnen.repaint();
    }
  }

/**
 * In der Eingangs-methode bekommt das Fliessband ein Werkstueck von seinem Vorgaenger.
 * In diesem Fall ist das Fliessband belegt, deshalb mu die boolean-Variable wahr gesetzt
 * werden. Das hereinkommende Werkstueck wird zur Werkstueckliste hinzugefuegt.
 */

  protected void Eingang(Werkstueck _Rohling)
  {
    inArbeit=true;

    Rohling = _Rohling;
    TextAusgabe.append("Flieband transportiert Werkstck Nr. "+
                       Rohling.getMaterialNummer()+" mit der ZN "+
                       Rohling.getZeichnungsNummer()+" "+Name+"\n");
    WerkstueckListe.addElement(Rohling);
    zeichnen.repaint();
  }

/**
 * Hier wird das Werkstueck transportiert, was natuerlich Zeit dauert. Nach dem Transport
 * wird, wenn die Werkstueckliste leer ist die inArbeit-Variable auf falsch gesetzt, da
 * das Fliessband nicht mehr belegt ist. Wenn der Transport abgeschlossen ist, wird die
 * Ausgangsmethode aufgerufen.
 */

  protected void Bearbeiten()
  {
    Warten.Zeit(2000);

    while (!Nachfolger1.getStatus())
    {
      int ZufallsZeit=(int)(Math.random()*100);
      Warten.Zeit(ZufallsZeit);
    }
    if (WerkstueckListe.size() <= 1)
    {
      inArbeit=false;
    }

    Ausgang();
  }
}
