/**
 * Die Klasse Kontrolle ist abgeleitet von Fertigungsmodul und bekommt fuer
 * die Textausgabe die Methode TextAusgabe uebergeben. Die Klasse ist als
 * final deklariert, da von ihr keine weiteren Klassen abgeleitet werden.
 * Die Klasse besitzt die Methode Eingang, um die Werkstuecke entgegen zu
 * nehmen. Die Klasse Ausgang wird benoetigt, um das Werkstueck entweder an
 * das Ausschusslager oder Endlager zu uebergeben.
 * @author Alexander Schneider, Christian Ongyert, Tobias Kieninger
*/

package Steuerung;

import java.util.*;
import java.awt.*;
import GrafischeOberflaeche.*;

public final class Kontrolle extends Fertigungsmodul
{
  private Fertigungsmodul EL;
  private Fertigungsmodul AL;

  public Kontrolle(Fertigungsmodul _Nachfolger1,Fertigungsmodul _Nachfolger2,
                   Werkstueck _Rohling,TextArea _TextAusgabe,Grafik _zeichnen,
                   Delay _Warten,int _Schriftgroesse,String _Name)
  {
    super(_Nachfolger1,_Rohling,_TextAusgabe,_zeichnen,_Warten,_Name,_Schriftgroesse);
    EL = _Nachfolger1;
    AL = _Nachfolger2;
  }

/**
 * Um eine parallel-Bearbeitung verwirklichen zu koennen, wird die run-Methode
 * implementiert.
 */

  public void run()
  {
    while (true)
    {
      if (!WerkstueckListe.isEmpty())
        Bearbeiten();
      Warten.Zeit(50);
    }
  }

/**
 * Die draw-Methode zeichnet die Fliessbaender. Man haette diese Methode in Fertigungs-
 * modul implementieren koennen, jedoch sollen sich die einzelnen Module selber zeichnen.
 * So mu man eben in jedem Modul die draw-Methode implementieren. Sie bekommt die
 * x-Position, y-Position, weite und hoehe uebergeben.
 */

  public void draw(int xPos,int yPos,int width,int height,Graphics Grafik)
  {
    if (inArbeit) 
    {
      Grafik.setColor(new Color(255,0,0));
      Grafik.fillRect(xPos,yPos,width,height);
      Grafik.setColor(new Color(0,0,0));
    }
    Grafik.drawRect(xPos,yPos,width,height);
    int StringPosX=xPos+3;
    int StringPosY=yPos+Schriftgroesse+3;
    Grafik.drawString(Name,StringPosX,StringPosY);
  }

/**
 * In der Eingangs-methode bekommt die Kontrolle ein Werkstueck von seinem Vorgaenger.
 * In diesem Fall ist die Kontrolle belegt, deshalb mu die boolean-Variable inArbeit
 * wahr gesetzt werden. Die boolean-Variable Bereit wird auf falsch gesetzt, da die
 * Konrolle nun keine weiteren Werkstuecke entgegen nehmen kann. Um zu verhindern, da
 * mehrere Threads gleichzeitig auf die Methode zugreifen, wird der Methode der Parameter
 * synchronized hinzugefuegt. Das hereinkommende Werkstueck wird zur Werkstueckliste
 * hinzugefuegt. Eigentlich wird keine Liste benoetigt, da nur ein Werkstueck gleichzeitig
 * in der Kontrolle sein kann.
 */

  protected synchronized void Eingang(Werkstueck _Rohling)
  {
    inArbeit=true;
    Bereit=false;

    Rohling = _Rohling;
    WerkstueckListe.addElement(Rohling);
    zeichnen.repaint();

// solange die Bearbeitung nicht abgeschlossen ist
    while (!Bereit)
    {
      Warten.Zeit(50);
    }

/**
 * Es wird die Ausschuss-Methode aufgerufen, um eine zufaellige Anzahl von Ausschuss zu
 * erhalten.
 */

    if (Ausschuss())
    {            
      TextAusgabe.append("Werkstck Nr. "+Rohling.getMaterialNummer()+" mit der ZN "+
                         Rohling.getZeichnungsNummer()+" ist durch die "+Name+
                         " gefallen.\n");
      Ausgang(AL);
    }
    else
    {      
      TextAusgabe.append("Werkstck Nr. "+Rohling.getMaterialNummer()+" mit der ZN "+
                         Rohling.getZeichnungsNummer()+" ist in Ordnung.\n");
      Ausgang(EL);
    }
  }

/**
 * Im Ausgang wird ein Werkstueck der WerkstueckListe an den Nachfolger weitergegeben, 
 * vorausgesetzt es sind Werkstuecke in der Liste vorhanden. Hier gilt das Prinzip, was
 * auch sinnvoll ist: First in - First out.
 */

  protected void Ausgang(Fertigungsmodul _Lagern)
  {
   if (!WerkstueckListe.isEmpty())
    {
      _Lagern.Eingang((Werkstueck)WerkstueckListe.firstElement());
      WerkstueckListe.removeElementAt(0);
      zeichnen.repaint();
    }
  }

/**
 * Hier wird das Werkstueck bearbeitet, was natuerlich Zeit dauert. Nach der Bearbeitung
 * wird, wenn die Werkstueckliste leer ist die inArbeit-Variable auf falsch gesetzt, da
 * die Kontrolle nicht mehr belegt ist.
 */

  protected void Bearbeiten()
  {
    TextAusgabe.append("Werkstck Nr. "+Rohling.getMaterialNummer()+" mit der ZN "+
                       Rohling.getZeichnungsNummer()+" wird in der "+Name+
                       " kontrolliert.\n");
    Warten.Zeit(4000);
    if (WerkstueckListe.size() <= 1)
    {
      inArbeit=false;
    }
    Bereit=true;
  }

  /**
   * Die Methode Ausschuss wird benutzt, um einen zufaelligen Anteil an
   * Ausschuss zu erhalten.
  */

  private boolean Ausschuss()
  {
    int AusschussRandom;
    AusschussRandom=(int)(Math.random()*100);
    if ((AusschussRandom>40) && (AusschussRandom<60))
    {
      return true;
    }
    else
    {
      return false;
    }
  }
}
