/**
 * Die Klasse Lager beinhaltet sowohl das Materiallager als auch das End-
 * lager und Ausschusslager.
 * Mit der Methode initialisieren werden zuerst alle Objekte der Werkstuecke
 * angelegt, um sie dann nacheinander wieder herausholen zu koennen. Dabei
 * wird eine Liste mit einem Vektor benutzt.
 * @author Alexander Schneider, Christian Ongyert, Tobias Kieninger
*/

package Steuerung;

import java.awt.*;
import GrafischeOberflaeche.*;

public class Lager extends Fertigungsmodul
  implements Runnable
{
  private Fertigungsmodul Nachfolger1;
  private Fertigungsmodul Nachfolger2;
  private Fertigungsmodul Nachfolger3;

  private int LetztesWerkstueck;
  private int MatAnzahl123=0;
  private int MatAnzahl132=0;
  private int MatAnzahl213=0;
  private int MatAnzahl231=0;
  private int MatAnzahl312=0;
  private int MatAnzahl321=0;
  private int MatAnzahl111=0;

  private boolean Start;

  public Lager(Fertigungsmodul _Nachfolger1,Fertigungsmodul _Nachfolger2,
               Fertigungsmodul _Nachfolger3,Werkstueck _Rohling,TextArea _TextAusgabe,
               Grafik _zeichnen,Delay _Warten,int _Schriftgroesse,String _Name)
  {
    super(_Nachfolger1,_Rohling,_TextAusgabe,_zeichnen,_Warten,_Name,_Schriftgroesse);
    Nachfolger1 = _Nachfolger1;
    Nachfolger2 = _Nachfolger2;
    Nachfolger3 = _Nachfolger3;
    Bereit=true;
  }

/**
 * Um eine parallel-Bearbeitung verwirklichen zu koennen, wird die run-Methode
 * implementiert. Jede 500 ms wird ein Werkstueck aus dem Materiallager ausgegeben.
 */

  public void run()
  {
    while (true)
    {
      while (Start)
      {
        Ausgang();
        Warten.Zeit(500);
      }
      Warten.Zeit(50);
    }
  }

// um die Fertigung zu starten
  public void starten()
  {
    Start=true;
  }

// um die Fertigung zu stoppen
  public void stoppen()
  {
    Start=false;
  }

/**
 * Die draw-Methode zeichnet die Lager. Man haette diese Methode in Fertigungs-
 * modul implementieren koennen, jedoch sollen sich die einzelnen Module selber zeichnen.
 * So mu man eben in jedem Modul die draw-Methode implementieren. Sie bekommt die
 * x-Position, y-Position, weite und hoehe uebergeben.
 */

  public void draw(int xPos,int yPos,int width,int height,String Anzahl,
                   Graphics Grafik)
  {
    if (inArbeit) 
    {
      Grafik.setColor(new Color(255,0,0));
      Grafik.fillRect(xPos,yPos,width,height);
      Grafik.setColor(new Color(0,0,0));
    }
    Grafik.drawRect(xPos,yPos,width,height);
    int StringPosX=xPos+3;
    int StringPosY=yPos+Schriftgroesse+3;
    Grafik.drawString(Name,StringPosX,StringPosY);

    Grafik.drawString("Anzahl: "+Anzahl,StringPosX,yPos+height-5);
  }

  /**
   * Hier wird die Anzahl der sich im Lager befindlichen Werkstuecke zurueck-
   * gegeben.
  */

  int getAnzahl()
  {
    return WerkstueckListe.size();
  }

  int getAnzahlML()
  {
    return LetztesWerkstueck;
  }

  int getAnzahl123()
  {
    return MatAnzahl123;
  }

  int getAnzahl132()
  {
    return MatAnzahl132;
  }

  int getAnzahl213()
  {
    return MatAnzahl213;
  }

  int getAnzahl231()
  {
    return MatAnzahl231;
  }

  int getAnzahl312()
  {
    return MatAnzahl312;
  }

  int getAnzahl321()
  {
    return MatAnzahl321;
  }

  int getAnzahl111()
  {
    return MatAnzahl111;
  }

  /**
   * Methode wurde oben beschrieben
  */

  void initialisieren(Werkstueck _Rohling)
  {
    Rohling = _Rohling;
    if (Rohling.getZeichnungsNummer() == 123)
      MatAnzahl123++;
    if (Rohling.getZeichnungsNummer() == 132)
      MatAnzahl132++;
    if (Rohling.getZeichnungsNummer() == 213)
      MatAnzahl213++;
    if (Rohling.getZeichnungsNummer() == 231)
      MatAnzahl231++;
    if (Rohling.getZeichnungsNummer() == 312)
      MatAnzahl312++;
    if (Rohling.getZeichnungsNummer() == 321)
      MatAnzahl321++;
    if (Rohling.getZeichnungsNummer() == 111)
      MatAnzahl111++;
    WerkstueckListe.addElement(Rohling);
    LetztesWerkstueck=WerkstueckListe.size();
    inArbeit=true;
  }

  /**
   * Hier wird ein Objekt des Werkstuecks zur Liste hinzugefuegt. In welches Lager haengt
   * davon ab, welches der Nachfolger nach der Kontrolle gewesen ist. Hierbei wird unter-
   * schieden, welche Zeichnungsnummer das Werkstueck hat.
  */

  protected void Eingang(Werkstueck _Rohling)
  {
    inArbeit=true;

    Rohling = _Rohling;
    if (Rohling.getZeichnungsNummer() == 123)
      MatAnzahl123++;
    if (Rohling.getZeichnungsNummer() == 132)
      MatAnzahl132++;
    if (Rohling.getZeichnungsNummer() == 213)
      MatAnzahl213++;
    if (Rohling.getZeichnungsNummer() == 231)
      MatAnzahl231++;
    if (Rohling.getZeichnungsNummer() == 312)
      MatAnzahl312++;
    if (Rohling.getZeichnungsNummer() == 321)
      MatAnzahl321++;
    if (Rohling.getZeichnungsNummer() == 111)
      MatAnzahl111++;
    WerkstueckListe.addElement(Rohling);
    zeichnen.repaint();
  }
  
  /**
   * In der Methode Ausgang wird sicherheitshalber noch einmal ueberprueft,
   * ob auch wirklich noch Werkstuecke vorhanden sind. Dann wird ein Werk-
   * stueck weitergegeben und aus der Liste entfernt. Abhaengig von der Zeichnungsnummer
   * wird der Nachfolger bestimmt.
  */

  protected void Ausgang()
  {    
    if (!WerkstueckListe.isEmpty())
    {
      if (WerkstueckListe.size() <= 1)
        inArbeit=false;
      LetztesWerkstueck--;
      Rohling = ((Werkstueck)WerkstueckListe.lastElement());
      if (Rohling.getZeichnungsNummer() == 123)
        MatAnzahl123--;
      if (Rohling.getZeichnungsNummer() == 132)
        MatAnzahl132--;
      if (Rohling.getZeichnungsNummer() == 213)
        MatAnzahl213--;
      if (Rohling.getZeichnungsNummer() == 231)
        MatAnzahl231--;
      if (Rohling.getZeichnungsNummer() == 312)
        MatAnzahl312--;
      if (Rohling.getZeichnungsNummer() == 321)
        MatAnzahl321--;
      if (Rohling.getZeichnungsNummer() == 111)
        MatAnzahl111--;

      if ((Rohling.getZeichnungsNummer() == 123) || (Rohling.getZeichnungsNummer() == 132)
       || (Rohling.getZeichnungsNummer() == 213) || (Rohling.getZeichnungsNummer() == 231))
        Nachfolger1.Eingang((Werkstueck)WerkstueckListe.lastElement());
      if ((Rohling.getZeichnungsNummer() == 312) || (Rohling.getZeichnungsNummer() == 321))
        Nachfolger2.Eingang((Werkstueck)WerkstueckListe.lastElement());
      if ((Rohling.getZeichnungsNummer() == 111))
        Nachfolger3.Eingang((Werkstueck)WerkstueckListe.lastElement());
      WerkstueckListe.removeElementAt(LetztesWerkstueck);
      zeichnen.repaint();
    }
    else
      stoppen();
  }
}
