/**
 * @author Alexander Schneider, Christian Ongyert, Tobias Kieninger
*/

package Steuerung;

import java.awt.*;
import GrafischeOberflaeche.*;

public class Maschine1 extends Maschine
{
  private Fertigungsmodul Nachfolger1;
  private Fertigungsmodul Nachfolger2;
  private Fertigungsmodul Nachfolger3;

  public Maschine1(Fertigungsmodul _Nachfolger1,Fertigungsmodul _Nachfolger2,
                   Fertigungsmodul _Nachfolger3,Werkstueck _Rohling,TextArea _TextAusgabe,
                   Grafik _zeichnen,Delay _Warten,int _Schriftgroesse,String _Name)
  {
    super(_Nachfolger1,_Rohling,_TextAusgabe,_zeichnen,_Warten,_Name,_Schriftgroesse);
    Nachfolger1 = _Nachfolger1;
    Nachfolger2 = _Nachfolger2;
    Nachfolger3 = _Nachfolger3;
  }

/**
 * Um eine parallel-Bearbeitung verwirklichen zu koennen, wird die run-Methode
 * implementiert.
 */

  public void run()
  {
    while (true)
    {
      if (!WerkstueckListe.isEmpty())
        Bearbeiten();
      Warten.Zeit(50);
    }
  }

/**
 * In der Eingangs-methode bekommt die Maschine ein Werkstueck von seinem Vorgaenger.
 * In diesem Fall ist die Maschine belegt, deshalb mu die boolean-Variable inArbeit
 * wahr gesetzt werden. Die boolean-Variable Bereit wird auf falsch gesetzt, da die
 * Konrolle nun keine weiteren Werkstuecke entgegen nehmen kann. Um zu verhindern, da
 * mehrere Threads gleichzeitig auf die Methode zugreifen, wird der Methode der Parameter
 * synchronized hinzugefuegt. Das hereinkommende Werkstueck wird zur Werkstueckliste
 * hinzugefuegt. Eigentlich wird keine Liste benoetigt, da nur ein Werkstueck gleichzeitig
 * auf der Maschine sein kann.
 */

  protected synchronized void Eingang(Werkstueck _Rohling)
  {
    inArbeit=true;
    Bereit=false;

    Rohling = _Rohling;
    WerkstueckListe.addElement(Rohling);
    zeichnen.repaint();

// solange die Bearbeitung nicht abgeschlossen ist
    while (!Bereit)
    {
      Warten.Zeit(50);
    }

// abhaengig von der Zeichnungsnummer wird ein anderer Nachfolger ausgewaehlt
    if (Rohling.getZeichnungsNummer() == 123)
      Ausgang(Nachfolger3);
    if (Rohling.getZeichnungsNummer() == 132)
      Ausgang(Nachfolger1);
    if (Rohling.getZeichnungsNummer() == 213)
      Ausgang(Nachfolger2);
    if (Rohling.getZeichnungsNummer() == 231)
      Ausgang(Nachfolger1);
  }

/**
 * Im Ausgang wird ein Werkstueck der WerkstueckListe an den Nachfolger weitergegeben, 
 * vorausgesetzt es sind Werkstuecke in der Liste vorhanden. Hier gilt das Prinzip, was
 * auch sinnvoll ist: First in - First out.
 */

  protected void Ausgang(Fertigungsmodul _Mat)
  {
    if (!WerkstueckListe.isEmpty())
    {
      _Mat.Eingang((Werkstueck)WerkstueckListe.firstElement());
      WerkstueckListe.removeElementAt(0);
      zeichnen.repaint();
    }
  }

/**
 * Hier wird das Werkstueck bearbeitet, was natuerlich Zeit dauert. Nach der Bearbeitung
 * wird, wenn die Werkstueckliste leer ist die inArbeit-Variable auf falsch gesetzt, da
 * die Maschine nicht mehr belegt ist.
 */

  protected void Bearbeiten()
  {
    TextAusgabe.append("Werkstck Nr. "+Rohling.getMaterialNummer()+" mit der ZN "+
                       Rohling.getZeichnungsNummer()+" wird auf der "+Name+
                       " bearbeitet.\n");
    Warten.Zeit(5000);
    if (WerkstueckListe.size() <= 1)
    {
      inArbeit=false;
    }
    Bereit=true;
  }
}
