/**
 * Die Klasse Steuerung legt alle Objekte von Maschinen, Lager, ... an und
 * uebergibt noch Parameter wie z.B. den Nachfolger eines jeden Objektes.
 * Anschliessend wird mit der Methode starteFertigung die Fertigung in Gang
 * gesetzt.
 * @author Alexander Schneider, Christian Ongyert, Tobias Kieninger
*/

package Steuerung;

import java.awt.*;
import java.util.*;
import java.io.*;
import GrafischeOberflaeche.*;

public class Steuerung
{
  private int MaterialAnzahl123;    // Variablen-Deklaration
  private int MaterialAnzahl132;
  private int MaterialAnzahl213;
  private int MaterialAnzahl231;
  private int MaterialAnzahl312;
  private int MaterialAnzahl321;
  private int MaterialAnzahl111;
  private int GesamtAnzahl;

  private int Schriftgroesse;
  private int FN; //FliessbandNummer
  private int Mod1;
  private int Mod2;
  private TextArea TextAusgabe;

  private Delay Warten;

  private Lager ML;
  private Lager EL;
  private Lager AL;
  
  private Maschine Maschine1;
  private Maschine Maschine2;
  private Maschine Maschine3;
  
  private Kontrolle QS;
  
  private Fliessband ML_Maschine1;
  private Fliessband ML_Maschine2;
  private Fliessband ML_Maschine3;
  private Fliessband Maschine1_Maschine2;
  private Fliessband Maschine1_Maschine3;
  private Fliessband Maschine2_Maschine3;
  private Fliessband Maschine1_QS;
  private Fliessband Maschine2_QS;
  private Fliessband Maschine3_QS;
  private Fliessband QS_EL;
  private Fliessband QS_AL;
  
  private Werkstueck Rohling;

  private Grafik zeichnen;
  private Font GrafikFont;

  private String NameF1,NameF2,NameF3,NameF4,NameF5,NameF6,NameF7,confName;

  private boolean LagerML,LagerEL,LagerAL,M1,M2,M3,Kontr;
  private boolean Verbindungen[]=new boolean[11];

  private float x;
  private float y;

  private int xPos[]=new int[7];
  private int yPos[]=new int[7];
  private int width[]=new int[7];
  private int height[]=new int[7];

  private int xBegin1[]=new int[11];
  private int xBegin2[]=new int[11];
  private int yBegin1[]=new int[11];
  private int yBegin2[]=new int[11];
  private int xEnd1[]=new int[11];
  private int xEnd2[]=new int[11];
  private int yEnd1[]=new int[11];
  private int yEnd2[]=new int[11];

  public Steuerung(TextArea _TextAusgabe,Grafik _zeichnen,float _x,float _y,
                   int _Schriftgroesse,String _confName)
  {
    TextAusgabe = _TextAusgabe;
    zeichnen = _zeichnen;
    x = _x;
    y = _y;
    Schriftgroesse = _Schriftgroesse;
    confName = _confName;
  }

/**
 * Hier wird die Fertigung erstellt. Vorher wird allerdings die Methode Einstellungen
 * aufgerufen, um die Werte der ini-Datei auszulesen. Abhaengig von diesen Werten wird
 * zum Beispiel ein Objekt von Maschine3 angelegt, oder nicht. Anschliessend werden
 * Abhaengig vom Aufbau der Fertigungsstrasse die Objekte der Werkstuecke initialisiert.
 */

  public void erstelleFertigung()
  {
    Warten = new Delay();

    Einstellungen();

    if (LagerEL)
      EL=new Lager(null,null,null,Rohling,TextAusgabe,zeichnen,Warten,Schriftgroesse,
                   NameF6);
    if ((Verbindungen[9]) && (LagerEL) && (Kontr))
      QS_EL=new Fliessband(EL,Rohling,TextAusgabe,zeichnen,Warten,Schriftgroesse,"ins "+
                           NameF6+".\n");

    if (LagerAL)
      AL=new Lager(null,null,null,Rohling,TextAusgabe,zeichnen,Warten,Schriftgroesse,
                   NameF7);
    if ((Verbindungen[10]) && (LagerAL) && (Kontr))
      QS_AL=new Fliessband(AL,Rohling,TextAusgabe,zeichnen,Warten,Schriftgroesse,"ins "+
                           NameF7+".\n");

    if ((Kontr) && (!Verbindungen[9]) && (Verbindungen[10]))
      QS=new Kontrolle(null,QS_AL,Rohling,TextAusgabe,zeichnen,Warten,Schriftgroesse,
                       NameF5);
    if ((Kontr) && (Verbindungen[9]) && (!Verbindungen[10]))
      QS=new Kontrolle(QS_EL,null,Rohling,TextAusgabe,zeichnen,Warten,Schriftgroesse,
                       NameF5);
    if ((Kontr) && (Verbindungen[9]) && (Verbindungen[10]))
      QS=new Kontrolle(QS_EL,QS_AL,Rohling,TextAusgabe,zeichnen,Warten,Schriftgroesse,
                       NameF5);
    if ((Verbindungen[8]) && (Kontr) && (M3))
      Maschine3_QS=new Fliessband(QS,Rohling,TextAusgabe,zeichnen,Warten,Schriftgroesse,
                                  "in die "+NameF5+".");
    if ((Verbindungen[7]) && (Kontr) && (M2))
      Maschine2_QS=new Fliessband(QS,Rohling,TextAusgabe,zeichnen,Warten,Schriftgroesse,
                                  "in die "+NameF5+".");
    if ((Verbindungen[6]) && (Kontr) && (M1))
      Maschine1_QS=new Fliessband(QS,Rohling,TextAusgabe,zeichnen,Warten,Schriftgroesse,
                                  "in die "+NameF5+".");

    if ((M3) && (Verbindungen[8]))
      Maschine3=new Maschine3(null,null,Maschine3_QS,Rohling,TextAusgabe,zeichnen,Warten,
                              Schriftgroesse,NameF4);
    if ((Verbindungen[5]) && (M3) && (M2))
      Maschine2_Maschine3=new Fliessband(Maschine3,Rohling,TextAusgabe,zeichnen,Warten,
                                         Schriftgroesse,"zur "+NameF4+".");
    if ((Verbindungen[4]) && (M3) && (M1))
      Maschine1_Maschine3=new Fliessband(Maschine3,Rohling,TextAusgabe,zeichnen,Warten,
                                         Schriftgroesse,"zur "+NameF4+".");
    if ((Verbindungen[2]) && (M3) && (LagerML))
      ML_Maschine3=new Fliessband(Maschine3,Rohling,TextAusgabe,zeichnen,Warten,
                                  Schriftgroesse,"zur "+NameF4+".");
   
    if ((M2) && (!Verbindungen[5]) && (Verbindungen[7]))
      Maschine2=new Maschine2(null,null,Maschine2_QS,Rohling,TextAusgabe,zeichnen,Warten,
                              Schriftgroesse,NameF3);
    if ((M2) && (Verbindungen[5]) && (!Verbindungen[7]))
      Maschine2=new Maschine2(null,Maschine2_Maschine3,null,Rohling,TextAusgabe,zeichnen,
                              Warten,Schriftgroesse,NameF3);
    if ((M2) && (Verbindungen[5]) && (Verbindungen[7]))
      Maschine2=new Maschine2(null,Maschine2_Maschine3,Maschine2_QS,Rohling,TextAusgabe,
                              zeichnen,Warten,Schriftgroesse,NameF3);
    if ((Verbindungen[3]) && (M2) && (M1))
      Maschine1_Maschine2=new Fliessband(Maschine2,Rohling,TextAusgabe,zeichnen,Warten,
                                         Schriftgroesse,"zur "+NameF3+".");
    if ((Verbindungen[1]) && (M2) && (LagerML))
      ML_Maschine2=new Fliessband(Maschine2,Rohling,TextAusgabe,zeichnen,Warten,
                                  Schriftgroesse,"zur "+NameF3+".");

    if ((M1) && (!Verbindungen[3]) && (!Verbindungen[4]) && (Verbindungen[6]))
      Maschine1=new Maschine1(null,null,Maschine1_QS,Rohling,TextAusgabe,zeichnen,Warten,
                              Schriftgroesse,NameF2);
    if ((M1) && (!Verbindungen[3]) && (Verbindungen[4]) && (!Verbindungen[6]))
      Maschine1=new Maschine1(null,Maschine1_Maschine3,null,Rohling,TextAusgabe,zeichnen,
                              Warten,Schriftgroesse,NameF2);
    if ((M1) && (Verbindungen[3]) && (!Verbindungen[4]) && (!Verbindungen[6]))
      Maschine1=new Maschine1(Maschine1_Maschine2,null,null,Rohling,TextAusgabe,zeichnen,
                              Warten,Schriftgroesse,NameF2);
    if ((M1) && (!Verbindungen[3]) && (Verbindungen[4]) && (Verbindungen[6]))
      Maschine1=new Maschine1(null,Maschine1_Maschine3,Maschine1_QS,Rohling,TextAusgabe,
                              zeichnen,Warten,Schriftgroesse,NameF2);
    if ((M1) && (Verbindungen[3]) && (!Verbindungen[4]) && (Verbindungen[6]))
      Maschine1=new Maschine1(Maschine1_Maschine2,null,Maschine1_QS,Rohling,TextAusgabe,
                              zeichnen,Warten,Schriftgroesse,NameF2);
    if ((M1) && (Verbindungen[3]) && (Verbindungen[4]) && (!Verbindungen[6]))
      Maschine1=new Maschine1(Maschine1_Maschine2,Maschine1_Maschine3,null,Rohling,
                              TextAusgabe,zeichnen,Warten,Schriftgroesse,NameF2);
    if ((M1) && (Verbindungen[3]) && (Verbindungen[4]) && (Verbindungen[6]))
      Maschine1=new Maschine1(Maschine1_Maschine2,Maschine1_Maschine3,Maschine1_QS,Rohling,
                              TextAusgabe,zeichnen,Warten,Schriftgroesse,NameF2);
    if ((Verbindungen[0]) && (M1) && (LagerML))
      ML_Maschine1=new Fliessband(Maschine1,Rohling,TextAusgabe,zeichnen,Warten,
                                  Schriftgroesse,"zur "+NameF2+".");

    if ((LagerML) && (Verbindungen[2]) && (!Verbindungen[1]) && (!Verbindungen[0]))
      ML=new Lager(null,null,ML_Maschine3,Rohling,TextAusgabe,zeichnen,Warten,
                   Schriftgroesse,NameF1);
    if ((LagerML) && (!Verbindungen[2]) && (Verbindungen[1]) && (!Verbindungen[0]))
      ML=new Lager(null,ML_Maschine2,null,Rohling,TextAusgabe,zeichnen,Warten,
                   Schriftgroesse,NameF1);
    if ((LagerML) && (!Verbindungen[2]) && (!Verbindungen[1]) && (Verbindungen[0]))
      ML=new Lager(ML_Maschine1,null,null,Rohling,TextAusgabe,zeichnen,Warten,
                   Schriftgroesse,NameF1);
    if ((LagerML) && (Verbindungen[2]) && (Verbindungen[1]) && (!Verbindungen[0]))
      ML=new Lager(null,ML_Maschine2,ML_Maschine3,Rohling,TextAusgabe,zeichnen,Warten,
                   Schriftgroesse,NameF1);
    if ((LagerML) && (Verbindungen[2]) && (!Verbindungen[1]) && (Verbindungen[0]))
      ML=new Lager(ML_Maschine1,null,ML_Maschine3,Rohling,TextAusgabe,zeichnen,Warten,
                   Schriftgroesse,NameF1);
    if ((LagerML) && (!Verbindungen[2]) && (Verbindungen[1]) && (Verbindungen[0]))
      ML=new Lager(ML_Maschine1,ML_Maschine2,null,Rohling,TextAusgabe,zeichnen,Warten,
                   Schriftgroesse,NameF1);
    if ((LagerML) && (Verbindungen[2]) && (Verbindungen[1]) && (Verbindungen[0]))
      ML=new Lager(ML_Maschine1,ML_Maschine2,ML_Maschine3,Rohling,TextAusgabe,zeichnen,
                   Warten,Schriftgroesse,NameF1);

    if ((Verbindungen[0]) && (Verbindungen[6]))
      MaterialAnzahl123=5;
    if ((Verbindungen[0]) && (Verbindungen[3]) && (Verbindungen[7]))
      MaterialAnzahl132=5;
    if ((Verbindungen[0]) && (Verbindungen[4]) && (Verbindungen[8]))
      MaterialAnzahl213=5;
    if ((Verbindungen[0]) && (Verbindungen[3]) && (Verbindungen[5]) && (Verbindungen[8]))
      MaterialAnzahl231=5;
    if ((Verbindungen[1]) && (Verbindungen[7]))
      MaterialAnzahl312=5;
    if ((Verbindungen[1]) && (Verbindungen[5]) && (Verbindungen[8]))
      MaterialAnzahl321=5;
    if ((Verbindungen[2]) && (Verbindungen[8]))
      MaterialAnzahl111=5;

    MatAnz MatAnzahl=new MatAnz(MaterialAnzahl123,MaterialAnzahl132,MaterialAnzahl213,
                                MaterialAnzahl231,MaterialAnzahl312,MaterialAnzahl321,
                                MaterialAnzahl111,Rohling,ML);

    while((!MatAnzahl.getStatus123()) || (!MatAnzahl.getStatus132()) || 
          (!MatAnzahl.getStatus213()) || (!MatAnzahl.getStatus231()) || 
          (!MatAnzahl.getStatus312()) || (!MatAnzahl.getStatus321()) || 
          (!MatAnzahl.getStatus111()))
    {
      int ZeichnungsNummer=(int)(Math.random()*100);
      if ((ZeichnungsNummer <= 15) && (!MatAnzahl.getStatus123()))
        MatAnzahl.setzeMaterial(123);
      else if ((ZeichnungsNummer > 15) && (ZeichnungsNummer<=30) && 
               (!MatAnzahl.getStatus132()))
        MatAnzahl.setzeMaterial(132);
      else if ((ZeichnungsNummer > 30) && (ZeichnungsNummer<=45) && 
               (!MatAnzahl.getStatus213()))
        MatAnzahl.setzeMaterial(213);
      else if ((ZeichnungsNummer > 45) && (ZeichnungsNummer<=60) && 
               (!MatAnzahl.getStatus231()))
        MatAnzahl.setzeMaterial(231);
      else if ((ZeichnungsNummer > 60) && (ZeichnungsNummer<=75) && 
               (!MatAnzahl.getStatus312()))
        MatAnzahl.setzeMaterial(312);
      else if ((ZeichnungsNummer > 75) && (ZeichnungsNummer<=90) && 
               (!MatAnzahl.getStatus321()))
        MatAnzahl.setzeMaterial(321);
      else if ((ZeichnungsNummer > 90) && (!MatAnzahl.getStatus111()))
        MatAnzahl.setzeMaterial(111);
    }
  }

/**
 * Mit dieser Methode wird die ganze Fertigungsstrasse gezeichnet. Eigentlich werden nur
 * die Methoden zum zeichnen aufgerufen. Abhaengig vom Aufbau der Fertigungsstrasse wird
 * eine Methode aufgerufen oder nicht.
 */

  public void zeichnen(Graphics g)
  {
    String ML_Anzahl,EL_Anzahl,AL_Anzahl;
    ML_Anzahl=String.valueOf(ML.getAnzahlML());
    EL_Anzahl=String.valueOf(EL.getAnzahl());
    AL_Anzahl=String.valueOf(AL.getAnzahl());

    if (LagerML)
      ML.draw((int)(xPos[0]*x),(int)(yPos[0]*y),
              (int)(width[0]*x),(int)(height[0]*y),ML_Anzahl,g);
    if (M1)
      Maschine1.draw((int)(xPos[1]*x),(int)(yPos[1]*y),
                     (int)(width[1]*x),(int)(height[1]*y),g);
    if (M2)
      Maschine2.draw((int)(xPos[2]*x),(int)(yPos[2]*y),
                     (int)(width[2]*x),(int)(height[2]*y),g);
    if (M3)
      Maschine3.draw((int)(xPos[3]*x),(int)(yPos[3]*y),
                     (int)(width[3]*x),(int)(height[3]*y),g);
    if (Kontr)
      QS.draw((int)(xPos[4]*x),(int)(yPos[4]*y),(int)(width[4]*x),(int)(height[4]*y),g);
    if (LagerEL)
      EL.draw((int)(xPos[5]*x),(int)(yPos[5]*y),
              (int)(width[5]*x),(int)(height[5]*y),EL_Anzahl,g);
    if (LagerAL)
      AL.draw((int)(xPos[6]*x),(int)(yPos[6]*y),
              (int)(width[6]*x),(int)(height[6]*y),AL_Anzahl,g);

    if (Verbindungen[0])
    {
      ML_Maschine1.draw((int)(xBegin1[0]*x),(int)(yBegin1[0]*y),
                        (int)(xEnd1[0]*x),(int)(yEnd1[0]*y),g);
      ML_Maschine1.draw((int)(xBegin2[0]*x),(int)(yBegin2[0]*y),
                        (int)(xEnd2[0]*x),(int)(yEnd2[0]*y),g);
    }
    if (Verbindungen[1])
    {
      ML_Maschine2.draw((int)(xBegin1[1]*x),(int)(yBegin1[1]*y),
                        (int)(xEnd1[1]*x),(int)(yEnd1[1]*y),g);
      ML_Maschine2.draw((int)(xBegin2[1]*x),(int)(yBegin2[1]*y),
                        (int)(xEnd2[1]*x),(int)(yEnd2[1]*y),g);
    }
    if (Verbindungen[2])
    {
      ML_Maschine3.draw((int)(xBegin1[2]*x),(int)(yBegin1[2]*y),
                        (int)(xEnd1[2]*x),(int)(yEnd1[2]*y),g);
      ML_Maschine3.draw((int)(xBegin2[2]*x),(int)(yBegin2[2]*y),
                        (int)(xEnd2[2]*x),(int)(yEnd2[2]*y),g);
    }
    if (Verbindungen[3])
    {
      Maschine1_Maschine2.draw((int)(xBegin1[3]*x),(int)(yBegin1[3]*y),
                               (int)(xEnd1[3]*x),(int)(yEnd1[3]*y),g);
      Maschine1_Maschine2.draw((int)(xBegin2[3]*x),(int)(yBegin2[3]*y),
                               (int)(xEnd2[3]*x),(int)(yEnd2[3]*y),g);
    }
    if (Verbindungen[4])
    {
      Maschine1_Maschine3.draw((int)(xBegin1[4]*x),(int)(yBegin1[4]*y),
                               (int)(xEnd1[4]*x),(int)(yEnd1[4]*y),g);
      Maschine1_Maschine3.draw((int)(xBegin2[4]*x),(int)(yBegin2[4]*y),
                               (int)(xEnd2[4]*x),(int)(yEnd2[4]*y),g);
    }
    if (Verbindungen[5])
    {
      Maschine2_Maschine3.draw((int)(xBegin1[5]*x),(int)(yBegin1[5]*y),
                               (int)(xEnd1[5]*x),(int)(yEnd1[5]*y),g);
      Maschine2_Maschine3.draw((int)(xBegin2[5]*x),(int)(yBegin2[5]*y),
                               (int)(xEnd2[5]*x),(int)(yEnd2[5]*y),g);
    }
    if (Verbindungen[6])
    {
      Maschine1_QS.draw((int)(xBegin1[6]*x),(int)(yBegin1[6]*y),
                        (int)(xEnd1[6]*x),(int)(yEnd1[6]*y),g);
      Maschine1_QS.draw((int)(xBegin2[6]*x),(int)(yBegin2[6]*y),
                        (int)(xEnd2[6]*x),(int)(yEnd2[6]*y),g);
    }
    if (Verbindungen[7])
    {
      Maschine2_QS.draw((int)(xBegin1[7]*x),(int)(yBegin1[7]*y),
                        (int)(xEnd1[7]*x),(int)(yEnd1[7]*y),g);
      Maschine2_QS.draw((int)(xBegin2[7]*x),(int)(yBegin2[7]*y),
                        (int)(xEnd2[7]*x),(int)(yEnd2[7]*y),g);
    }
    if (Verbindungen[8])
    {
      Maschine3_QS.draw((int)(xBegin1[8]*x),(int)(yBegin1[8]*y),
                        (int)(xEnd1[8]*x),(int)(yEnd1[8]*y),g);
      Maschine3_QS.draw((int)(xBegin2[8]*x),(int)(yBegin2[8]*y),
                        (int)(xEnd2[8]*x),(int)(yEnd2[8]*y),g);
    }
    if (Verbindungen[9])
    {
      QS_EL.draw((int)(xBegin1[9]*x),(int)(yBegin1[9]*y),
                 (int)(xEnd1[9]*x),(int)(yEnd1[9]*y),g);
      QS_EL.draw((int)(xBegin2[9]*x),(int)(yBegin2[9]*y),
                 (int)(xEnd2[9]*x),(int)(yEnd2[9]*y),g);
    }
    if (Verbindungen[10])
    {
      QS_AL.draw((int)(xBegin1[10]*x),(int)(yBegin1[10]*y),
                 (int)(xEnd1[10]*x),(int)(yEnd1[10]*y),g);
      QS_AL.draw((int)(xBegin2[10]*x),(int)(yBegin2[10]*y),
                 (int)(xEnd2[10]*x),(int)(yEnd2[10]*y),g);
    }
  }

/**
 * Die Fertigung wird gestartet. Vorher und nachher wird der Lagerbestand der vorhandenen
 * Werkstuecke mit Zeichnungsnummer ausgegeben.
 */

  public void starteFertigung()
  {
    GesamtAnzahl=ML.getAnzahl();

    TextAusgabe.append("\n"+"Lagerbestand:\n");
    TextAusgabe.append("-------------\n\n");
    TextAusgabe.append("Materiallager:  "+ML.getAnzahl()+"\n");
    if ((Verbindungen[0]) && (Verbindungen[6]))
      TextAusgabe.append("   ZN 123:      "+ML.getAnzahl123()+"\n");
    if ((Verbindungen[0]) && (Verbindungen[3]) && (Verbindungen[7]))
      TextAusgabe.append("   ZN 132:      "+ML.getAnzahl132()+"\n");
    if ((Verbindungen[0]) && (Verbindungen[4]) && (Verbindungen[8]))
      TextAusgabe.append("   ZN 213:      "+ML.getAnzahl213()+"\n");
    if ((Verbindungen[0]) && (Verbindungen[3]) && (Verbindungen[5]) && (Verbindungen[8]))
      TextAusgabe.append("   ZN 231:      "+ML.getAnzahl231()+"\n");
    if ((Verbindungen[1]) && (Verbindungen[7]))
      TextAusgabe.append("   ZN 312:      "+ML.getAnzahl312()+"\n");
    if ((Verbindungen[1]) && (Verbindungen[5]) && (Verbindungen[8]))
      TextAusgabe.append("   ZN 321:      "+ML.getAnzahl321()+"\n");
    if ((Verbindungen[2]) && (Verbindungen[8]))
      TextAusgabe.append("   ZN 111:      "+ML.getAnzahl111()+"\n");
    TextAusgabe.append("\n");
    TextAusgabe.append("Endlager:       "+EL.getAnzahl()+"\n");
    if ((Verbindungen[0]) && (Verbindungen[6]))
      TextAusgabe.append("   ZN 123:      "+EL.getAnzahl123()+"\n");
    if ((Verbindungen[0]) && (Verbindungen[3]) && (Verbindungen[7]))
      TextAusgabe.append("   ZN 132:      "+EL.getAnzahl132()+"\n");
    if ((Verbindungen[0]) && (Verbindungen[4]) && (Verbindungen[8]))
      TextAusgabe.append("   ZN 213:      "+EL.getAnzahl213()+"\n");
    if ((Verbindungen[0]) && (Verbindungen[3]) && (Verbindungen[5]) && (Verbindungen[8]))
      TextAusgabe.append("   ZN 231:      "+EL.getAnzahl231()+"\n");
    if ((Verbindungen[1]) && (Verbindungen[7]))
      TextAusgabe.append("   ZN 312:      "+EL.getAnzahl312()+"\n");
    if ((Verbindungen[1]) && (Verbindungen[5]) && (Verbindungen[8]))
      TextAusgabe.append("   ZN 321:      "+EL.getAnzahl321()+"\n");
    if ((Verbindungen[2]) && (Verbindungen[8]))
      TextAusgabe.append("   ZN 111:      "+EL.getAnzahl111()+"\n");
    TextAusgabe.append("\n");
    TextAusgabe.append("Ausschusslager: "+AL.getAnzahl()+"\n");
    if ((Verbindungen[0]) && (Verbindungen[6]))
      TextAusgabe.append("   ZN 123:      "+AL.getAnzahl123()+"\n");
    if ((Verbindungen[0]) && (Verbindungen[3]) && (Verbindungen[7]))
      TextAusgabe.append("   ZN 132:      "+AL.getAnzahl132()+"\n");
    if ((Verbindungen[0]) && (Verbindungen[4]) && (Verbindungen[8]))
      TextAusgabe.append("   ZN 213:      "+AL.getAnzahl213()+"\n");
    if ((Verbindungen[0]) && (Verbindungen[3]) && (Verbindungen[5]) && (Verbindungen[8]))
      TextAusgabe.append("   ZN 231:      "+AL.getAnzahl231()+"\n");
    if ((Verbindungen[1]) && (Verbindungen[7]))
      TextAusgabe.append("   ZN 312:      "+AL.getAnzahl312()+"\n");
    if ((Verbindungen[1]) && (Verbindungen[5]) && (Verbindungen[8]))
      TextAusgabe.append("   ZN 321:      "+AL.getAnzahl321()+"\n");
    if ((Verbindungen[2]) && (Verbindungen[8]))
      TextAusgabe.append("   ZN 111:      "+AL.getAnzahl111()+"\n");
    TextAusgabe.append("\n\n");

    starten();
    ML.starten();

// solange noch nicht alle Teile im End- bzw. Ausschusslager angekommen sind.
    while ((EL.getAnzahl()+AL.getAnzahl()) < GesamtAnzahl)
    {
      Warten.Zeit(50);
    }

    stoppen();

    TextAusgabe.append("\n\nLagerbestand:\n");
    TextAusgabe.append("-------------\n\n");
    TextAusgabe.append("Materiallager:  "+ML.getAnzahl()+"\n");
    if ((Verbindungen[0]) && (Verbindungen[6]))
      TextAusgabe.append("   ZN 123:      "+ML.getAnzahl123()+"\n");
    if ((Verbindungen[0]) && (Verbindungen[3]) && (Verbindungen[7]))
      TextAusgabe.append("   ZN 132:      "+ML.getAnzahl132()+"\n");
    if ((Verbindungen[0]) && (Verbindungen[4]) && (Verbindungen[8]))
      TextAusgabe.append("   ZN 213:      "+ML.getAnzahl213()+"\n");
    if ((Verbindungen[0]) && (Verbindungen[3]) && (Verbindungen[5]) && (Verbindungen[8]))
      TextAusgabe.append("   ZN 231:      "+ML.getAnzahl231()+"\n");
    if ((Verbindungen[1]) && (Verbindungen[7]))
      TextAusgabe.append("   ZN 312:      "+ML.getAnzahl312()+"\n");
    if ((Verbindungen[1]) && (Verbindungen[5]) && (Verbindungen[8]))
      TextAusgabe.append("   ZN 321:      "+ML.getAnzahl321()+"\n");
    if ((Verbindungen[2]) && (Verbindungen[8]))
      TextAusgabe.append("   ZN 111:      "+ML.getAnzahl111()+"\n");
    TextAusgabe.append("\n");
    TextAusgabe.append("Endlager:       "+EL.getAnzahl()+"\n");
    if ((Verbindungen[0]) && (Verbindungen[6]))
      TextAusgabe.append("   ZN 123:      "+EL.getAnzahl123()+"\n");
    if ((Verbindungen[0]) && (Verbindungen[3]) && (Verbindungen[7]))
      TextAusgabe.append("   ZN 132:      "+EL.getAnzahl132()+"\n");
    if ((Verbindungen[0]) && (Verbindungen[4]) && (Verbindungen[8]))
      TextAusgabe.append("   ZN 213:      "+EL.getAnzahl213()+"\n");
    if ((Verbindungen[0]) && (Verbindungen[3]) && (Verbindungen[5]) && (Verbindungen[8]))
      TextAusgabe.append("   ZN 231:      "+EL.getAnzahl231()+"\n");
    if ((Verbindungen[1]) && (Verbindungen[7]))
      TextAusgabe.append("   ZN 312:      "+EL.getAnzahl312()+"\n");
    if ((Verbindungen[1]) && (Verbindungen[5]) && (Verbindungen[8]))
      TextAusgabe.append("   ZN 321:      "+EL.getAnzahl321()+"\n");
    if ((Verbindungen[2]) && (Verbindungen[8]))
      TextAusgabe.append("   ZN 111:      "+EL.getAnzahl111()+"\n");
    TextAusgabe.append("\n");
    TextAusgabe.append("Ausschusslager: "+AL.getAnzahl()+"\n");
    if ((Verbindungen[0]) && (Verbindungen[6]))
      TextAusgabe.append("   ZN 123:      "+AL.getAnzahl123()+"\n");
    if ((Verbindungen[0]) && (Verbindungen[3]) && (Verbindungen[7]))
      TextAusgabe.append("   ZN 132:      "+AL.getAnzahl132()+"\n");
    if ((Verbindungen[0]) && (Verbindungen[4]) && (Verbindungen[8]))
      TextAusgabe.append("   ZN 213:      "+AL.getAnzahl213()+"\n");
    if ((Verbindungen[0]) && (Verbindungen[3]) && (Verbindungen[5]) && (Verbindungen[8]))
      TextAusgabe.append("   ZN 231:      "+AL.getAnzahl231()+"\n");
    if ((Verbindungen[1]) && (Verbindungen[7]))
      TextAusgabe.append("   ZN 312:      "+AL.getAnzahl312()+"\n");
    if ((Verbindungen[1]) && (Verbindungen[5]) && (Verbindungen[8]))
      TextAusgabe.append("   ZN 321:      "+AL.getAnzahl321()+"\n");
    if ((Verbindungen[2]) && (Verbindungen[8]))
      TextAusgabe.append("   ZN 111:      "+AL.getAnzahl111());
  }

/**
 * Mit dieser Methode werden die Threads der vorhandenen Module gestartet.
 */

  public void starten()
  {
    if ((Verbindungen[9]) && (LagerEL) && (Kontr))
      QS_EL.start();
    if ((Verbindungen[10]) && (LagerAL) && (Kontr))
      QS_AL.start();
    if ((Verbindungen[8]) && (Kontr) && (M3))
      Maschine3_QS.start();
    if ((Verbindungen[7]) && (Kontr) && (M2))
      Maschine2_QS.start();
    if ((Verbindungen[6]) && (Kontr) && (M1))
      Maschine1_QS.start();
    if ((Verbindungen[5]) && (M3) && (M2))
      Maschine2_Maschine3.start();
    if ((Verbindungen[4]) && (M3) && (M1))
      Maschine1_Maschine3.start();
    if ((Verbindungen[2]) && (M3) && (LagerML))
      ML_Maschine3.start();
    if ((Verbindungen[3]) && (M2) && (M1))
      Maschine1_Maschine2.start();
    if ((Verbindungen[1]) && (M2) && (LagerML))
      ML_Maschine2.start();
    if ((Verbindungen[0]) && (M1) && (LagerML))
      ML_Maschine1.start();
    if (LagerML)
      ML.start();
    if (M1)
      Maschine1.start();
    if (M2)
      Maschine2.start();
    if (M3)
      Maschine3.start();
    if (Kontr)
      QS.start();
    if (LagerEL)
      EL.start();
    if (LagerAL)
      AL.start();
  }

/**
 * Mit dieser Methode werden die Threads der vorhandenen Module gestoppt.
 */

  public void stoppen()
  {
    if ((Verbindungen[9]) && (LagerEL) && (Kontr))
      QS_EL.stop();
    if ((Verbindungen[10]) && (LagerAL) && (Kontr))
      QS_AL.stop();
    if ((Verbindungen[8]) && (Kontr) && (M3))
      Maschine3_QS.stop();
    if ((Verbindungen[7]) && (Kontr) && (M2))
      Maschine2_QS.stop();
    if ((Verbindungen[6]) && (Kontr) && (M1))
      Maschine1_QS.stop();
    if ((Verbindungen[5]) && (M3) && (M2))
      Maschine2_Maschine3.stop();
    if ((Verbindungen[4]) && (M3) && (M1))
      Maschine1_Maschine3.stop();
    if ((Verbindungen[2]) && (M3) && (LagerML))
      ML_Maschine3.stop();
    if ((Verbindungen[3]) && (M2) && (M1))
      Maschine1_Maschine2.stop();
    if ((Verbindungen[1]) && (M2) && (LagerML))
      ML_Maschine2.stop();
    if ((Verbindungen[0]) && (M1) && (LagerML))
      ML_Maschine1.stop();
    if (LagerML)
      ML.stop();
    if (M1)
      Maschine1.stop();
    if (M2)
      Maschine2.stop();
    if (M3)
      Maschine3.stop();
    if (Kontr)
      QS.stop();
    if (LagerEL)
      EL.stop();
    if (LagerAL)
      AL.stop();
  }

/**
 * Mit dieser Methode werden die Threads der vorhandenen Module unterbrochen.
 */

  public void unterbrechen()
  {
    if ((Verbindungen[9]) && (LagerEL) && (Kontr))
      QS_EL.suspend();
    if ((Verbindungen[10]) && (LagerAL) && (Kontr))
      QS_AL.suspend();
    if ((Verbindungen[8]) && (Kontr) && (M3))
      Maschine3_QS.suspend();
    if ((Verbindungen[7]) && (Kontr) && (M2))
      Maschine2_QS.suspend();
    if ((Verbindungen[6]) && (Kontr) && (M1))
      Maschine1_QS.suspend();
    if ((Verbindungen[5]) && (M3) && (M2))
      Maschine2_Maschine3.suspend();
    if ((Verbindungen[4]) && (M3) && (M1))
      Maschine1_Maschine3.suspend();
    if ((Verbindungen[2]) && (M3) && (LagerML))
      ML_Maschine3.suspend();
    if ((Verbindungen[3]) && (M2) && (M1))
      Maschine1_Maschine2.suspend();
    if ((Verbindungen[1]) && (M2) && (LagerML))
      ML_Maschine2.suspend();
    if ((Verbindungen[0]) && (M1) && (LagerML))
      ML_Maschine1.suspend();
    if (LagerML)
      ML.suspend();
    if (M1)
      Maschine1.suspend();
    if (M2)
      Maschine2.suspend();
    if (M3)
      Maschine3.suspend();
    if (Kontr)
      QS.suspend();
    if (LagerEL)
      EL.suspend();
    if (LagerAL)
      AL.suspend();
  }

/**
 * Mit dieser Methode werden die Threads der vorhandenen Module wieder aufgenommen.
 */

  public void fortfuehren()
  {
    if ((Verbindungen[9]) && (LagerEL) && (Kontr))
      QS_EL.resume();
    if ((Verbindungen[10]) && (LagerAL) && (Kontr))
      QS_AL.resume();
    if ((Verbindungen[8]) && (Kontr) && (M3))
      Maschine3_QS.resume();
    if ((Verbindungen[7]) && (Kontr) && (M2))
      Maschine2_QS.resume();
    if ((Verbindungen[6]) && (Kontr) && (M1))
      Maschine1_QS.resume();
    if ((Verbindungen[5]) && (M3) && (M2))
      Maschine2_Maschine3.resume();
    if ((Verbindungen[4]) && (M3) && (M1))
      Maschine1_Maschine3.resume();
    if ((Verbindungen[2]) && (M3) && (LagerML))
      ML_Maschine3.resume();
    if ((Verbindungen[3]) && (M2) && (M1))
      Maschine1_Maschine2.resume();
    if ((Verbindungen[1]) && (M2) && (LagerML))
      ML_Maschine2.resume();
    if ((Verbindungen[0]) && (M1) && (LagerML))
      ML_Maschine1.resume();
    if (LagerML)
      ML.resume();
    if (M1)
      Maschine1.resume();
    if (M2)
      Maschine2.resume();
    if (M3)
      Maschine3.resume();
    if (Kontr)
      QS.resume();
    if (LagerEL)
      EL.resume();
    if (LagerAL)
      AL.resume();
  }

/**
 * In der Methode Einstellungen wird die ini-Datei ausgelesen und die entsprechenden
 * Folgemethoden aufgerufen. Dies ist notwendig, da die Reihenfolge der Initialisierung
 * eine Rolle spielt, denn es kann beispielsweise kein Fliessband zwischen Maschine1 und
 * Maschine2 angelegt werden, wenn eine der beiden Maschinen gar nicht vorhanden ist.
 */

  void Einstellungen()
  {
    try
    {
      FileInputStream fis=new FileInputStream("Steuerung/"+confName+".ini");
      Properties prop=new Properties();
      prop.load(fis);
      Enumeration e=prop.propertyNames();
      while (e.hasMoreElements())
      {
        String key=(String)e.nextElement();
        String vELue=prop.getProperty(key);
        StringTokenizer vEL_tok=new StringTokenizer(vELue,";");
        String typ=(String)vEL_tok.nextElement();
        String attr=(String)vEL_tok.nextElement();
        StringTokenizer attr_tok=new StringTokenizer(attr,",");
        if ((key.equals("F1")) || (key.equals("F2")) || (key.equals("F3")) || 
            (key.equals("F4")) || (key.equals("F5")) || (key.equals("F6")) || 
            (key.equals("F7")))
          Maschinen(key,typ,attr_tok);
        else
          Transport(key);
      }
      TransportBerechnung();
    }
    catch (IOException e)
    {
      e.printStackTrace();
    }
  }

/**
 * Mit der Methode wird die Position und laenge und breite der Module ausgelesen und
 * in Variablen abgespeichert.
 */

  void Maschinen(String key,String typ,StringTokenizer attr_tok)
  {
    if (key.equals("F1"))
    {
      NameF1=typ;
      LagerML=true;
      String s_xPos=(String)attr_tok.nextElement();
      String s_yPos=(String)attr_tok.nextElement();
      String s_width=(String)attr_tok.nextElement();
      String s_height=(String)attr_tok.nextElement();
      xPos[0]=Integer.parseInt(s_xPos);
      yPos[0]=Integer.parseInt(s_yPos);
      width[0]=Integer.parseInt(s_width);
      height[0]=Integer.parseInt(s_height);
    }
    if (key.equals("F2"))
    {
      NameF2=typ;
      M1=true;
      String s_xPos=(String)attr_tok.nextElement();
      String s_yPos=(String)attr_tok.nextElement();
      String s_width=(String)attr_tok.nextElement();
      String s_height=(String)attr_tok.nextElement();
      xPos[1]=Integer.parseInt(s_xPos);
      yPos[1]=Integer.parseInt(s_yPos);
      width[1]=Integer.parseInt(s_width);
      height[1]=Integer.parseInt(s_height);
    }
    if (key.equals("F3"))
    {
      NameF3=typ;
      M2=true;
      String s_xPos=(String)attr_tok.nextElement();
      String s_yPos=(String)attr_tok.nextElement();
      String s_width=(String)attr_tok.nextElement();
      String s_height=(String)attr_tok.nextElement();
      xPos[2]=Integer.parseInt(s_xPos);
      yPos[2]=Integer.parseInt(s_yPos);
      width[2]=Integer.parseInt(s_width);
      height[2]=Integer.parseInt(s_height);
    }
    if (key.equals("F4"))
    {
      NameF4=typ;
      M3=true;
      String s_xPos=(String)attr_tok.nextElement();
      String s_yPos=(String)attr_tok.nextElement();
      String s_width=(String)attr_tok.nextElement();
      String s_height=(String)attr_tok.nextElement();
      xPos[3]=Integer.parseInt(s_xPos);
      yPos[3]=Integer.parseInt(s_yPos);
      width[3]=Integer.parseInt(s_width);
      height[3]=Integer.parseInt(s_height);
    }
    if (key.equals("F5"))
    {
      NameF5=typ;
      Kontr=true;
      String s_xPos=(String)attr_tok.nextElement();
      String s_yPos=(String)attr_tok.nextElement();
      String s_width=(String)attr_tok.nextElement();
      String s_height=(String)attr_tok.nextElement();
      xPos[4]=Integer.parseInt(s_xPos);
      yPos[4]=Integer.parseInt(s_yPos);
      width[4]=Integer.parseInt(s_width);
      height[4]=Integer.parseInt(s_height);
    }
    if (key.equals("F6"))
    {
      NameF6=typ;
      LagerEL=true;
      String s_xPos=(String)attr_tok.nextElement();
      String s_yPos=(String)attr_tok.nextElement();
      String s_width=(String)attr_tok.nextElement();
      String s_height=(String)attr_tok.nextElement();
      xPos[5]=Integer.parseInt(s_xPos);
      yPos[5]=Integer.parseInt(s_yPos);
      width[5]=Integer.parseInt(s_width);
      height[5]=Integer.parseInt(s_height);
    }
    if (key.equals("F7"))
    {
      NameF7=typ;
      LagerAL=true;
      String s_xPos=(String)attr_tok.nextElement();
      String s_yPos=(String)attr_tok.nextElement();
      String s_width=(String)attr_tok.nextElement();
      String s_height=(String)attr_tok.nextElement();
      xPos[6]=Integer.parseInt(s_xPos);
      yPos[6]=Integer.parseInt(s_yPos);
      width[6]=Integer.parseInt(s_width);
      height[6]=Integer.parseInt(s_height);
    }
  }

/**
 * Hier werden Merker gesetzt, ob ein Fliessband vorhanden ist, oder nicht
 */

  void Transport(String key)
  {
    if (key.equals("T1"))
      Verbindungen[0]=true;
    if (key.equals("T2"))
      Verbindungen[1]=true;
    if (key.equals("T3"))
      Verbindungen[2]=true;
    if (key.equals("T4"))
      Verbindungen[3]=true;
    if (key.equals("T5"))
      Verbindungen[4]=true;
    if (key.equals("T6"))
      Verbindungen[5]=true;
    if (key.equals("T7"))
      Verbindungen[6]=true;
    if (key.equals("T8"))
      Verbindungen[7]=true;
    if (key.equals("T9"))
      Verbindungen[8]=true;
    if (key.equals("T10"))
      Verbindungen[9]=true;
    if (key.equals("T11"))
      Verbindungen[10]=true;
  }

/**
 * Hier werden wegen den Arrays die Nummern des Arrays fuer das entsprechende Fliessband
 * festgelegt. Dies ist deshalb mit Arrays realisiert worden, da die Fliessbandberechnung
 * fuer jedes Fliessband das selbe ist und sonst die selbe Berechnung 11 mal haette ge-
 * schrieben werden muessen.
 */

  void TransportBerechnung()
  {
    if ((Verbindungen[0]) && (LagerML) && (M1))
    {
      FN=0;
      Mod1=0;
      Mod2=1;
      FliessbandBerechnung();
    }
    else Verbindungen[0]=false;
    if ((Verbindungen[1]) && (LagerML) && (M2))
    {
      FN=1;
      Mod1=0;
      Mod2=2;
      FliessbandBerechnung();
    }
    else Verbindungen[1]=false;
    if ((Verbindungen[2]) && (LagerML) && (M3))
    {
      FN=2;
      Mod1=0;
      Mod2=3;
      FliessbandBerechnung();
    }
    else Verbindungen[2]=false;
    if ((Verbindungen[3]) && (M1) && (M2))
    {
      FN=3;
      Mod1=1;
      Mod2=2;
      FliessbandBerechnung();
    }
    else Verbindungen[3]=false;
    if ((Verbindungen[4]) && (M1) && (M3))
    {
      FN=4;
      Mod1=1;
      Mod2=3;
      FliessbandBerechnung();
    }
    else Verbindungen[4]=false;
    if ((Verbindungen[5]) && (M2) && (M3))
    {
      FN=5;
      Mod1=2;
      Mod2=3;
      FliessbandBerechnung();
    }
    else Verbindungen[5]=false;
    if ((Verbindungen[6]) && (M1) && (Kontr))
    {
      FN=6;
      Mod1=1;
      Mod2=4;
      FliessbandBerechnung();
    }
    else Verbindungen[6]=false;
    if ((Verbindungen[7]) && (M2) && (Kontr))
    {
      FN=7;
      Mod1=2;
      Mod2=4;
      FliessbandBerechnung();
    }
    else Verbindungen[7]=false;
    if ((Verbindungen[8]) && (M3) && (Kontr))
    {
      FN=8;
      Mod1=3;
      Mod2=4;
      FliessbandBerechnung();
    }
    else Verbindungen[8]=false;
    if ((Verbindungen[9]) && (Kontr) && (LagerEL))
    {
      FN=9;
      Mod1=4;
      Mod2=5;
      FliessbandBerechnung();
    }
    else Verbindungen[9]=false;
    if ((Verbindungen[10]) && (Kontr) && (LagerAL))
    {
      FN=10;
      Mod1=4;
      Mod2=6;
      FliessbandBerechnung();
    }
    else Verbindungen[10]=false;
  }

/**
 * Die Beschreibung dieser Methode wuerde zu weit gehen. Es sei nur so viel gesagt, dass
 * wenn die Module untereinander stehen, jedoch von der xPosition her gesehen noch
 * ueberlappen in der Mitte der Ueberlappung ein senkrechtes Fliessband gezeichnet wird.
 * Aequivalent dazu funktioniert dies mit dem waagerechten Fliessband. Ueberlappt nichts,
 * wird ein zweiteiliges Fliessband gezeichnet. Hierbei wird, da es immer zwei
 * Moeglichkeiten gibt, eine Moeglichkeit als vordefiniert gewaehlt. Ist auf dieser Strecke
 * ein anderes Modul im Weg, so wird die Alternative gewaehlt, egal, ob dort dann ebenfalls
 * ein Modul im Weg ist. Darauf muss dann der Benutzer achten, wenn er die ini-Datei
 * aendert.
 */

  void FliessbandBerechnung()
  {
    // waagerechtes Fliessband
    if ((yPos[Mod1]==yPos[Mod2]) && ((xPos[Mod1]+width[Mod1])<xPos[Mod2]))
      if (height[Mod1]<=height[Mod2])
      {
        xBegin1[FN]=xPos[Mod1]+width[Mod1];
        yBegin1[FN]=(int)(yPos[Mod1]+(height[Mod1]/2));
        xEnd1[FN]=xPos[Mod2];
        yEnd1[FN]=yBegin1[FN];
      }
      else
      {
        xBegin1[FN]=xPos[Mod1]+width[Mod1];
        yBegin1[FN]=(int)(yPos[Mod2]+(height[Mod2]/2));
        xEnd1[FN]=xPos[Mod2];
        yEnd1[FN]=yBegin1[FN];
      }
    if ((yPos[Mod1]==yPos[Mod2]) && (xPos[Mod1]>(xPos[Mod2]+width[Mod2])))
      if (height[Mod1]<=height[Mod2])
      {
        xBegin1[FN]=xPos[Mod2]+width[Mod2];
        yBegin1[FN]=(int)(yPos[Mod1]+(height[Mod1]/2));
        xEnd1[FN]=xPos[Mod1];
        yEnd1[FN]=yBegin1[FN];
      }
      else
      {
        xBegin1[FN]=xPos[Mod2]+width[Mod2];
        yBegin1[FN]=(int)(yPos[Mod2]+(height[Mod2]/2));
        xEnd1[FN]=xPos[Mod1];
        yEnd1[FN]=yBegin1[FN];
      }
    if ((yPos[Mod1]>yPos[Mod2]) && (yPos[Mod1]<(yPos[Mod2]+height[Mod2])) &&
       ((xPos[Mod1]+width[Mod1])<xPos[Mod2]))
    {
      xBegin1[FN]=xPos[Mod1]+width[Mod1];
      yBegin1[FN]=(int)(yPos[Mod2]+((yPos[Mod1]+height[Mod1]-yPos[Mod2])/2));
      xEnd1[FN]=xPos[Mod2];
      yEnd1[FN]=yBegin1[FN];
    }
    if ((yPos[Mod1]>yPos[Mod2]) && (yPos[Mod1]<(yPos[Mod2]+height[Mod2])) &&
        (xPos[Mod1]>(xPos[Mod2]+width[Mod2])))
    {
      xBegin1[FN]=xPos[Mod2]+width[Mod2];
      yBegin1[FN]=(int)(yPos[Mod2]+((yPos[Mod1]+height[Mod1]-yPos[Mod2])/2));
      xEnd1[FN]=xPos[Mod1];
      yEnd1[FN]=yBegin1[FN];
    }
    if ((yPos[Mod2]>yPos[Mod1]) && (yPos[Mod2]<(yPos[Mod1]+height[Mod1])) &&
       ((xPos[Mod1]+width[Mod1])<xPos[Mod2]))
    {
      xBegin1[FN]=xPos[Mod1]+width[Mod1];
      yBegin1[FN]=(int)(yPos[Mod1]+((yPos[Mod2]+height[Mod2]-yPos[Mod1])/2));
      xEnd1[FN]=xPos[Mod2];
      yEnd1[FN]=yBegin1[FN];
    }
    if ((yPos[Mod2]>yPos[Mod1]) && (yPos[Mod2]<(yPos[Mod1]+height[Mod1])) &&
        (xPos[Mod1]>(xPos[Mod2]+width[Mod2])))
    {
      xBegin1[FN]=xPos[Mod2]+width[Mod2];
      yBegin1[FN]=(int)(yPos[Mod1]+((yPos[Mod2]+height[Mod2]-yPos[Mod1])/2));
      xEnd1[FN]=xPos[Mod1];
      yEnd1[FN]=yBegin1[FN];
    }

    // senkrechtes Fliessband
    if ((xPos[Mod1]==xPos[Mod2]) && ((yPos[Mod1]+height[Mod1])<yPos[Mod2]))
      if (width[Mod1]<=width[Mod2])
      {
        xBegin1[FN]=(int)(xPos[Mod1]+(width[Mod1]/2));
        yBegin1[FN]=yPos[Mod1]+height[Mod1];
        xEnd1[FN]=xBegin1[FN];
        yEnd1[FN]=yPos[Mod2];
      }
      else
      {
        xBegin1[FN]=(int)(xPos[Mod2]+(width[Mod2]/2));
        yBegin1[FN]=yPos[Mod1]+height[Mod1];
        xEnd1[FN]=xBegin1[FN];
        yEnd1[FN]=yPos[Mod2];
      }
    if ((xPos[Mod1]==xPos[Mod2]) && (yPos[Mod1]>(yPos[Mod2]+height[Mod2])))
      if (width[Mod1]<=width[Mod2])
      {
        xBegin1[FN]=(int)(xPos[Mod1]+(width[Mod1]/2));
        yBegin1[FN]=yPos[Mod1];
        xEnd1[FN]=xBegin1[FN];
        yEnd1[FN]=yPos[Mod2]+height[Mod2];
      }
      else
      {
        xBegin1[FN]=(int)(xPos[Mod2]+(width[Mod2]/2));
        yBegin1[FN]=yPos[Mod1];
        xEnd1[FN]=xBegin1[FN];
        yEnd1[FN]=yPos[Mod2]+height[Mod2];
      }
    if ((xPos[Mod1]>xPos[Mod2]) && (xPos[Mod1]<(xPos[Mod2]+width[Mod2])) &&
       ((yPos[Mod1]+height[Mod1])<yPos[Mod2]))
    {
      xBegin1[FN]=(int)(xPos[Mod2]+((xPos[Mod1]+width[Mod1]-xPos[Mod2])/2));
      yBegin1[FN]=yPos[Mod1]+height[Mod1];
      xEnd1[FN]=xBegin1[FN];
      yEnd1[FN]=yPos[Mod2];
    }
    if ((xPos[Mod1]>xPos[Mod2]) && (xPos[Mod1]<(xPos[Mod2]+width[Mod2])) &&
        (yPos[Mod1]>(yPos[Mod2]+height[Mod2])))
    {
      xBegin1[FN]=(int)(xPos[Mod2]+((xPos[Mod1]+width[Mod1]-xPos[Mod2])/2));
      yBegin1[FN]=yPos[Mod1];
      xEnd1[FN]=xBegin1[FN];
      yEnd1[FN]=yPos[Mod2]+height[Mod2];
    }
    if ((xPos[Mod2]>xPos[Mod1]) && (xPos[Mod2]<(xPos[Mod1]+width[Mod1])) &&
       ((yPos[Mod1]+height[Mod1])<yPos[Mod2]))
    {
      xBegin1[FN]=(int)(xPos[Mod1]+((xPos[Mod2]+width[Mod2]-xPos[Mod1])/2));
      yBegin1[FN]=yPos[Mod1]+height[Mod1];
      xEnd1[FN]=xBegin1[FN];
      yEnd1[FN]=yPos[Mod2];
    }
    if ((xPos[Mod2]>xPos[Mod1]) && (xPos[Mod2]<(xPos[Mod1]+width[Mod1])) &&
        (yPos[Mod1]>(yPos[Mod2]+height[Mod2])))
    {
      xBegin1[FN]=(int)(xPos[Mod2]+((xPos[Mod1]+width[Mod1]-xPos[Mod2])/2));
      yBegin1[FN]=yPos[Mod1];
      xEnd1[FN]=xBegin1[FN];
      yEnd1[FN]=yPos[Mod2]+height[Mod2];
    }

    // von links oben nach rechts unten
    if ((xPos[Mod2]>(xPos[Mod1]+width[Mod1])) && ((yPos[Mod2]>yPos[Mod1]+height[Mod1])))
      if ((((xPos[0]<(xPos[Mod1]+(width[Mod1]/2))) && ((xPos[0]+width[0])>(xPos[Mod1]+
         (width[Mod1]/2))) && (yPos[0]<(yPos[Mod2]+(height[Mod2]/2))) && ((yPos[0]+
         height[0])>(yPos[Mod1]+height[Mod1]))) ||
         ((yPos[0]<(yPos[Mod2]+(height[Mod2]/2))) && ((yPos[0]+height[0])>(yPos[Mod2]+
         (height[Mod2]/2))) && ((xPos[0]+width[0])>(xPos[Mod1]+(width[Mod1]/2))) && 
         (xPos[0]<xPos[Mod2]))) ||
         (((xPos[1]<(xPos[Mod1]+(width[Mod1]/2))) && ((xPos[1]+width[1])>(xPos[Mod1]+
         (width[Mod1]/2))) && (yPos[1]<(yPos[Mod2]+(height[Mod2]/2))) && ((yPos[1]+
         height[1])>(yPos[Mod1]+height[Mod1]))) ||
         ((yPos[1]<(yPos[Mod2]+(height[Mod2]/2))) && ((yPos[1]+height[1])>(yPos[Mod2]+
         (height[Mod2]/2))) && ((xPos[1]+width[1])>(xPos[Mod1]+(width[Mod1]/2))) &&
         (xPos[1]<xPos[Mod2]))) ||
         (((xPos[2]<(xPos[Mod1]+(width[Mod1]/2))) && ((xPos[2]+width[2])>(xPos[Mod1]+
         (width[Mod1]/2))) && (yPos[2]<(yPos[Mod2]+(height[Mod2]/2))) && ((yPos[2]+
         height[2])>(yPos[Mod1]+height[Mod1]))) ||
         ((yPos[2]<(yPos[Mod2]+(height[Mod2]/2))) && ((yPos[2]+height[2])>(yPos[Mod2]+
         (height[Mod2]/2))) && ((xPos[2]+width[2])>(xPos[Mod1]+(width[Mod1]/2))) &&
         (xPos[2]<xPos[Mod2]))) ||
         (((xPos[3]<(xPos[Mod1]+(width[Mod1]/2))) && ((xPos[3]+width[3])>(xPos[Mod1]+
         (width[Mod1]/2))) && (yPos[3]<(yPos[Mod2]+(height[Mod2]/2))) && ((yPos[3]+
         height[3])>(yPos[Mod1]+height[Mod1]))) ||
         ((yPos[3]<(yPos[Mod2]+(height[Mod2]/2))) && ((yPos[3]+height[3])>(yPos[Mod2]+
         (height[Mod2]/2))) && ((xPos[3]+width[3])>(xPos[Mod1]+(width[Mod1]/2))) &&
         (xPos[3]<xPos[Mod2]))) ||
         (((xPos[Mod2]<(xPos[Mod1]+(width[Mod1]/2))) && ((xPos[Mod2]+width[Mod2])>
         (xPos[Mod1]+(width[Mod1]/2))) && (yPos[Mod2]<(yPos[Mod2]+(height[Mod2]/2))) &&
         ((yPos[Mod2]+height[Mod2])>(yPos[Mod1]+height[Mod1]))) ||
         ((yPos[Mod2]<(yPos[Mod2]+(height[Mod2]/2))) && ((yPos[Mod2]+height[Mod2])>
         (yPos[Mod2]+(height[Mod2]/2))) && ((xPos[Mod2]+width[Mod2])>(xPos[Mod1]+
         (width[Mod1]/2))) && (xPos[Mod2]<xPos[Mod2]))))
      {
        xBegin1[FN]=xPos[Mod1]+width[Mod1];
        yBegin1[FN]=(int)(yPos[Mod1]+(height[Mod1]/2));
        xEnd1[FN]=(int)(xPos[Mod2]+(width[Mod2]/2));
        yEnd1[FN]=yBegin1[FN];
        xBegin2[FN]=xEnd1[FN];
        yBegin2[FN]=yEnd1[FN];
        xEnd2[FN]=xBegin2[FN];
        yEnd2[FN]=yPos[Mod2];
      }
      else
      {
        xBegin1[FN]=(int)(xPos[Mod1]+(width[Mod1]/2));
        yBegin1[FN]=yPos[Mod1]+height[Mod1];
        xEnd1[FN]=xBegin1[FN];
        yEnd1[FN]=(int)(yPos[Mod2]+(height[Mod2]/2));
        xBegin2[FN]=xEnd1[FN];
        yBegin2[FN]=yEnd1[FN];
        xEnd2[FN]=xPos[Mod2];
        yEnd2[FN]=yBegin2[FN];
      }

    // von links unten nach recht oben
    if ((xPos[Mod2]>(xPos[Mod1]+width[Mod1])) && (yPos[Mod1]>(yPos[Mod2]+height[Mod2])))
      if ((((xPos[0]<(xPos[Mod1]+(width[Mod1]/2))) && ((xPos[0]+width[0])>(xPos[Mod1]+
         (width[Mod1]/2))) && ((yPos[0]+height[0])>(yPos[Mod2]+(height[Mod2]/2))) &&
         (yPos[0]<yPos[Mod1])) ||
         ((yPos[0]<(yPos[Mod2]+(height[Mod2]/2))) && ((yPos[0]+height[0])>(yPos[Mod2]+
         (height[Mod2]/2))) && ((xPos[0]+width[0])>(xPos[Mod1]+(width[Mod1]/2))) &&
         (xPos[0]<xPos[Mod2]))) ||
         (((xPos[1]<(xPos[Mod1]+(width[Mod1]/2))) && ((xPos[1]+width[1])>(xPos[Mod1]+
         (width[Mod1]/2))) && ((yPos[1]+height[1])>(yPos[Mod2]+(height[Mod2]/2))) &&
         (yPos[1]<yPos[Mod1])) ||
         ((yPos[1]<(yPos[Mod2]+(height[Mod2]/2))) && ((yPos[1]+height[1])>(yPos[Mod2]+
         (height[Mod2]/2))) && ((xPos[1]+width[1])>(xPos[Mod1]+(width[Mod1]/2))) &&
         (xPos[1]<xPos[Mod2]))) ||
         (((xPos[2]<(xPos[Mod1]+(width[Mod1]/2))) && ((xPos[2]+width[2])>(xPos[Mod1]+
         (width[Mod1]/2))) && ((yPos[2]+height[2])>(yPos[Mod2]+(height[Mod2]/2))) &&
         (yPos[2]<yPos[Mod1])) ||
         ((yPos[2]<(yPos[Mod2]+(height[Mod2]/2))) && ((yPos[2]+height[2])>(yPos[Mod2]+
         (height[Mod2]/2))) && ((xPos[2]+width[2])>(xPos[Mod1]+(width[Mod1]/2))) &&
         (xPos[2]<xPos[Mod2]))) ||
         (((xPos[3]<(xPos[Mod1]+(width[Mod1]/2))) && ((xPos[3]+width[3])>(xPos[Mod1]+
         (width[Mod1]/2))) && ((yPos[3]+height[3])>(yPos[Mod2]+(height[Mod2]/2))) &&
         (yPos[3]<yPos[Mod1])) ||
         ((yPos[3]<(yPos[Mod2]+(height[Mod2]/2))) && ((yPos[3]+height[3])>(yPos[Mod2]+
         (height[Mod2]/2))) && ((xPos[3]+width[3])>(xPos[Mod1]+(width[Mod1]/2))) &&
         (xPos[3]<xPos[Mod2]))) ||
         (((xPos[Mod2]<(xPos[Mod1]+(width[Mod1]/2))) && ((xPos[Mod2]+width[Mod2])>
         (xPos[Mod1]+(width[Mod1]/2))) && ((yPos[Mod2]+height[Mod2])>(yPos[Mod2]+
         (height[Mod2]/2))) && (yPos[Mod2]<yPos[Mod1])) ||
         ((yPos[Mod2]<(yPos[Mod2]+(height[Mod2]/2))) && ((yPos[Mod2]+height[Mod2])>
         (yPos[Mod2]+(height[Mod2]/2))) && ((xPos[Mod2]+width[Mod2])>(xPos[Mod1]+
         (width[Mod1]/2))) && (xPos[Mod2]<xPos[Mod2]))))
      {
        xBegin1[FN]=xPos[Mod1]+width[Mod1];
        yBegin1[FN]=(int)(yPos[Mod1]+(height[Mod1]/2));
        xEnd1[FN]=(int)(xPos[Mod2]+(width[Mod2]/2));
        yEnd1[FN]=yBegin1[FN];
        xBegin2[FN]=xEnd1[FN];
        yBegin2[FN]=yEnd1[FN];
        xEnd2[FN]=xBegin2[FN];
        yEnd2[FN]=yPos[Mod2]+height[Mod2];
      }
      else
      {
        xBegin1[FN]=(int)(xPos[Mod1]+(width[Mod1]/2));
        yBegin1[FN]=yPos[Mod1];
        xEnd1[FN]=xBegin1[FN];
        yEnd1[FN]=(int)(yPos[Mod2]+(height[Mod2]/2));
        xBegin2[FN]=xEnd1[FN];
        yBegin2[FN]=yEnd1[FN];
        xEnd2[FN]=xPos[Mod2];
        yEnd2[FN]=yBegin2[FN];
      }

    // von rechts oben nach links unten
    if ((xPos[Mod1]>(xPos[Mod2]+width[Mod2])) && (yPos[Mod1]>(yPos[Mod2]+height[Mod2])))
      if ((((xPos[0]<(xPos[Mod2]+(width[Mod2]/2))) && ((xPos[0]+width[0])>(xPos[Mod2]+
         (width[Mod2]/2))) && (yPos[0]<(yPos[Mod1]+(height[Mod1]/2))) &&
         ((yPos[0]+height[0])>(yPos[Mod2]+height[Mod2]))) ||
         ((yPos[0]<(yPos[Mod1]+(height[Mod1]/2))) && ((yPos[0]+height[0])>(yPos[Mod1]+
         (height[Mod1]/2))) && ((xPos[0]+width[0])>(xPos[Mod2]+(width[Mod2]/2))) &&
         (xPos[0]<xPos[Mod1]))) ||
         (((xPos[1]<(xPos[Mod2]+(width[Mod2]/2))) && ((xPos[1]+width[1])>(xPos[Mod2]+
         (width[Mod2]/2))) && (yPos[1]<(yPos[Mod1]+(height[Mod1]/2))) &&
         ((yPos[1]+height[1])>(yPos[Mod2]+height[Mod2]))) ||
         ((yPos[1]<(yPos[Mod1]+(height[Mod1]/2))) && ((yPos[1]+height[1])>(yPos[Mod1]+
         (height[Mod1]/2))) && ((xPos[1]+width[1])>(xPos[Mod2]+(width[Mod2]/2))) &&
         (xPos[1]<xPos[Mod1]))) ||
         (((xPos[2]<(xPos[Mod2]+(width[Mod2]/2))) && ((xPos[2]+width[2])>(xPos[Mod2]+
         (width[Mod2]/2))) && (yPos[2]<(yPos[Mod1]+(height[Mod1]/2))) &&
         ((yPos[2]+height[2])>(yPos[Mod2]+height[Mod2]))) ||
         ((yPos[2]<(yPos[Mod1]+(height[Mod1]/2))) && ((yPos[2]+height[2])>(yPos[Mod1]+
         (height[Mod1]/2))) && ((xPos[2]+width[2])>(xPos[Mod2]+(width[Mod2]/2))) &&
         (xPos[2]<xPos[Mod1]))) ||
         (((xPos[3]<(xPos[Mod2]+(width[Mod2]/2))) && ((xPos[3]+width[3])>(xPos[Mod2]+
         (width[Mod2]/2))) && (yPos[3]<(yPos[Mod1]+(height[Mod1]/2))) &&
         ((yPos[3]+height[3])>(yPos[Mod2]+height[Mod2]))) ||
         ((yPos[3]<(yPos[Mod1]+(height[Mod1]/2))) && ((yPos[3]+height[3])>(yPos[Mod1]+
         (height[Mod1]/2))) && ((xPos[3]+width[3])>(xPos[Mod2]+(width[Mod2]/2))) &&
         (xPos[3]<xPos[Mod1]))) ||
         (((xPos[Mod2]<(xPos[Mod2]+(width[Mod2]/2))) && ((xPos[Mod2]+width[Mod2])>
         (xPos[Mod2]+(width[Mod2]/2))) && (yPos[Mod2]<(yPos[Mod1]+(height[Mod1]/2))) &&
         ((yPos[Mod2]+height[Mod2])>(yPos[Mod2]+height[Mod2]))) ||
         ((yPos[Mod2]<(yPos[Mod1]+(height[Mod1]/2))) && ((yPos[Mod2]+height[Mod2])>
         (yPos[Mod1]+(height[Mod1]/2))) && ((xPos[Mod2]+width[Mod2])>(xPos[Mod2]+
         (width[Mod2]/2))) && (xPos[Mod2]<xPos[Mod1]))))
      {
        xBegin1[FN]=(int)(xPos[Mod1]+(width[Mod1]/2));
        yBegin1[FN]=yPos[Mod1];
        xEnd1[FN]=xBegin1[FN];
        yEnd1[FN]=(int)(yPos[Mod2]+(height[Mod2]/2));
        xBegin2[FN]=xEnd1[FN];
        yBegin2[FN]=yEnd1[FN];
        xEnd2[FN]=xPos[Mod2]+width[Mod2];
        yEnd2[FN]=yBegin2[FN];
      }
      else
      {
        xBegin1[FN]=xPos[Mod1];
        yBegin1[FN]=(int)(yPos[Mod1]+(height[Mod1]/2));
        xEnd1[FN]=(int)(xPos[Mod2]+(width[Mod2]/2));
        yEnd1[FN]=yBegin1[FN];
        xBegin2[FN]=xEnd1[FN];
        yBegin2[FN]=yEnd1[FN];
        xEnd2[FN]=xBegin2[FN];
        yEnd2[FN]=yPos[Mod2]+height[Mod2];
      }

    // von rechts unten nach links oben
    if ((xPos[Mod1]>(xPos[Mod2]+width[Mod2])) && (yPos[Mod2]>(yPos[Mod1]+height[Mod1])))
      if ((((xPos[0]<(xPos[Mod2]+(width[Mod2]/2))) && ((xPos[0]+width[0])>(xPos[Mod2]+
         (width[Mod2]/2))) && ((yPos[0]+height[0])>(yPos[Mod1]+(height[Mod1]/2))) &&
         (yPos[0]<yPos[Mod2])) ||
         ((yPos[0]<(yPos[Mod1]+(height[Mod1]/2))) && ((yPos[0]+height[0])>(yPos[Mod1]+
         (height[Mod1]/2))) && ((xPos[0]+width[0])>(xPos[Mod2]+(width[Mod2]/2))) &&
         (xPos[0]<xPos[Mod1]))) ||
         (((xPos[1]<(xPos[Mod2]+(width[Mod2]/2))) && ((xPos[1]+width[1])>(xPos[Mod2]+
         (width[Mod2]/2))) && ((yPos[1]+height[1])>(yPos[Mod1]+(height[Mod1]/2))) &&
         (yPos[1]<yPos[Mod2])) ||
         ((yPos[1]<(yPos[Mod1]+(height[Mod1]/2))) && ((yPos[1]+height[1])>(yPos[Mod1]+
         (height[Mod1]/2))) && ((xPos[1]+width[1])>(xPos[Mod2]+(width[Mod2]/2))) &&
         (xPos[1]<xPos[Mod1]))) ||
         (((xPos[2]<(xPos[Mod2]+(width[Mod2]/2))) && ((xPos[2]+width[2])>(xPos[Mod2]+
         (width[Mod2]/2))) && ((yPos[2]+height[2])>(yPos[Mod1]+(height[Mod1]/2))) &&
         (yPos[2]<yPos[Mod2])) ||
         ((yPos[2]<(yPos[Mod1]+(height[Mod1]/2))) && ((yPos[2]+height[2])>(yPos[Mod1]+
         (height[Mod1]/2))) && ((xPos[2]+width[2])>(xPos[Mod2]+(width[Mod2]/2))) &&
         (xPos[2]<xPos[Mod1]))) ||
         (((xPos[3]<(xPos[Mod2]+(width[Mod2]/2))) && ((xPos[3]+width[3])>(xPos[Mod2]+
         (width[Mod2]/2))) && ((yPos[3]+height[3])>(yPos[Mod1]+(height[Mod1]/2))) &&
         (yPos[3]<yPos[Mod2])) ||
         ((yPos[3]<(yPos[Mod1]+(height[Mod1]/2))) && ((yPos[3]+height[3])>(yPos[Mod1]+
         (height[Mod1]/2))) && ((xPos[3]+width[3])>(xPos[Mod2]+(width[Mod2]/2))) &&
         (xPos[3]<xPos[Mod1]))) ||
         (((xPos[Mod2]<(xPos[Mod2]+(width[Mod2]/2))) && ((xPos[Mod2]+width[Mod2])>
         (xPos[Mod2]+(width[Mod2]/2))) && ((yPos[Mod2]+height[Mod2])>(yPos[Mod1]+
         (height[Mod1]/2))) && (yPos[Mod2]<yPos[Mod2])) ||
         ((yPos[Mod2]<(yPos[Mod1]+(height[Mod1]/2))) && ((yPos[Mod2]+height[Mod2])>
         (yPos[Mod1]+(height[Mod1]/2))) && ((xPos[Mod2]+width[Mod2])>(xPos[Mod2]+
         (width[Mod2]/2))) && (xPos[Mod2]<xPos[Mod1]))))
      {
        xBegin1[FN]=xPos[Mod2]+width[Mod2];
        yBegin1[FN]=(int)(yPos[Mod2]+(height[Mod2]/2));
        xEnd1[FN]=(int)(xPos[Mod1]+(width[Mod1]/2));
        yEnd1[FN]=yBegin1[FN];
        xBegin2[FN]=xEnd1[FN];
        yBegin2[FN]=yEnd1[FN];
        xEnd2[FN]=xBegin2[FN];
        yEnd2[FN]=yPos[Mod1]+height[Mod1];
      }
      else
      {
        xBegin1[FN]=(int)(xPos[Mod2]+(width[Mod2]/2));
        yBegin1[FN]=yPos[Mod2];
        xEnd1[FN]=xBegin1[FN];
        yEnd1[FN]=(int)(yPos[Mod1]+(height[Mod1]/2));
        xBegin2[FN]=xEnd1[FN];
        yBegin2[FN]=yEnd1[FN];
        xEnd2[FN]=xPos[Mod1];
        yEnd2[FN]=yBegin2[FN];
      }
  }
}
