#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <unistd.h>
#include <netdb.h>

#define maxchars 128

main(int argc, char* argv[])
{
  int iport;
  long lip=0x7F000001;
  int in=0;
  int ir=1;
  int nleft;
  int nread;
  int nrchars;
  char cbuf[maxchars+1];
  int csock;
  struct sockaddr_in sin;

  if(argc<3)
  {
    printf("\nKeine Kommandozeilenargumente!\n");
    printf("Beispiel: zeit2 alex 13\n\n");
    exit(1);
  }

  iport=atoi(argv[2]);

  csock=socket(PF_INET,SOCK_STREAM,0);

  memset(&sin,0,sizeof(sin));
  sin.sin_family=AF_INET;
  sin.sin_port=htons(iport);
  sin.sin_addr.s_addr=htonl(lip);

  if(csock<0)
  {
    printf("\nSocket konnte nicht erzeugt werden!\n\n");
    exit(1);
  }

  printf("\nSocket erzeugt!\n");

  if(connect(csock,(struct sockaddr *)&sin,sizeof(sin))<0)
  {
    printf("Verbindung kam nicht zustande!\n\n");
    exit(1);
  }

  printf("Verbindung zu daytime Dienst hergestellt!\n");

  nleft=maxchars;
  nrchars=0;

  while(nleft!=0)
  {
    nread=read(csock,&cbuf[nrchars],maxchars);
    if(nread<0)
    {
      printf("Das lesen vom Socket schlug fehl!\n\n");
      exit(1);
    }
    if(nread==0)
      break;
    nleft=nleft-nread;
    nrchars=nrchars+nread;
  }

  cbuf[nrchars]='\0';
  printf("Servers Tageszeit ist: %s",cbuf);
  close(csock);

  printf("Verbindung geschlossen!\n\n");
  exit(0);
}
