#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <ctype.h>

#define MAXCHARS 128

int main(int argc,char **argv)
{
  char buf[MAXCHARS];
  int nleft;
  int nread;
  int nchars;
  int iport;
  int csock;
  struct sockaddr_in sin;
  struct hostent *host;
  struct servent *st;

  /* Ueberpruefung auf Kommandozeilenargumente */
  if(argc<3)
  {
    printf("\nKeine Kommandozeilenargumente!\n");
    printf("Beispiel: zeit2 alex daytime\n\n");
    exit(1);
  }

  /* Socket anlegen. */
  csock=socket(AF_INET,SOCK_STREAM,0);
  if(csock<0)
  {
    printf("\nSocket konnte nicht erzeugt werden!\n\n");
    exit(1);
  }
  printf("\nSocket erzeugt!\n");

  /* Socket verbinden mit Host/Portnumemr aus Aufrufparam. */
  sin.sin_family=AF_INET;
  host=gethostbyname(argv[1]);
  if(host==NULL)
  {
    fprintf(stderr,"\nUnbekannter Host: %s\n",argv[1]);
    exit(1);
  }

  /* Uebrpruefung, ob Server als Zahl oder als Name */
  if(isdigit(*argv[2]))
  {
    iport=atoi(argv[2]);
    sin.sin_port=htons(iport);
  }
  else
  {
    st=getservbyname(argv[2],"tcp");
    sin.sin_port=st->s_port;
    if(st==NULL)
    {
      fprintf(stderr,"\nUnbekannter Server: %s\n",argv[2]);
      exit(1);
    }
  }

  memcpy(&sin.sin_addr,host->h_addr,host->h_length);

    if(connect(csock,(struct sockaddr *)&sin,sizeof(sin))<0)
    {
      printf("Verbindung kam nicht zustande!\n\n");
      exit(1);
    }
    printf("Verbindung zu %s Dienst ist hergestellt!\n",argv[2]);

    nleft=MAXCHARS;
    nchars=0;
        
    while(nleft!=0)
    {
      nread=read(csock,&buf[nchars],MAXCHARS);
      if(nread<0)
      {
        printf("Das lesen vom Socket schlug fehl!\n\n");
        exit(1);
      }
      if(nread==0)
       break;
      nleft=nleft-nread;
      nchars=nchars+nread;
    }
    buf[nchars]='\0';
    printf("Ausgabe des Servers: %s\n",buf);

    close (csock);
    printf("Verbindung geschlossen!\n\n");
    exit(0);
}
