// Ein einfacher Text-Editor
import java.awt.*;
import java.awt.event.*;
import java.io.*;

public class Ein_Editor extends Frame
{
//  Konstanten fr die Gre der Textflche
final int ZEILEN = 5;
final int SPALTEN = 120;

// globale Variablen innerhalb der Klasse
String Dateiname;           // zu ladende/speichernde Datei
String aktueller_Text;      // aktueller Text in der TextArea
Text textanzeige;           // die eigentliche TextArea
Choice fonts,styles;        // Auswahl von Fonttyp, Stil und
List farben;                // Farbe

public static void main(String[] args)
   {
   // eine Instanz der Klasse anlegen und anzeigen
   Ein_Editor e = new Ein_Editor("Texteditor");
   e.pack();
   e.show();
   }

// Im Konstruktur die eigentliche Oberflche der Klasse erstellen
Ein_Editor(String titel)
   {
   super(titel);
   // Eine Menleiste  mit Mens anlegen
   MenuBar menleiste = new MenuBar();
   setMenuBar(menleiste);

   Menu menu1 = new Menu("Datei");
   MenuItem item1_1  = new MenuItem("Datei laden");
   MenuItem item1_2 = new MenuItem("Datei speichern");
   MenuItem item1_3 = new MenuItem("Programm beenden");
   menu1.add(item1_1);
   menu1.add(item1_2);
   menu1.add(item1_3);
   menleiste.add(menu1);

   Menu menu2 = new Menu("Spezial");
   MenuItem item2_1 = new MenuItem("Drucken");
   MenuItem item2_2 = new MenuItem("String suchen");
   menu2.add(item2_1);
   menu2.add(item2_2);
   menleiste.add(menu2);


   // Ein Panel anlegen, in dem wir den Textbereich sowie die Choice-Liste
   // fr die Schriftart
   // auswhlen
   Panel p_auen = new Panel();
   p_auen.setLayout(new BorderLayout());
   
   

   // Eine Text-Komponente anlegen
   textanzeige = new Text(ZEILEN,SPALTEN);
   textanzeige.setEditable(true);
      
  
   p_auen.add("Center",textanzeige);  // Textflche zum Panel hinzufgen
    

   // Ein inneres Panel anlegen. Dort kommen die Auswahlmglichkeiten 
   // hinein
   Panel p_innen = new Panel();
   p_innen.setLayout(new GridLayout(4,1));

   String[] fontNames;
   fontNames = Toolkit.getDefaultToolkit().getFontList();
   fonts = new Choice();
   for(int i = 0; i < fontNames.length; i++)
      fonts.addItem(fontNames[i]);      

   // Eine Auswahl von Schriftstilen
   styles = new Choice();
   styles.addItem("plain");
   styles.addItem("kursiv");
   styles.addItem("fett");
  
   
   // Eine Liste fr die Schriftfarbe
   farben = new List();
   farben.add("Schwarz");          // add() ab Java 1.2
   farben.add("Rot");
   farben.add("Grn");
   farben.add("Blau");
   farben.add("Gelb");
   farben.add("Cyan");
   farben.add("Magenta");
   
    
   p_innen.add(fonts);  // die Auswahlkomponenten zum Innenpanel hinzufgen
   p_innen.add(styles);
   p_innen.add(farben);

   p_auen.add("East",p_innen); // Innenpanel zum ueren hinzufgen
   add(p_auen);                // Panel zur Frame Klasse hinzufgen

    
   // Font, Farbe und Schriftstil festlegen  
   fonts.select("TimesRoman");
   farben.select(0);         // Bei Lists kann man nicht den String 
                             // angeben, sondern den Index in der Liste 
   styles.select("plain");                     
   Font_aktualisieren();
  
 
 
 
   
   // Die verschiedenen Adapterklassen fr das Maus Handling
   class ItemAdapter implements ItemListener
      {                                         
      public void itemStateChanged(ItemEvent e)
         {
         Font_aktualisieren();
         }
     
      } // Ende von Klasse 'ItemAdapter' 
      
   class Mein_WindowAdapter extends WindowAdapter
      {
      public void windowClosing(WindowEvent e)
	{
	System.exit(0);
	}
      }


 class Mein_ActionListener implements ActionListener
    {
    public void actionPerformed(ActionEvent e)
         {
         String Label;

         Label = e.getActionCommand();
         
         if(Label.equals("Datei laden"))
	     Datei_laden();

         if(Label.equals("Datei speichern"))
	     Datei_speichern();

         if(Label.equals("Programm beenden"))
	    System.exit(0);              
          
         if(Label.equals("Drucken"))
            Text_drucken();
            
         if(Label.equals("String suchen"))
	    String_suchen();
       
         }  // Ende von 'actionPerformed' 

    } // Ende von Klasse 'Mein_ActionListener' 

   // bei den notwendigen Event-Lauschobjekten registrieren
   addWindowListener(new Mein_WindowAdapter()); 
   
   // Die Instanz der Adapterklasse fr den ActionListener brauchen
   // wir mehrmals, daher erzeugen wir nur eine Instanz und                            
   // verwenden sie mehrfach; das spart ein bichen Speicher
   Mein_ActionListener  actionlistener = new Mein_ActionListener();
   menu1.addActionListener(actionlistener);
   menu2.addActionListener(actionlistener);
   
   // Genauso bei dem Lauschobjekt fr die Items
   ItemAdapter itemlistener = new ItemAdapter();
   fonts.addItemListener(itemlistener);
   styles.addItemListener(itemlistener);
   farben.addItemListener(itemlistener);
   

 } // Ende von Konstruktor 'Ein_Editor' 

  
  
// Den aktuellen Text  drucken
void Text_drucken()
  {  
  // Zuerst einen Printjob erzeugen
  PrintJob pjob = getToolkit().getPrintJob(this,"Text drucken",null);
   
  if(pjob != null)
    {                           
    // ber den Printjob erhlt man ein Graphic-Objekt
    Graphics pg = pjob.getGraphics();
   	
    if(pg != null)       
      { 
      // Die entsprechende Methode aufrufen
      textanzeige.printAll(pg);            
   		
      // Aufrumarbeiten, die manchmal ntig sind
      pg.dispose();
      }
   	
    pjob.end();
    }
  } 
   
   
   
// Den aktuellen Font ermitteln
void Font_aktualisieren()
   {   
   int Fontstil;
   String farbe,fontname,style; 
   int punktgre;
   
   // Die zur Zeit gesetzten Attribute ermitteln und setzen
   fontname = fonts.getSelectedItem();
   style = styles.getSelectedItem();
   farbe = farben.getSelectedItem();
    
   if(farbe.equals("Schwarz"))
   	textanzeige.setForeground(Color.black);
   	
   if(farbe.equals("Rot"))                   	
     	textanzeige.setForeground(Color.red);  	 
     	
   if(farbe.equals("Grn"))
   	textanzeige.setForeground(Color.green);
  
   if(farbe.equals("Blau"))
   	textanzeige.setForeground(Color.blue);
   	
   if(farbe.equals("Magenta"))
   	textanzeige.setForeground(Color.magenta); 
   	
   if(farbe.equals("Cyan"))
   	textanzeige.setForeground(Color.cyan);
   	
   if(farbe.equals("Gelb"))
   	textanzeige.setForeground(Color.yellow);
   	
   
   
   // Der Stil eines Fonts ist die Summe der Konstanten
   // PLAIN, ITALIC und BOLD
   Fontstil = Font.PLAIN;
   
   if(style.equals("kursiv"))         
   	 Fontstil += Font.ITALIC;
   	 
   
   if(style.equals("fett"))
   	 Fontstil += Font.BOLD;   	
   
   // den neuen Font aktivieren
   textanzeige.setFont(new Font(fontname,Fontstil,14));
   
   
   } // Ende von 'Font_aktualisieren'
   
   
// Eine Textdatei  laden
void Datei_laden()
   {
   FileDialog d = new FileDialog(this,"Text laden...",FileDialog.LOAD);
   
   d.show();
   Dateiname = d.getFile();

   // Falls der Benutzer keine Datei ausgewhlt hat, wird null
   // zurckgegeben
   // Dann nichts weiter tun
   if(Dateiname == null)
	return;

   // Einen Eingabestrom ffnen und die Datei laden
   StringBuffer Lesepuffer = new StringBuffer(ZEILEN * SPALTEN);
     
   try
       {
       File eingabedatei = new File(Dateiname);
       FileReader eingabe = new FileReader(eingabedatei);
           
       // solange Zeichen lesen, bis das Dateiende ( = -1) erreicht ist
       //  (= Datei-Ende)
       char Zeichen;
       int gelesen;
       boolean weiter = true;
  
       while(weiter)
	  {
          gelesen = eingabe.read();
          if(gelesen == -1)
	     {
	     weiter = false;
	     continue;
	     }

        Zeichen = (char) gelesen;
        Lesepuffer.append( Zeichen);
	}

      // Datei schlieen
      eingabe.close();
      aktueller_Text = new String(Lesepuffer);
      textanzeige.replaceRange(aktueller_Text,0,aktueller_Text.length());
      }

   
  
 catch(EOFException e)
	{
	// auf diese Exception haben wir ja gewartet , nichts weiter tun. 
        // Die Datei ist komplett gelesen
	// Den neuen Text anzeigen
	aktueller_Text = new String(Lesepuffer);
        textanzeige.replaceRange(aktueller_Text,0,aktueller_Text.length());	
   	}

catch(FileNotFoundException e)
	{
	System.out.println("Datei nicht vorhanden oder lesbar!\n");
	Dateiname = null;    
	}

 catch(IOException e)
	{
	// Sonst irgendwas ist schiefgegangen
	System.out.println("Fehler beim Lesen der Datei " + Dateiname + 
                 "\n");
	Dateiname = null;
	}

  } // Ende von 'Datei_laden' 


// Den aktuellen Text abspeichern
void Datei_speichern()
   {
   // lokale Variablen
   int Zeichen,i;
 

   FileDialog d = new FileDialog(this,"Text speichern...",FileDialog.SAVE);
   
   d.show();
   Dateiname = d.getFile();

   // Falls der Benutzer keine Datei ausgewhlt hat, wird null 
   // zurckgegeben
   // Dann nichts weiter tun
   if(Dateiname == null)
	return;

   try
    {
    // Den Text nun in der Datei speichern
    File ausgabedatei = new File(Dateiname);
    FileWriter ausgabe = new FileWriter(ausgabedatei);


    // den aktuellen Text ermitteln und speichern
    aktueller_Text = textanzeige.getText();
 
    for(i = 0; i < aktueller_Text.length(); i++)
	{
	Zeichen = (int) aktueller_Text.charAt(i);
	ausgabe.write(Zeichen);
	}

     // Datei schlieen
     ausgabe.close();
     }

  catch(IOException e)
	{
	//  irgendwas ist schiefgegangen
	System.out.println("Fehler beim Schreiben der Datei  " + Dateiname 
                        + "\n");
	Dateiname = null;
	}

   } // Ende von 'Datei_speichern' 


// Diese Funktion sucht einen String im Text
void String_suchen()
   {
   String Suchstring;
   FrageDialog frage;
   MeldeDialog negativ;
   int Index;

   // Ein Textfeld aufmachen, um nach dem Suchstring zu fragen
   frage = new FrageDialog(this,"Suchen");
   frage.pack();
   frage.show(); 
   
   Suchstring = frage.getString();
    
    if(Suchstring == null)
	return;
    
        
   // nun suchen
   aktueller_Text = textanzeige.getText();
   Index = aktueller_Text.indexOf(Suchstring);

   if(Index == -1)
	{
	negativ = new MeldeDialog(this,"");
        negativ.show();
	}
   else
	// Den String hervorheben
        textanzeige.select(Index,Index + Suchstring.length() );
   
   } // Ende von 'String_suchen' 

} // Ende von Klasse 'Ein_Editor' 



// diese Klasse bildet den eigentlichen Editor
class Text extends TextArea
{
Text(int Zeilen,int Spalten)
   {
    super("",Zeilen,Spalten,SCROLLBARS_BOTH);
    setBackground(Color.gray); 
   }



// Die  bevorzugte Gre in Pixeln
public Dimension getPreferredSize()
   {
    return new Dimension(450,500);
   }

public Dimension getMinimumSize()
   {
   return getPreferredSize();
   }



} // Ende der Klasse 'Text' 



 // die Dialogklasse fr die Eingabe des Suchstrings
class FrageDialog extends Dialog implements ActionListener
  {
  TextField eingabefeld;
  Button OK, Abbruch;
  String Suchstring;

  // der Konstruktor
  FrageDialog(Frame f, String Titel)
    {
    super(f,Titel,true);  // Konstruktor der Basisklasse aufrufen
    setResizable(false);

    setLayout(new BorderLayout());

    // es werden 2 Panels angelegt. Das eine enthlt das TextField,
    //  das andere die Buttons
    Panel panel1 = new Panel();
    Label label = new Label("Bitte Suchstring eingeben:");
    panel1.add(label);
    eingabefeld = new TextField(40);
    panel1.add(eingabefeld);
    add("Center",panel1);

    Panel panel2 = new Panel();
    OK = new Button("OK");
    Abbruch = new Button("Abbruch");
    panel2.add(OK);
    panel2.add(Abbruch);
    add("South",panel2);
        
    pack();     // Anordnung der Oberflchenelemente auf bevorzugte 
                // Gre initialisieren

    // das Maus-Handling fr die Buttons  macht die Klasse 
    // selbst, also bei sich selber registrieren
    OK.addActionListener(this);
    Abbruch.addActionListener(this);

    class Mein_DialogAdapter extends WindowAdapter
      {
      public void windowClosing(WindowEvent e) {
        Suchstring = null;
        setVisible(false);
        }
      }

    addWindowListener(new Mein_DialogAdapter()); 
    }


  public void actionPerformed(ActionEvent e)  {
    String label;

    label = e.getActionCommand();

    if(label.equals("Abbruch"))  {
      Suchstring = null;
      setVisible(false);
      return;
      }        

    if(label.equals("OK"))  {
      Suchstring = eingabefeld.getText(); 
      setVisible(false); 
      return;
      }
    } // Ende von 'ActionPerformed' 

  // Diese Funktion liefert den eingegebenen Suchstring zurck
  public String getString()  {       
    return Suchstring;
    }

} // Ende von 'FrageDialog' 



// Diese Klasse erzeugt ein Dialogfenster mit einer Meldung
class MeldeDialog extends Dialog implements ActionListener
 {
   MeldeDialog(Frame f,String Meldetext)
      {
      // den Konstruktor der Basisklasse aufrufen
      super(f,"String nicht gefunden",true);
     
     
     setLayout(new BorderLayout());

     Panel panel = new Panel();
     Button OK = new Button("OK");
     OK.addActionListener(this);
     panel.add(OK);
     add(panel);

     pack();      
     
      } // Ende von 'MeldeDialog'


public void actionPerformed(ActionEvent e)
   {
   // das Dialogfenster deaktivieren
   setVisible(false);   
   }
 
// Die  bevorzugte Gre in Pixeln
public Dimension getPreferredSize()
   {
    return new Dimension(200,80);
   }

public Dimension getMinimumSize()
   {
   return getPreferredSize();
   }

} // Ende von Klasse 'MeldeDialog'
