
//Title:        Your Product Name
//Version:
//Copyright:    Copyright (c) 1999
//Author:       Alexander Schneider
//Company:      kein
//Description:  Your description

package Editor;

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;
import javax.swing.event.*;

public class Ein_Editor extends JFrame
{
  // anlegen der MenBar
  JMenuBar m_menuBar = new JMenuBar();

  // anlegen des Menpunktes Datei
  JMenu m_menuDatei = new JMenu("Datei");
  JMenuItem m_menuItemNeu = new JMenuItem("Neu");
  JMenuItem m_menuItemLaden = new JMenuItem("Laden");
  JMenuItem m_menuItemSpeichern = new JMenuItem("Speichern");
  JMenuItem m_menuItemBeenden = new JMenuItem("Beenden");

  // anlegen des Menpunktes Look&Feel
  JMenu m_menuLookFeel = new JMenu("Look&Feel");
  ButtonGroup m_menuLookFeelButtonGroup=new ButtonGroup();
  JRadioButtonMenuItem m_menuLookFeelRadioNative = new JRadioButtonMenuItem("Native");
  JRadioButtonMenuItem m_menuLookFeelRadioMetal = new JRadioButtonMenuItem("Metal");
  JRadioButtonMenuItem m_menuLookFeelRadioMotif = new JRadioButtonMenuItem("Motif");

  // anlegen des Menpunktes Spezial
  JMenu m_menuSpezial = new JMenu("Spezial");
  JMenuItem m_menuItemDrucken = new JMenuItem("Drucken");
  JMenuItem m_menuItemSuchen = new JMenuItem("Suchen");

  //anlegen der LayoutManager, Panels, ComboBoxen, Liste, ScrollPane & TextArea
  BorderLayout m_borderLayoutFrame = new BorderLayout();
  BorderLayout m_borderLayoutScrollPane = new BorderLayout();
  GridLayout m_gridLayoutOtherComponents = new GridLayout(4,1);

  JPanel m_panelTextArea = new JPanel();
  JPanel m_panelOtherComponents = new JPanel();
  JPanel m_panelComboBoxFont = new JPanel();
  JPanel m_panelComboBoxSize = new JPanel();
  JPanel m_panelListColor = new JPanel();
  JPanel m_panelComboBoxStyle = new JPanel();

  JScrollPane m_scrollPaneTextArea = new JScrollPane();
  JTextArea m_TextArea = new JTextArea();
  JScrollPane m_scrollPaneListColor = new JScrollPane();

  JComboBox m_comboBoxFont = new JComboBox();
  JComboBox m_comboBoxStyle = new JComboBox();
  JComboBox m_comboBoxSize = new JComboBox();
  JList m_listColor = new JList();


  JFileChooser m_fileChooser;

  JDialog suchen;
  JTextField m_textFieldSearch;

  // sonstige bentigte Variablen und Vektoren
  Vector schrift;
  Vector stil;
  Vector groesse;
  Vector farbe;
  int index;
  int styleValue=0;
  int sizeValue=12;
  String font="";
  String style="";
  String size="";
  String color="";

  // Konstruktor
  public Ein_Editor(String title)
  {
    super (title);

    try
    {
      jbInit();
    }
    catch(Exception e)
    {
      e.printStackTrace();
    }

    setVisible(true);
  }

  // Main-Methode
  public static void main(String[] args)
  {
    Ein_Editor ein_Editor1 = new Ein_Editor("Ein kleiner Text-Editor");
  }

  // Initialisierungen
  private void jbInit() throws Exception
  {
    // abfragen des aktiven Look & Feels beim Programmstart
    // (setzen des selektierten Radio-Buttons)
    if (UIManager.getLookAndFeel().getName().equals("Windows"))
      m_menuLookFeelRadioNative.setSelected(true);
    if (UIManager.getLookAndFeel().getName().equals("Metal"))
      m_menuLookFeelRadioMetal.setSelected(true);
    if (UIManager.getLookAndFeel().getName().equals("CDE/Motif"))
      m_menuLookFeelRadioMotif.setSelected(true);

    // ermitteln der Systemschriftarten
    GraphicsEnvironment fonts = GraphicsEnvironment.getLocalGraphicsEnvironment();

    // anlegen der Vektoren fr die Werte der ComboBoxen bzw. Listen
    String[] schriftListe = fonts.getAvailableFontFamilyNames();
    schrift = new Vector();
    for (int i=0; i < schriftListe.length; i++)
      schrift.add(schriftListe[i]);
    String []stilListe = {"plain", "fett", "kursiv", "fett/kursiv"};
    stil = new Vector();
    for (int i=0; i < stilListe.length; i++)
      stil.add(stilListe[i]);
    String []groesseListe = {"8", "10", "11", "12", "14", "16", "18", "20"};
    groesse = new Vector();
    for (int i=0; i < groesseListe.length; i++)
      groesse.add(groesseListe[i]);
    String []farbListe = {"Schwarz", "Rot", "Grn", "Blau", "Gelb", "Cyan", "Magenta"};
    farbe = new Vector();
    for (int i=0; i < farbListe.length; i++)
      farbe.add(farbListe[i]);

    // eintragen der Vektoren in die ComboBoxen und Liste
    m_comboBoxFont = new JComboBox(schrift);
    m_comboBoxStyle = new JComboBox(stil);
    m_comboBoxSize = new JComboBox(groesse);
    m_listColor.setListData(farbe);
    // Multiple-Selektion bei der Liste deaktivieren
    m_listColor.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    // bernehmen der angegebenen Standard Schriftgrsse
    m_comboBoxSize.setSelectedIndex(groesse.indexOf(String.valueOf(sizeValue)));
    // neuen Font setzen mit Standard-Werten


    // anlegen aller Komponenten im Hauptframe
    // (mu vor dem setzen der weiteren Komponenten geschehen)
    this.getContentPane().setLayout(m_borderLayoutFrame);
    this.setSize(new Dimension(800, 600));
    // WindowListener um Fenster zu schlieen
    this.addWindowListener(new java.awt.event.WindowAdapter()
    {
      public void windowClosing(WindowEvent e)
      {
        this_windowClosing(e);
      }
    });


    // setzen der Hauptkomponenten im Frame
    this.getContentPane().add(m_panelTextArea, BorderLayout.CENTER);
    this.getContentPane().add(m_panelOtherComponents, BorderLayout.EAST);

    // setzen der Dimensionen der Komponenten
    m_scrollPaneListColor.setPreferredSize(new Dimension(125, 100));
    m_comboBoxStyle.setPreferredSize(new Dimension(125, 24));
    m_comboBoxFont.setPreferredSize(new Dimension(125, 24));
    m_comboBoxSize.setPreferredSize(new Dimension(125, 24));

    // setzen der ComboBox, List Komponenten im BorderLayout.EAST
    m_panelOtherComponents.setLayout(m_gridLayoutOtherComponents);
    m_panelOtherComponents.add(m_panelComboBoxFont);
    m_panelOtherComponents.add(m_panelComboBoxStyle);
    m_panelOtherComponents.add(m_panelComboBoxSize);
    // setzen der ComboBox in die Panels
    m_panelComboBoxFont.add(m_comboBoxFont);
    m_panelComboBoxStyle.add(m_comboBoxStyle);
    m_panelComboBoxSize.add(m_comboBoxSize);
    // setzen der List in den Panel
    m_panelOtherComponents.add(m_panelListColor);
    m_scrollPaneListColor.getViewport().add(m_listColor);
    m_panelListColor.add(m_scrollPaneListColor);

    // setzen der TextArea im BorderLayout.CENTER
    m_panelTextArea.setLayout(m_borderLayoutScrollPane);
    m_panelTextArea.add(m_scrollPaneTextArea, BorderLayout.CENTER);
    m_scrollPaneTextArea.getViewport().add(m_TextArea, null);


    // setzen der MenBar
    setJMenuBar(m_menuBar);

    m_menuBar.add(m_menuDatei);
    m_menuBar.add(m_menuLookFeel);
    m_menuBar.add(m_menuSpezial);
    m_menuDatei.add(m_menuItemNeu);
    m_menuDatei.add(m_menuItemLaden);
    m_menuDatei.add(m_menuItemSpeichern);
    m_menuDatei.addSeparator();
    m_menuDatei.add(m_menuItemBeenden);
    m_menuLookFeelButtonGroup.add(m_menuLookFeelRadioNative);
    m_menuLookFeelButtonGroup.add(m_menuLookFeelRadioMetal);
    m_menuLookFeelButtonGroup.add(m_menuLookFeelRadioMotif);
    m_menuLookFeel.add(m_menuLookFeelRadioNative);
    m_menuLookFeel.add(m_menuLookFeelRadioMetal);
    m_menuLookFeel.add(m_menuLookFeelRadioMotif);
    m_menuSpezial.add(m_menuItemDrucken);
    m_menuSpezial.add(m_menuItemSuchen);


    // Aufruf der Methode, um ActionListener zu initialisieren
    initActionListener();
  }

  // ActionListener initialisieren
  void initActionListener()
  {
    // Listener fr Men-Datei
    // Listener fr TextArea lschen
    m_menuItemNeu.addActionListener(new java.awt.event.ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        m_menuItemNeu_actionPerformed(e);
      }
    });
    // Listener fr laden
    m_menuItemLaden.addActionListener(new java.awt.event.ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        m_menuItemLaden_actionPerformed(e);
      }
    });
    // Listener fr speichern
    m_menuItemSpeichern.addActionListener(new java.awt.event.ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        m_menuItemSpeichern_actionPerformed(e);
      }
    });
    // Listener fr beenden
    m_menuItemBeenden.addActionListener(new java.awt.event.ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        m_menuItemBeenden_actionPerformed(e);
      }
    });

    // Listener fr Men Look&Feel
    // Listener fr Native Look&Feel
    m_menuLookFeelRadioNative.addActionListener(new java.awt.event.ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        m_menuLookFeelRadioNative_actionPerformed(e);
      }
    });
    // Listener fr Metal Look&Feel
    m_menuLookFeelRadioMetal.addActionListener(new java.awt.event.ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        m_menuLookFeelRadioMetal_actionPerformed(e);
      }
    });
    // Listener fr Motif Look&Feel
    m_menuLookFeelRadioMotif.addActionListener(new java.awt.event.ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        m_menuLookFeelRadioMotif_actionPerformed(e);
      }
    });

    // Listener fr Men-Spezial
    // Listener fr drucken
    m_menuItemDrucken.addActionListener(new java.awt.event.ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        m_menuItemDrucken_actionPerformed(e);
      }
    });
    // Listener fr suchen
    m_menuItemSuchen.addActionListener(new java.awt.event.ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        m_menuItemSuchen_actionPerformed(e);
      }
    });

    // Listener fr restliche Komponenten
    // Listener fr Auswahl der Schriftart
    m_comboBoxFont.addActionListener(new java.awt.event.ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        m_comboBoxFont_actionPerformed(e);
      }
    });
    // Listener fr Auswahl des Schriftstils
    m_comboBoxStyle.addActionListener(new java.awt.event.ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        m_comboBoxStyle_actionPerformed(e);
      }
    });
    // Listener fr Auswahl der Schriftgre
    m_comboBoxSize.addActionListener(new java.awt.event.ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        m_comboBoxSize_actionPerformed(e);
      }
    });
    // Listener fr Auswahl der Schriftfarbe
    m_listColor.addListSelectionListener(new javax.swing.event.ListSelectionListener()
    {
      public void valueChanged(ListSelectionEvent e)
      {
        m_listColor_valueChanged(e);
      }
    });
  }


  // Event-Handler aller Listener
  // Event-Handler vom Fenster (schliessen)
  void this_windowClosing(WindowEvent e)
  {
    System.exit(0);
  }

  // Event-Handler fr Text lschen in TextArea
  void m_menuItemNeu_actionPerformed(ActionEvent e)
  {
    m_TextArea.setText("");
  }

  // Event-Handler fr Datei laden (JFileChooser)
  void m_menuItemLaden_actionPerformed(ActionEvent e)
  {
    // anlegen eines neuen JFileChooser Objektes
    m_fileChooser = new JFileChooser();
    // setzen des Verzeichnisses, in dem das Programm gestartet wurde
    m_fileChooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
    String Dateiname="";
    String neuerText;
    File file=null;

    // ffnen des Dialog-Fensters
    int returnVal = m_fileChooser.showOpenDialog(this);

    // Datei whlen (ermitteln)
    if (returnVal == JFileChooser.APPROVE_OPTION)
    {
      file = m_fileChooser.getSelectedFile();
      Dateiname = m_fileChooser.getName(file);
    }

    if(Dateiname == null)
	    return;

    StringBuffer Lesepuffer = new StringBuffer();

    try
    {
      // Datei einlesen (Datenstrom)
      FileReader eingabe = new FileReader(file);

      char Zeichen;
      int gelesen;
      boolean weiter = true;

      // Zeichen fr Zeichen in den Lesepuffer
      while(weiter)
      {
        gelesen = eingabe.read();
        if(gelesen == -1)
        {
	        weiter = false;
	        continue;
	      }

        Zeichen = (char) gelesen;
        Lesepuffer.append(Zeichen);
	    }

      // Datei schliessen, Lesepuffer in die TextArea setzen
      eingabe.close();
      neuerText = new String(Lesepuffer);
      m_TextArea.setText(neuerText);
    }
    // Ausnahmen (Fehler) auffangen
    catch(EOFException ex)
	  {
   	}
    catch(FileNotFoundException ex)
    {
    }
    catch(IOException ex)
	  {
    }
    catch(NullPointerException ex)
	  {
    }
  }

  // Event-Handler fr den Speichern-Dialog
  void m_menuItemSpeichern_actionPerformed(ActionEvent e)
  {
    // neues Objekt des JFileChooser Dialoges anlegen
    m_fileChooser = new JFileChooser();
    // ermitteln des Verzeichnisses, in dem das Programm gestartet wurde
    m_fileChooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
    int Zeichen,i;
    String Dateiname="";
    String neuerText;
    File file=null;

    // Speichern-Dialog ffnen und anzeigen
    int returnVal = m_fileChooser.showSaveDialog(this);

    // Dateiname ermitteln
    if (returnVal == JFileChooser.APPROVE_OPTION)
    {
      file = m_fileChooser.getSelectedFile();
      Dateiname = m_fileChooser.getName(file);
    }

    if(Dateiname == null)
	    return;

    try
    {
      // Daten Zeichen fr Zeichen in eine Datei schreiben
      File ausgabedatei = new File(Dateiname);
      FileWriter ausgabe = new FileWriter(ausgabedatei);

      neuerText = m_TextArea.getText();

      for(i = 0; i < neuerText.length(); i++)
      {
	      Zeichen = (int) neuerText.charAt(i);
        ausgabe.write(Zeichen);
      }

      // Datei schliessen
      ausgabe.close();
    }
    // Ausnahmen (Fehler) auffangen
    catch(IOException ex)
	  {
  	}
  }

  // Event-Handler fr Programmende
  void m_menuItemBeenden_actionPerformed(ActionEvent e)
  {
    System.exit(0);
  }

  // Event-Handler fr Native Look&Feel
  void m_menuLookFeelRadioNative_actionPerformed(ActionEvent e)
  {
		try
		{
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
			SwingUtilities.updateComponentTreeUI(this);
		}
		catch (Exception ex)
		{
		}
  }

  // Event-Handler fr Metal Look&Feel
  void m_menuLookFeelRadioMetal_actionPerformed(ActionEvent e)
  {
    try
		{
			UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
			SwingUtilities.updateComponentTreeUI(this);
		}
		catch (Exception ex)
		{
		}
  }

  // Event-Handler fr Motif Look&Feel
  void m_menuLookFeelRadioMotif_actionPerformed(ActionEvent e)
  {
  	try
		{
     	UIManager.setLookAndFeel(new com.sun.java.swing.plaf.motif.MotifLookAndFeel());
     	SwingUtilities.updateComponentTreeUI(this);
		}
		catch (Exception ex)
  	{
		}
  }

  // Event-Handler fr drucken
  void m_menuItemDrucken_actionPerformed(ActionEvent e)
  {
    PrintJob pjob = getToolkit().getPrintJob(this,"Text drucken",null);

    if(pjob != null)
    {
      Graphics pg = pjob.getGraphics();

      if(pg != null)
      {
        m_TextArea.printAll(pg);
        pg.dispose();
      }
      pjob.end();
    }
  }

  // Event-Handler fr suchen
  void m_menuItemSuchen_actionPerformed(ActionEvent e)
  {
    // anlegen eines JDialog, mit Positionierung abhngig vom ParentFrame
    int parentFrameX;
    int parentFrameY;

    suchen = new JDialog(this, "Suchen", true);
    suchen.setSize(250,80+sizeValue);
    parentFrameX=this.getX();
    parentFrameY=this.getY();
    suchen.setLocation(parentFrameX+50,parentFrameY+75);

    // anlegen der Komponenten Label, TextField, Button
    BorderLayout m_borderLayoutSuchenDialog = new BorderLayout();
    JLabel m_labelSuchen = new JLabel("Such-String:");
    m_textFieldSearch = new JTextField();
    m_textFieldSearch.setPreferredSize(new Dimension(150, sizeValue+10));
    JButton m_OKButtonSuchen = new JButton("suchen");
    JPanel m_hauptPanelSuchen = new JPanel();
    JPanel m_panelTextFieldSuchen = new JPanel();
    JPanel m_okPanelSuchen = new JPanel();

    m_hauptPanelSuchen.setLayout(m_borderLayoutSuchenDialog);
    m_hauptPanelSuchen.add(m_panelTextFieldSuchen, BorderLayout.CENTER);
    m_hauptPanelSuchen.add(m_okPanelSuchen, BorderLayout.SOUTH);
    m_panelTextFieldSuchen.add(m_labelSuchen);
    m_panelTextFieldSuchen.add(m_textFieldSearch);
    m_okPanelSuchen.add(m_OKButtonSuchen);

    // initialisieren des suchen-Buttons
    m_OKButtonSuchen.addActionListener(new java.awt.event.ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        m_OKButtonSuchen_actionPerformed(e);
      }
    });

    suchen.getContentPane().add(m_hauptPanelSuchen);
    suchen.setVisible(true);
  }

  // Event-Handler fr Schriftart
  void m_comboBoxFont_actionPerformed(ActionEvent e)
  {
    index = m_comboBoxFont.getSelectedIndex();
    font = (String)schrift.elementAt(index);

    m_TextArea.setFont(new Font(font,styleValue,sizeValue));
  }

  // Event-Handler fr Schriftstil
  void m_comboBoxStyle_actionPerformed(ActionEvent e)
  {
    index = m_comboBoxStyle.getSelectedIndex();
    style = (String)stil.elementAt(index);

    if(style.equals("plain"))
      styleValue = 0;
    if(style.equals("fett"))
      styleValue = 1;
    if(style.equals("kursiv"))
      styleValue = 2;
    if(style.equals("fett/kursiv"))
      styleValue = 3;

    m_TextArea.setFont(new Font(font,styleValue,sizeValue));
  }

  // Event-Handler fr Schriftgre
  void m_comboBoxSize_actionPerformed(ActionEvent e)
  {
    index = m_comboBoxSize.getSelectedIndex();
    size = (String)groesse.elementAt(index);

    sizeValue=Integer.valueOf(size).intValue();
    m_TextArea.setFont(new Font(font,styleValue,sizeValue));
  }

  // Event-Handler fr Schriftfarbe
  void m_listColor_valueChanged(ListSelectionEvent e)
  {
    index = m_listColor.getSelectedIndex();
    color = (String)farbe.elementAt(index);

    if(color.equals("Schwarz"))
   	  m_TextArea.setForeground(Color.black);
    if(color.equals("Rot"))
     	m_TextArea.setForeground(Color.red);
    if(color.equals("Grn"))
   	  m_TextArea.setForeground(Color.green);
    if(color.equals("Blau"))
   	  m_TextArea.setForeground(Color.blue);
    if(color.equals("Magenta"))
   	  m_TextArea.setForeground(Color.magenta);
    if(color.equals("Cyan"))
   	  m_TextArea.setForeground(Color.cyan);
    if(color.equals("Gelb"))
   	  m_TextArea.setForeground(Color.yellow);
  }

  // Event-Handler fr Text suchen
  void m_OKButtonSuchen_actionPerformed(ActionEvent e)
  {
    int Index;
    String suchText;
    suchen.dispose();
    suchText = m_TextArea.getText();

    Index = suchText.indexOf(m_textFieldSearch.getText());
    getToolkit().beep();
    m_TextArea.select(Index,Index + m_textFieldSearch.getText().length());
  }
}
