package myArtikel;

public class ArtClient1
{
	private Artikel artikel = null;


	//
	// Standalone program initialization
	//
	public static void main(String args[])
	{
		java.util.Properties props = System.getProperties();
		props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
		props.put("org.omg.CORBA.ORBSingletonClass", "com.ooc.CORBA.ORBSingleton");

		try {
			//
			// Create ORB
			//
			org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init(args, props);

			//
			// Get "artikel" object
			//
			org.omg.CORBA.Object obj = orb.string_to_object("relfile:/Artikel.ref");

			if(obj == null) {
				System.err.println("Can't read from Artikel.ref");
				System.exit(1);
			}

			Artikel artikel = null;

			try {
				artikel = ArtikelHelper.narrow(obj);
			} catch (org.omg.CORBA.BAD_PARAM ex) {
				// narrow() failed
				ex.printStackTrace();
				System.exit(1);
			}

			ArtClient1 client1 = new ArtClient1(artikel);
			client1.readUserEntry();
		} catch (org.omg.CORBA.SystemException ex) {
			System.err.println(ex.getMessage());
			ex.printStackTrace();
			System.exit(1);
		}
	}


	public ArtClient1(Artikel artikel)
	{
		this.artikel = artikel;
	}


	private void readUserEntry()
	{
		java.io.BufferedReader inputReader = new java.io.BufferedReader(new java.io.InputStreamReader(System.in));
		java.util.StringTokenizer tokens = null;
		String input = null;
		String command = null;
		String argument = null;
		int countTokens = 0;
		boolean quit = false;

		System.out.println(getHelp());

		while (!quit) {
			System.out.println();

			try {
				input = inputReader.readLine();
				tokens = new java.util.StringTokenizer(input);
				countTokens = tokens.countTokens();
	
				if (countTokens >= 1) {
					command = tokens.nextToken();
					argument = (input.substring(input.indexOf(command) +
							 	command.length(), input.length())).trim();
				}
			} catch (java.io.IOException ex) {
				System.err.println(ex.getMessage());
				ex.printStackTrace();
				System.exit(1);
			}

			if (command.equalsIgnoreCase("quit")) {
				quit = true;
			} else if (command.equalsIgnoreCase("bestand")) {
				System.out.println("Aktueller Lagerbestand: " + artikel.Bestand());
			} else if (command.equalsIgnoreCase("bestellung")) {
				int anzahl = 0;

				try {
					anzahl = Integer.parseInt(argument);
					System.out.println("Es wurden '" + artikel.Bestellung(anzahl) + "' Teile geliefert.");
				} catch (NumberFormatException ex) {
					System.out.println("Die angegebene Anzahl ist keine gueltige zahl!");
				}
			} else if (command.equalsIgnoreCase("lieferung")) {
				int anzahl = 0;

				try {
					anzahl = Integer.parseInt(argument);
					artikel.Lieferung(anzahl);
				} catch (NumberFormatException ex) {
					System.out.println("Die angegebene Anzahl ist keine gueltige zahl!");
				}
			} else {
				System.out.println(getHelp());
			}
		}
	}


	private String getHelp()
	{
		return "help = diese Hilfe\n" +
			   "bestand = aktueller Lagerbestand\n" +
			   "bestellung [anzahl] = Bestellung des Artikels mit der angegebenen Anzahl\n" +
			   "lieferung [anzahl] = Lieferung des Artikels mit der angegebenen Anzahl";
	}
}
