package myArtikel;

public class ArtServer1
{
	public static void main(String args[])
	{
		java.util.Properties props = System.getProperties();
		props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
		props.put("org.omg.CORBA.ORBSingletonClass", "com.ooc.CORBA.ORBSingleton");

		try {
			//
			// Create ORB
			//
			org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init(args, props);

			//
			// Resolve Root POA
			//
			org.omg.PortableServer.POA root = null;

			try {
				root = org.omg.PortableServer.POAHelper.narrow(orb.resolve_initial_references("RootPOA"));
			} catch (org.omg.CORBA.ORBPackage.InvalidName ex) {
				ex.printStackTrace();
				throw new RuntimeException();
			}

			//
			// Get a reference to the POA manager
			//
			org.omg.PortableServer.POAManager manager = root.the_POAManager();

			//
			// Create implementation object
			//
			Artikel_impl artikelImpl1 = new Artikel_impl("Mars", 500);
			Artikel_impl artikelImpl2 = new Artikel_impl("Twix", 700);
			System.out.println("Anfangsbestand Mars : 500");
			System.out.println("Anfangsbestand Twix : 700");

			myArtikel.ArtikelPOATie a1 = new myArtikel.ArtikelPOATie(artikelImpl1);
			myArtikel.ArtikelPOATie a2 = new myArtikel.ArtikelPOATie(artikelImpl2);
			myArtikel.Artikel artikel1 = a1._this(orb);
			myArtikel.Artikel artikel2 = a2._this(orb);


			//
			// Save reference
			//
			try {
				// Using a file in Shared File System

				String ref1 = orb.object_to_string(artikel1);
				String ref2 = orb.object_to_string(artikel2);
				String refFile1 = "ArtikelTIEMars.ref";
				String refFile2 = "ArtikelTIETwix.ref";
				java.io.FileOutputStream file1 = new java.io.FileOutputStream(refFile1);
				java.io.FileOutputStream file2 = new java.io.FileOutputStream(refFile2);
				java.io.PrintWriter out1 = new java.io.PrintWriter(file1);
				java.io.PrintWriter out2 = new java.io.PrintWriter(file2);
				out1.println(ref1);
				out2.println(ref2);
				out1.flush();
				out2.flush();
				file1.close();
				file2.close();
			} catch (java.io.IOException ex) {
				System.err.println("Can't write to `" + ex.getMessage() + "'");
				System.exit(1);
			}


			//
			// Run implementation
			//
			try {
				manager.activate();
				System.out.println("Server is ready");
			} catch (Exception ex) {
				ex.printStackTrace();
				throw new RuntimeException();
			}

			orb.run();
		} catch (org.omg.CORBA.SystemException ex) {
			ex.printStackTrace();
			System.exit(1);
		}

		System.exit(0);
	}
}
