package myArtikel;

public class ArtServer1
{
	public static void main(String args[])
	{
		java.util.Properties props = System.getProperties();
		props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
		props.put("org.omg.CORBA.ORBSingletonClass", "com.ooc.CORBA.ORBSingleton");

		try {
			//
			// Create ORB
			//
			org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init(args, props);

			//
			// Resolve Root POA
			//
			org.omg.PortableServer.POA root = null;

			try {
				root = org.omg.PortableServer.POAHelper.narrow(orb.resolve_initial_references("RootPOA"));
			} catch (org.omg.CORBA.ORBPackage.InvalidName ex) {
				ex.printStackTrace();
				throw new RuntimeException();
			}

			//
			// Get a reference to the POA manager
			//
			org.omg.PortableServer.POAManager manager = root.the_POAManager();

			//
			// Create implementation object
			//
			Artikel_impl artikelImpl1 = new Artikel_impl("Mars", 500);
			Artikel_impl artikelImpl2 = new Artikel_impl("Twix", 700);
			System.out.println("Anfangsbestand Mars : 500");
			System.out.println("Anfangsbestand Twix : 700");

			myArtikel.ArtikelPOATie a1 = new myArtikel.ArtikelPOATie(artikelImpl1);
			myArtikel.ArtikelBestandPOATie b1 = new myArtikel.ArtikelBestandPOATie(artikelImpl1);
			myArtikel.ArtikelLieferungPOATie c1 = new myArtikel.ArtikelLieferungPOATie(artikelImpl1);
			myArtikel.ArtikelBestellungPOATie d1 = new myArtikel.ArtikelBestellungPOATie(artikelImpl1);

			myArtikel.ArtikelPOATie a2 = new myArtikel.ArtikelPOATie(artikelImpl2);
			myArtikel.ArtikelBestandPOATie b2 = new myArtikel.ArtikelBestandPOATie(artikelImpl2);
			myArtikel.ArtikelLieferungPOATie c2 = new myArtikel.ArtikelLieferungPOATie(artikelImpl2);
			myArtikel.ArtikelBestellungPOATie d2 = new myArtikel.ArtikelBestellungPOATie(artikelImpl2);

			myArtikel.Artikel artikel1 = a1._this(orb);
			myArtikel.ArtikelBestand bestand1 = b1._this(orb);
			myArtikel.ArtikelLieferung lieferung1 = c1._this(orb);
			myArtikel.ArtikelBestellung bestellung1 = d1._this(orb);

			myArtikel.Artikel artikel2 = a2._this(orb);
			myArtikel.ArtikelBestand bestand2 = b2._this(orb);
			myArtikel.ArtikelLieferung lieferung2 = c2._this(orb);
			myArtikel.ArtikelBestellung bestellung2 = d2._this(orb);


			//
			// Save reference
			//
			try {
				// Using a file in Shared File System

				String ref1a = orb.object_to_string(artikel1);
				String ref1b = orb.object_to_string(bestand1);
				String ref1c = orb.object_to_string(lieferung1);
				String ref1d = orb.object_to_string(bestellung1);

				String ref2a = orb.object_to_string(artikel2);
				String ref2b = orb.object_to_string(bestand2);
				String ref2c = orb.object_to_string(lieferung2);
				String ref2d = orb.object_to_string(bestellung2);

				String refFile1a = "ArtikelTIEMars.ref";
				String refFile1b = "ArtikelTIEMarsBestand.ref";
				String refFile1c = "ArtikelTIEMarsLieferung.ref";
				String refFile1d = "ArtikelTIEMarsBestellung.ref";

				String refFile2a = "ArtikelTIETwix.ref";
				String refFile2b = "ArtikelTIETwixBestand.ref";
				String refFile2c = "ArtikelTIETwixLieferung.ref";
				String refFile2d = "ArtikelTIETwixBestellung.ref";

				java.io.FileOutputStream file1a = new java.io.FileOutputStream(refFile1a);
				java.io.FileOutputStream file1b = new java.io.FileOutputStream(refFile1b);
				java.io.FileOutputStream file1c = new java.io.FileOutputStream(refFile1c);
				java.io.FileOutputStream file1d = new java.io.FileOutputStream(refFile1d);

				java.io.FileOutputStream file2a = new java.io.FileOutputStream(refFile2a);
				java.io.FileOutputStream file2b = new java.io.FileOutputStream(refFile2b);
				java.io.FileOutputStream file2c = new java.io.FileOutputStream(refFile2c);
				java.io.FileOutputStream file2d = new java.io.FileOutputStream(refFile2d);

				java.io.PrintWriter out1a = new java.io.PrintWriter(file1a);
				java.io.PrintWriter out1b = new java.io.PrintWriter(file1b);
				java.io.PrintWriter out1c = new java.io.PrintWriter(file1c);
				java.io.PrintWriter out1d = new java.io.PrintWriter(file1d);

				java.io.PrintWriter out2a = new java.io.PrintWriter(file2a);
				java.io.PrintWriter out2b = new java.io.PrintWriter(file2b);
				java.io.PrintWriter out2c = new java.io.PrintWriter(file2c);
				java.io.PrintWriter out2d = new java.io.PrintWriter(file2d);

				out1a.println(ref1a);
				out1b.println(ref1b);
				out1c.println(ref1c);
				out1d.println(ref1d);

				out2a.println(ref2a);
				out2b.println(ref2b);
				out2c.println(ref2c);
				out2d.println(ref2d);

				out1a.flush();
				out1b.flush();
				out1c.flush();
				out1d.flush();

				out2a.flush();
				out2b.flush();
				out2c.flush();
				out2d.flush();

				file1a.close();
				file1b.close();
				file1c.close();
				file1d.close();

				file2a.close();
				file2b.close();
				file2c.close();
				file2d.close();
			} catch (java.io.IOException ex) {
				System.err.println("Can't write to `" + ex.getMessage() + "'");
				System.exit(1);
			}


			//
			// Run implementation
			//
			try {
				manager.activate();
				System.out.println("Server is ready");
			} catch (Exception ex) {
				ex.printStackTrace();
				throw new RuntimeException();
			}

			orb.run();
		} catch (org.omg.CORBA.SystemException ex) {
			ex.printStackTrace();
			System.exit(1);
		}

		System.exit(0);
	}
}
