package myArtikel;

public class VollClient
{
	private java.util.Map artikelMap = null;
	private myArtikel.Artikel artikel = null;


	//
	// Standalone program initialization
	//
	public static void main(String args[])
	{
		java.util.Properties props = System.getProperties();
		props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
		props.put("org.omg.CORBA.ORBSingletonClass", "com.ooc.CORBA.ORBSingleton");

		try {
			//
			// Create ORB
			//
			org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init(args, props);

			//
			// Get "artikel" object
			//
			String artikelName = null;
			myArtikel.Artikel artikel = null;
			java.util.Map artikelMap = new java.util.HashMap();
			java.io.File dir = new java.io.File(System.getProperty("user.dir"));
			DateiFilter filter = new DateiFilter();
			java.io.File refSource[] = dir.listFiles(filter);

			for (int i = 0; i < refSource.length; i++) {
				artikelName = refSource[i].getName();

				if ((artikelName.indexOf("Bestand") == -1) &&
					(artikelName.indexOf("Bestellung") == -1) &&
					(artikelName.indexOf("Lieferung") == -1)) {

					org.omg.CORBA.Object obj = orb.string_to_object("relfile:/" + artikelName);

					if(obj == null) {
						System.err.println("Can't read from " + artikelName);
						System.exit(1);
					}

					try {
						artikel = myArtikel.ArtikelHelper.narrow(obj);
					} catch (org.omg.CORBA.BAD_PARAM ex) {
						// narrow() failed
						ex.printStackTrace();
						System.exit(1);
					}

					artikelName = artikelName.substring(0, artikelName.length() - 4);

					if (artikelName.startsWith("Artikel")) {
						artikelName = (artikelName.substring(7, artikelName.length())).trim();
					}

					if (artikelName.startsWith("TIE")) {
						artikelName = (artikelName.substring(3, artikelName.length())).trim();
					}

					artikelMap.put(artikelName, artikel);
				}
			}

			VollClient client = new VollClient(artikelMap);
			client.readUserEntry();
		} catch (org.omg.CORBA.SystemException ex) {
			System.err.println(ex.getMessage());
			ex.printStackTrace();
			System.exit(1);
		}
	}


	public VollClient(java.util.Map artikelMap)
	{
		this.artikelMap = artikelMap;
	}


	private void readUserEntry()
	{
		java.io.BufferedReader inputReader = new java.io.BufferedReader(new java.io.InputStreamReader(System.in));
		java.util.StringTokenizer tokens = null;
		String input = null;
		String command = null;
		String argument = null;
		int countTokens = 0;
		boolean quit = false;

		System.out.println();
		System.out.println(getHelp());

		while (!quit) {
			System.out.println();

			try {
				input = inputReader.readLine();
				tokens = new java.util.StringTokenizer(input);
				countTokens = tokens.countTokens();
	
				if (countTokens >= 1) {
					command = tokens.nextToken();
					argument = (input.substring(input.indexOf(command) +
							 	command.length(), input.length())).trim();
				}
			} catch (java.io.IOException ex) {
				System.err.println(ex.getMessage());
				ex.printStackTrace();
				System.exit(1);
			}

			if (command.equalsIgnoreCase("quit")) {
				quit = true;
			} else if (command.equalsIgnoreCase("artikel")) {
				java.util.Iterator artikelIterator = artikelMap.keySet().iterator();

				while (artikelIterator.hasNext()) {
					System.out.println(artikelIterator.next());
				}
			} else if (command.equalsIgnoreCase("bestand")) {
				artikel = (myArtikel.Artikel)artikelMap.get(argument);

				if (artikel != null) {
					System.out.println("Aktueller Lagerbestand: " + artikel.Bestand());
				} else {
					System.out.println("Ungueltiger Artikel angegeben!");
				}
			} else if (command.equalsIgnoreCase("bestellung")) {
				int anzahl = 0;

				tokens = new java.util.StringTokenizer(argument);
				countTokens = tokens.countTokens();
	
				if (countTokens >= 1) {
					command = tokens.nextToken();
					argument = (input.substring(input.indexOf(command) +
							 	command.length(), input.length())).trim();
				}

				artikel = (myArtikel.Artikel)artikelMap.get(command);

				if (artikel != null) {
					try {
						anzahl = Integer.parseInt(argument);
						System.out.println("Es wurden '" + artikel.Bestellung(anzahl) + "' Teile geliefert.");
					} catch (NumberFormatException ex) {
						System.out.println("Die angegebene Anzahl ist keine gueltige zahl!");
					} catch (myArtikel.ArtikelBestellungPackage.Ablehnung ab) {
						System.out.println("FEHLER bei Bestellung - Grund: " + ab.Ursache);
					}
				} else {
					System.out.println("Ungueltiger Artikel angegeben!");
				}
			} else if (command.equalsIgnoreCase("lieferung")) {
				int anzahl = 0;

				tokens = new java.util.StringTokenizer(argument);
				countTokens = tokens.countTokens();
	
				if (countTokens >= 1) {
					command = tokens.nextToken();
					argument = (input.substring(input.indexOf(command) +
							 	command.length(), input.length())).trim();
				}

				artikel = (myArtikel.Artikel)artikelMap.get(command);

				if (artikel != null) {
					try {
						anzahl = Integer.parseInt(argument);
						artikel.Lieferung(anzahl);
					} catch (NumberFormatException ex) {
						System.out.println("Die angegebene Anzahl ist keine gueltige zahl!");
					}
				} else {
					System.out.println("Ungueltiger Artikel angegeben!");
				}
			} else {
				System.out.println(getHelp());
			}
		}

		System.exit(0);
	}


	private String getHelp()
	{
		return "help\t\t\t\t= diese Hilfe\n" +
			   "artikel\t\t\t\t= listet alle verfuegbaren Artikel auf\n" +
			   "bestand [artikel]\t\t= aktueller Lagerbestand\n" +
			   "bestellung [artikel] [anzahl]\t= Bestellung des Artikels mit der angegebenen\n" +
			   "\t\t\t\t  Anzahl\n" +
			   "lieferung [artikel] [anzahl]\t= Lieferung des Artikels mit der angegebenen\n" +
			   "\t\t\t\t  Anzahl";
	}
}
