package myArtikel;

public class ArtClient1
{
	private java.util.Map haendlerMap = null;
	private myArtikel.GrossHaendler haendler = null;


	//
	// Standalone program initialization
	//
	public static void main(String args[])
	{
		java.util.Properties props = System.getProperties();
		props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
		props.put("org.omg.CORBA.ORBSingletonClass", "com.ooc.CORBA.ORBSingleton");

		try {
			//
			// Create ORB
			//
			org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init(args, props);

			//
			// Get "artikel" object
			//
			String haendlerName = null;
			myArtikel.GrossHaendler haendler = null;
			java.util.Map haendlerMap = new java.util.HashMap();
			java.io.File dir = new java.io.File(System.getProperty("user.dir"));
			DateiFilter filter = new DateiFilter();
			java.io.File refSource[] = dir.listFiles(filter);

			for (int i = 0; i < refSource.length; i++) {
				haendlerName = refSource[i].getName();
				org.omg.CORBA.Object obj = orb.string_to_object("relfile:/" + haendlerName);

				if(obj == null) {
					System.err.println("Can't read from " + haendlerName);
					System.exit(1);
				}

				try {
					haendler = myArtikel.GrossHaendlerHelper.narrow(obj);
				} catch (org.omg.CORBA.BAD_PARAM ex) {
					// narrow() failed
					ex.printStackTrace();
					System.exit(1);
				}

				haendlerName = haendlerName.substring(0, haendlerName.length() - 4);
				haendlerMap.put(haendlerName, haendler);
			}

			ArtClient1 client = new ArtClient1(haendlerMap);
			client.readUserEntry();
		} catch (org.omg.CORBA.SystemException ex) {
			System.err.println(ex.getMessage());
			ex.printStackTrace();
			System.exit(1);
		}
	}


	public ArtClient1(java.util.Map haendlerMap)
	{
		this.haendlerMap = haendlerMap;
	}


	private void readUserEntry()
	{
		java.io.BufferedReader inputReader = new java.io.BufferedReader(new java.io.InputStreamReader(System.in));
		java.util.StringTokenizer tokens = null;
		String aktHaendler = null;
		String input = null;
		String command = null;
		String argument = null;
		int countTokens = 0;
		boolean quit = false;
		boolean validHaendler = false;

		System.out.println();
		System.out.println("Verfuegbare Haendler:");

		java.util.Iterator haendlerIterator = haendlerMap.keySet().iterator();

		while (haendlerIterator.hasNext()) {
			System.out.println(haendlerIterator.next());
		}

		while (!validHaendler) {
			System.out.print("\nHaendler auswaehlen: ");

			try {
				input = inputReader.readLine();
	
				if (haendlerMap.get(input) != null) {
					aktHaendler = input;
					validHaendler = true;
					haendler = (myArtikel.GrossHaendler)haendlerMap.get(input);
				}
			} catch (java.io.IOException ex) {
				System.err.println(ex.getMessage());
				ex.printStackTrace();
				System.exit(1);
			}
		}

		System.out.println();
		System.out.println(getHelp());

		while (!quit) {
			System.out.println();

			try {
				input = inputReader.readLine();
				tokens = new java.util.StringTokenizer(input);
				countTokens = tokens.countTokens();
	
				if (countTokens >= 1) {
					command = tokens.nextToken();
					argument = (input.substring(input.indexOf(command) +
							 	command.length(), input.length())).trim();
				}
			} catch (java.io.IOException ex) {
				System.err.println(ex.getMessage());
				ex.printStackTrace();
				System.exit(1);
			}

			if (command.equalsIgnoreCase("quit")) {
				quit = true;
			} else if (command.equalsIgnoreCase("haendler")) {
				haendlerIterator = haendlerMap.keySet().iterator();

				while (haendlerIterator.hasNext()) {
					System.out.println(haendlerIterator.next());
				}
			} else if (command.equalsIgnoreCase("wechseln")) {
				if (haendlerMap.get(argument) != null) {
					aktHaendler = argument;
					haendler = (myArtikel.GrossHaendler)haendlerMap.get(aktHaendler);
					System.out.println("Der Haendler wurde gewechselt zu: " + aktHaendler);
				} else {
					System.out.println("Der Haendler konnte nicht gewechselt werden! Der Haendler " +
									   argument + " ist nicht vorhanden.");
				}
			} else if (command.equalsIgnoreCase("artikel")) {
				ArtikelInfo names [] = haendler.getAlleBestaende();

				for (int i = 0; i < names.length; i++) {
					System.out.println(names[i].name);
				}
			} else if (command.equalsIgnoreCase("bestand")) {
				if (haendler != null) {
					System.out.println("Aktueller Lagerbestand: " + haendler.ArtikelBestand(argument));
				} else {
					System.out.println("Ungueltiger Haendler angegeben!");
				}
			} else if (command.equalsIgnoreCase("bestellung")) {
				int anzahl = 0;

				tokens = new java.util.StringTokenizer(argument);
				countTokens = tokens.countTokens();
	
				if (countTokens >= 1) {
					command = tokens.nextToken();
					argument = (input.substring(input.indexOf(command) +
							 	command.length(), input.length())).trim();
				}

				if (haendler != null) {
					try {
						anzahl = Integer.parseInt(argument);
						System.out.println("Es wurden '" + haendler.ArtikelBestellung(command, anzahl) + "' Teile geliefert.");
					} catch (NumberFormatException ex) {
						System.out.println("Die angegebene Anzahl ist keine gueltige Zahl!");
					}
				} else {
					System.out.println("Ungueltiger Haendler angegeben!");
				}
			} else if (command.equalsIgnoreCase("lieferung")) {
				int anzahl = 0;

				tokens = new java.util.StringTokenizer(argument);
				countTokens = tokens.countTokens();
	
				if (countTokens >= 1) {
					command = tokens.nextToken();
					argument = (input.substring(input.indexOf(command) +
							 	command.length(), input.length())).trim();
				}

				if (haendler != null) {
					try {
						anzahl = Integer.parseInt(argument);
						haendler.ArtikelLiefern(command, anzahl);
					} catch (NumberFormatException ex) {
						System.out.println("Die angegebene Anzahl ist keine gueltige Zahl!");
					}
				} else {
					System.out.println("Ungueltiger Haendler angegeben!");
				}
			} else if (command.equalsIgnoreCase("aufnehmen")) {
				int anzahl = 0;

				tokens = new java.util.StringTokenizer(argument);
				countTokens = tokens.countTokens();
	
				if (countTokens >= 1) {
					command = tokens.nextToken();
					argument = (input.substring(input.indexOf(command) +
							 	command.length(), input.length())).trim();
				}

				if (haendler != null) {
					try {
						anzahl = Integer.parseInt(argument);
						haendler.ArtikelAufnehmen(command, anzahl);
					} catch (NumberFormatException ex) {
						System.out.println("Die angegebene Anzahl ist keine gueltige Zahl!");
					} catch (myArtikel.GrossHaendlerPackage.SchonVorhanden ex) {
						System.out.println(ex.getMessage());
					}
				} else {
					System.out.println("Ungueltiger Haendler!");
				}
			} else if (command.equalsIgnoreCase("loeschen")) {
				if (haendler != null) {
					haendler.ArtikelLoeschen(argument);
					System.out.println("Artikel " + argument + " geloescht!");
				} else {
					System.out.println("Ungueltiger Haendler angegeben!");
				}
			} else {
				System.out.println(getHelp());
			}
		}

		System.exit(0);
	}


	private String getHelp()
	{
		return "help\t\t\t\t= diese Hilfe\n" +
			   "haendler\t\t\t= listet alle verfuegbaren Haendler auf\n" +
			   "wechseln [haendler]\t\t= wechselt den Haendler\n" +
			   "artikel\t\t\t\t= listet alle verfuegbaren Artikel auf\n" +
			   "bestand [artikel]\t\t= aktueller Lagerbestand\n" +
			   "bestellung [artikel] [anzahl]\t= Bestellung des Artikels mit der angegebenen\n" +
			   "\t\t\t\t  Anzahl\n" +
			   "lieferung [artikel] [anzahl]\t= Lieferung des Artikels mit der angegebenen\n" +
			   "\t\t\t\t  Anzahl\n" +
			   "aufnehmen [artikel] [anzahl]\t= nimmt einen neuen Artikel mit der angegebenen\n" +
			   "\t\t\t\t  Anzahl ins Sortiment auf\n" +
			   "loeschen [artikel]\t\t= loescht den angegebenen Artikel\n";
	}
}
