package myArtikel;

public class ArtServer1
{
	public static void main(String args[])
	{
		java.util.Properties props = System.getProperties();
		props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
		props.put("org.omg.CORBA.ORBSingletonClass", "com.ooc.CORBA.ORBSingleton");

		try {
			//
			// Create ORB
			//
			org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init(args, props);

			//
			// Resolve Root POA
			//
			org.omg.PortableServer.POA root = null;

			try {
				root = org.omg.PortableServer.POAHelper.narrow(orb.resolve_initial_references("RootPOA"));
			} catch (org.omg.CORBA.ORBPackage.InvalidName ex) {
				ex.printStackTrace();
				throw new RuntimeException();
			}

			//
			// Get a reference to the POA manager
			//
			org.omg.PortableServer.POAManager manager = root.the_POAManager();

			GrossHaendler_impl haendlerImpl = new GrossHaendler_impl();
			myArtikel.GrossHaendler haendler = haendlerImpl._this(orb);

			try {
				String ref = orb.object_to_string(haendler);
				String refFile = "Grosshaendler.ref";
				java.io.FileOutputStream file = new java.io.FileOutputStream(refFile);
				java.io.PrintWriter out = new java.io.PrintWriter(file);
				out.println(ref);
				out.flush();
				file.close();
			} catch (java.io.IOException ex) {
				System.err.println("Can't write to `" + ex.getMessage() + "'");
				System.exit(1);
			}

			//
			// Run implementation
			//
			try {
				manager.activate();
				haendlerImpl.ArtikelAufnehmen("Mars", 500);
				haendlerImpl.ArtikelAufnehmen("Twix", 700);
				System.out.println("Server is ready");
			} catch (Exception ex) {
				ex.printStackTrace();
				throw new RuntimeException();
			}

			orb.run();
		} catch (org.omg.CORBA.SystemException ex) {
			ex.printStackTrace();
			System.exit(1);
		}

		System.exit(0);
	}
}
