package myArtikel;


import org.omg.CORBA.ORB;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.SystemException;

import java.util.Map;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;

import java.io.File;
import java.io.IOException;

import java.io.BufferedReader;
import java.io.InputStreamReader;

import myArtikel.BigDealerPackage.ArticleExistingException;
import myArtikel.BigDealerPackage.ArticleNotExistingException;
import myArtikel.BigDealerPackage.NoArticleExistingException;
import myArtikel.BigDealerPackage.DecliningException;


public class ArtClient1 implements Runnable
{
	private java.util.Map dealerMap		= null;
	private myArtikel.BigDealer dealer	= null;

	private boolean validDealer			= false;
	private boolean quit				= false;


	public ArtClient1(Map dealerMap)
	{
		this.dealerMap = dealerMap;
	}


	public void run()
	{
		askForDealer();
		printHelp();

		while (!quit) {
			readUserEntry();
		}
	}


	private void askForDealer()
	{
		BufferedReader inputReader = new BufferedReader(new InputStreamReader(System.in));
		String input = null;

		showDealers();

		while (!validDealer) {
			System.out.print("\nChoose dealer: ");

			try {
				input = inputReader.readLine();
				changeDealer(input);

				if (dealer != null) {
					validDealer = true;
				}
			} catch (IOException ioex) {
				System.err.println(ioex.getMessage());
				ioex.printStackTrace();
				System.exit(1);
			}
		}
	}


	private void readUserEntry()
	{
		BufferedReader inputReader = new BufferedReader(new InputStreamReader(System.in));
		StringTokenizer tokens = null;

		String input	= null;
		String command	= null;
		String argument	= null;

		int countTokens	= -1;

		System.out.print("\nCommand: ");

		try {
			input = inputReader.readLine();
			tokens = new StringTokenizer(input);
			countTokens = tokens.countTokens();
	
			if (countTokens >= 1) {
				command = tokens.nextToken();
				argument = (input.substring(input.indexOf(command) +
						 	command.length(), input.length())).trim();
			}
		} catch (IOException ioex) {
			System.err.println(ioex.getMessage());
			ioex.printStackTrace();
			System.exit(1);
		}

		if (command.equalsIgnoreCase("quit")) {
			quit = true;
		} else if (command.equals("dealer")) {
			showDealers();
		} else if (command.equals("change")) {
			changeDealer(argument);
		} else if (command.equalsIgnoreCase("articles")) {
			showArticles();
		} else if (command.equals("stock")) {
			showStock(argument);
		} else if (command.equals("order")) {
			orderArticle(argument);
		} else if (command.equalsIgnoreCase("deliver")) {
			deliverArticle(argument);
		} else if (command.equals("admit")) {
			admitArticle(argument);
		} else if (command.equals("remove")) {
			removeArticle(argument);
		} else {
			printHelp();
		}
	}


	private void showDealers()
	{
		System.out.println("\nAvailable dealers are:");

		Iterator dealerIterator = dealerMap.keySet().iterator();

		while (dealerIterator.hasNext()) {
			System.out.println(dealerIterator.next());
		}
	}


	private void changeDealer(String dealerName)
	{
		if (dealerMap.get(dealerName) != null) {
			dealer = (BigDealer)dealerMap.get(dealerName);
			System.out.println("\nDealer has changed to '" + dealer.getName() + "'.");
		} else {
			System.out.println("\nThe dealer couldn't be changed! The dealer '" +
							   dealerName + "' isn't available!");
		}
	}


	private void showArticles()
	{
		try {
			ArticleInfo [] infos = dealer.getAllArticles();

			System.out.println("\nAvailable articles for dealer '" + dealer.getName() + "' are:");

			for (int i = 0; i < infos.length; i++) {
				System.out.println(infos[i].getName());
			}
		} catch (NoArticleExistingException naeex) {
			System.out.println(naeex.getReason());
		}
	}


	private void showStock(String article)
	{
		try {
			System.out.println("\nCurrent stock of '" + article + "' at dealer '" +
							   dealer.getName() + "' is: " + dealer.stock(article));
		} catch (ArticleNotExistingException aneex) {
			System.out.println(aneex.getReason());
		}
	}


	private void orderArticle(String argument)
	{
		String article	= null;
		int number		= 0;

		try {
			article	= getArticleName(argument);
			number	= getArticleNumber(argument);

			System.out.println("\n'" + number + "' pieces of '" + article +
							   "' were delivered by dealer '" + dealer.getName() +
							   "'. Now there are '" + dealer.order(article, number) +
							   "' pieces of '" + article + "' available at dealer '" +
							   dealer.getName() + "'.");
		} catch (NumberFormatException ex) {
			System.out.println("The specified number is no valid number!");
		} catch (ArticleNotExistingException aneex) {
			System.out.println(aneex.getReason());
		} catch (DecliningException dex) {
			System.out.println(dex.getReason());
		}
	}


	private void deliverArticle(String argument)
	{
		String article	= null;
		int number		= 0;

		try {
			article	= getArticleName(argument);
			number	= getArticleNumber(argument);

			System.out.println("\n'" + number + "' pieces of '" + article +
							   "' were sent to dealer '" + dealer.getName() +
							   "'. Now there are '" + dealer.deliver(article, number) +
							   "' pieces of '" + article + "' available at dealer '" +
							   dealer.getName() + "'.");
		} catch (NumberFormatException ex) {
			System.out.println("The specified number is no valid number!");
		} catch (ArticleNotExistingException aneex) {
			System.out.println(aneex.getReason());
		} catch (DecliningException dex) {
			System.out.println(dex.getReason());
		}
	}


	private void admitArticle(String argument)
	{
		String article	= null;
		int number		= 0;

		try {
			article	= getArticleName(argument);
			number	= getArticleNumber(argument);

			dealer.admitArticle(article, number);
			System.out.println("\nThe article '" + article + "' was admitted to dealer '" +
							   dealer.getName() + "' with initial '" + number + "' " +
							   "pieces of article.");
		} catch (NumberFormatException ex) {
			System.out.println("The specified number is no valid number!");
		} catch (ArticleExistingException aeex) {
			System.out.println(aeex.getReason());
		}
	}


	private void removeArticle(String article)
	{
		try {
			dealer.deleteArticle(article);
			System.out.println("Article '" + article + "' was removed from dealer '" +
							   dealer.getName() + "'!");
		} catch (myArtikel.BigDealerPackage.ArticleNotExistingException aneex) {
			System.out.println(aneex.getReason());
		}
	}


	private String getArticleName(String argument)
	{
		StringTokenizer tokens = new StringTokenizer(argument);
	
		if (tokens.countTokens() >= 1) {
			return tokens.nextToken();
		}

		return "";
	}


	private int getArticleNumber(String argument) throws NumberFormatException
	{
		StringTokenizer tokens = new StringTokenizer(argument);
		String article	= null;
		int number		= 0;

		if (tokens.countTokens() >= 1) {
			article = tokens.nextToken();
			argument = (argument.substring(argument.indexOf(article) +
					 	article.length(), argument.length())).trim();
		}

		number = Integer.parseInt(argument);

		return number;
	}


	private void printHelp()
	{
		System.out.println("\nhelp\t\t\t\t= this help.\n" +
						   "dealer\t\t\t\t= lists all available dealers.\n" +
						   "change [dealer]\t\t\t= changes the current dealer.\n" +
						   "articles\t\t\t= lists all available articles from current\n" +
						   "\t\t\t\t  dealer.\n" +
						   "stock [article]\t\t\t= shows the current stock of the specified\n" +
						   "\t\t\t\t  article.\n" +
						   "order [article] [number]\t= orders the specified pieces of the specified\n" +
						   "\t\t\t\t  article from current dealer.\n" +
						   "deliver [article] [number]\t= delivers the specified pieces of the\n" +
						   "\t\t\t\t  specified article to the current dealer.\n" +
						   "admit [article] [number]\t= admits a new article to the stock of the\n" +
						   "\t\t\t\t  current dealer with the specified number of\n" +
						   "\t\t\t\t  pieces.\n" +
						   "remove [article]\t\t= removes the specified article from stock of\n" +
						   "\t\t\t\t  the current dealer.");
	}


	public static void main(String args[])
	{
		Properties props = System.getProperties();
		props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
		props.put("org.omg.CORBA.ORBSingletonClass", "com.ooc.CORBA.ORBSingleton");

		try {
			ORB orb = ORB.init(args, props);

			BigDealer dealer	= null;
			Map dealerMap		= new HashMap();
			FileFilter filter	= new FileFilter();
			File dir			= new File(System.getProperty("user.dir"));
			File [] refSource	= dir.listFiles(filter);

			for (int i = 0; i < refSource.length; i++) {
				org.omg.CORBA.Object obj = orb.string_to_object("relfile:/" + refSource[i].getName());

				if(obj == null) {
					System.err.println("Can't read from " + refSource[i].getName());
					System.exit(1);
				}

				try {
					dealer = BigDealerHelper.narrow(obj);
				} catch (BAD_PARAM bpex) {
					bpex.printStackTrace();
					System.exit(1);
				}

				dealerMap.put(dealer.getName(), dealer);
			}

			(new ArtClient1(dealerMap)).run();
		} catch (SystemException sysex) {
			System.err.println(sysex.getMessage());
			sysex.printStackTrace();
			System.exit(1);
		}
	}
}
