package myArtikel;


import myArtikel.BigDealer;
import myArtikel.BigDealer_impl;

import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.SystemException;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManager;

import java.util.Map;
import java.util.HashMap;
import java.util.Properties;

import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.IOException;


public class ArtServer1
{
	public static void main(String args[])
	{
		org.omg.PortableServer.POA root = null;

		Properties props = System.getProperties();
		props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
		props.put("org.omg.CORBA.ORBSingletonClass", "com.ooc.CORBA.ORBSingleton");

		try {
			ORB orb = ORB.init(args, props);

			try {
				root = POAHelper.narrow(orb.resolve_initial_references("RootPOA"));
			} catch (InvalidName inex) {
				inex.printStackTrace();
				throw new RuntimeException();
			}

			System.out.println();
			Map initialArticles = new HashMap();
			initialArticles.put("Mars", new Integer(700));
			initialArticles.put("Twix", new Integer(500));
			initialArticles.put("Snickers", new Integer(300));
			initialArticles.put("MilkyWay", new Integer(1000));

			BigDealer_impl dealerImpl1 = new BigDealer_impl("Dealer1", initialArticles);
			BigDealer_impl dealerImpl2 = new BigDealer_impl("Dealer2");

			BigDealer dealer1 = dealerImpl1._this(orb);
			BigDealer dealer2 = dealerImpl2._this(orb);

			FileOutputStream file	= null;
			PrintWriter output		= null;

			try {
				String ref		= null;
				String refFile	= null;

				ref = orb.object_to_string(dealer1);
				refFile = "dealer1.ref";
				file = new FileOutputStream(refFile);
				output = new PrintWriter(file);
				output.println(ref);
				output.flush();
				file.close();

				ref = orb.object_to_string(dealer2);
				refFile = "dealer2.ref";
				file = new FileOutputStream(refFile);
				output = new PrintWriter(file);
				output.println(ref);
				output.flush();
				file.close();
			} catch (IOException ioex) {
				System.err.println("Can't write to '" + ioex.getMessage() + "'");
				System.exit(1);
			} finally {
				output.flush();
				try {
					file.close();
				} catch (IOException ioex) {
					System.err.println("Can't write to '" + ioex.getMessage() + "'");
					System.exit(1);
				}
			}

			try {
				POAManager manager = root.the_POAManager();
				manager.activate();
				System.out.println("\nServer is ready.\n");
			} catch (Exception ex) {
				ex.printStackTrace();
				throw new RuntimeException();
			}

			(new ServerShutdown()).run();
			orb.run();
		} catch (SystemException sysex) {
			sysex.printStackTrace();
			System.exit(1);
		}
	}
}
