// **********************************************************************
//
// Generated by the ORBacus IDL to Java Translator
//
// Copyright (c) 2001
// IONA Technologies, Inc.
// Waltham, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

// Version: 4.1.0

package myArtikel;


import myArtikel.Article_impl;

import java.util.Map;
import java.util.HashMap;
import java.util.List;
import java.util.Iterator;


//
// IDL:BigDealer:1.0
//
/***/

public class BigDealer_impl extends BigDealerPOA
{
	private org.omg.PortableServer.POA poa_;

	private Map articleMap	= null;
	private String name		= null;


	public BigDealer_impl(String name)
	{
		this.name	= name;
		articleMap	= new HashMap();
	}


	public BigDealer_impl(String name, Map initArticles)
	{
		this(name);

		Object nextArticle			= null;
		Iterator articlesIterator	= initArticles.keySet().iterator();

		while (articlesIterator.hasNext()) {
			nextArticle = articlesIterator.next();

			if ((nextArticle instanceof String) &&
				(initArticles.get(nextArticle) instanceof Integer)) {

				try {
					admitArticle((String)nextArticle, ((Integer)initArticles.get(nextArticle)).intValue());
				} catch (myArtikel.BigDealerPackage.ArticleExistingException aeex) {
					// do nothing because of startup phase
				}
			}
		}
	}


	public BigDealer_impl(org.omg.PortableServer.POA poa)
	{
		poa_ = poa;
	}


	public org.omg.PortableServer.POA _default_POA()
	{
		if(poa_ != null) {
			return poa_;
		} else {
			return super._default_POA();
		}
	}


    //
    // IDL:BigDealer/getName:1.0
    //
    public String getName()
    {
        return name;
    }


	//
	// IDL:BigDealer/admitArticle:1.0
	//
	public void admitArticle(String name, int number)
		throws myArtikel.BigDealerPackage.ArticleExistingException
	{
		if (getArtikelByName(name) != null) {
			throw new myArtikel.BigDealerPackage.ArticleExistingException(
						"The article '" + name + "' can't be admitted, because it " +
						"is present already at dealer '" + getName() + "'!");
		}

		articleMap.put(name, new Article_impl(name, number));
		System.out.println("\nThe article '" + name + "' was admitted with '" + number +
						   "' pieces at dealer '" + getName() + "'.");
	}


	//
	// IDL:BigDealer/deleteArticle:1.0
	//
	public void deleteArticle(String name)
		throws myArtikel.BigDealerPackage.ArticleNotExistingException
	{
		if (getArtikelByName(name) == null) {
			throw new myArtikel.BigDealerPackage.ArticleNotExistingException(
						"The article '" + name + "' can't be removed, because it " +
						"isn't present at dealer '" + getName() + "'!");
		}

		articleMap.remove(name);
		System.out.println("\nThe article '" + name + "' was removed at dealer '" + getName() + "'.");
	}


	//
	// IDL:BigDealer/getAllArticles:1.0
	//
	public ArticleInfo [] getAllArticles()
		throws myArtikel.BigDealerPackage.NoArticleExistingException
	{
		if (articleMap.size() == 0) {
			throw new myArtikel.BigDealerPackage.NoArticleExistingException(
						"No article is available for showing infos at dealer '" + getName() + "'!");
		}

		int counter					= 0;
		ArticleInfo [] articleInfo	= new ArticleInfo[articleMap.keySet().size()];
		Iterator articleIterator	= articleMap.keySet().iterator();

		while (articleIterator.hasNext()) {
			articleInfo[counter++] = ((Article_impl)articleMap.get(articleIterator.next())).getArticleInfo();
		}

		return articleInfo;
	}


	//
	// IDL:BigDealer/stock:1.0
	//
	public int stock(String name)
		throws myArtikel.BigDealerPackage.ArticleNotExistingException
	{
		if (getArtikelByName(name) == null) {
			throw new myArtikel.BigDealerPackage.ArticleNotExistingException(
						"The stock of the article '" + name + "' can't be shown, " +
						"because the article isn't present at dealer '" + getName() + "'!");
		}

		return getArtikelByName(name).getStock();
	}


	//
	// IDL:BigDealer/order:1.0
	//
	public int order(String name, int number)
		throws myArtikel.BigDealerPackage.DecliningException,
			   myArtikel.BigDealerPackage.ArticleNotExistingException
	{
		if (getArtikelByName(name) == null) {
			throw new myArtikel.BigDealerPackage.ArticleNotExistingException("'" +
						number + "' pieces of the article '" + name + "' can't be ordered, " +
						"because the article doesn't exist at dealer '" + getName() + "'!");
		}

		try {
			Article_impl article = getArtikelByName(name);
			article.order(number);

			System.out.println("\n'" + number + "' pieces of '" + article.getName() + "' were " +
							   "ordered at dealer '" + getName() + "' and sent.");
			System.out.println("The new stock of '" + article.getName() + "' is: '" +
							   article.getStock() + "'.");

			return article.getStock();
		} catch (myArtikel.ArticlePackage.DecliningException dex) {
			throw new myArtikel.BigDealerPackage.DecliningException(dex.getReason() +
																	"at dealer '" + getName() + "'!");
		}
	}


	//
	// IDL:BigDealer/deliver:1.0
	//
	public int deliver(String name, int number)
		throws myArtikel.BigDealerPackage.DecliningException,
			   myArtikel.BigDealerPackage.ArticleNotExistingException
	{
		if (getArtikelByName(name) == null) {
			throw new myArtikel.BigDealerPackage.ArticleNotExistingException("'" +
						number + "' pieces of the article '" + name + "' can't be delivered, " +
						"because the article doesn't exist at dealer '" + getName() + "'!");
		}

		Article_impl article = getArtikelByName(name);
		article.deliver(number);

		System.out.println("\n'" + number + "' pieces of '" + article.getName() +
						   "' were delivered at dealer '" + getName() + "'.");
		System.out.println("The new stock of '" + article.getName() + "' is: '" +
						   article.getStock() + "'.");

		return article.getStock();
	}


	private Article_impl getArtikelByName(String name) 
	{
		return (Article_impl)articleMap.get(name);
	}
}
