
		;***********************************
		;*                                 *
		;*          Projekt 1999           *
		;*                                 *
		;*            Funkuhr              *
		;*                                 *
		;*  by Alexander Schneider         *
		;*                                 *
		;***********************************

run:
		
eine_m          equ     40h              ; Minute einerstelle
zehn_m          equ     41h              ; Minute zehnerstelle
eine_s          equ     42h              ; Stunde einerstelle
zehn_s          equ     43h              ; Stunde zehnerstelle
datu_t          equ     44h              ; Kalendertag einerstelle
datt_z          equ     45h              ; Kalendertag zehnerstelle
datu_e          equ     23h              ; Kalendermonat einerstelle       
datu_z          equ     22h              ; Kalendermonat zehnerstelle
datj_e          equ     21h              ; Kalenderjahr einerstelle
datj_z          equ     20h              ; Kalenderjahr zehnerstelle


start:          mov     r0,#128 -1          ; Ladet Register 0 mit der Zahl 128 und macht -1
		clr     a                   ; Lscht den ACCU
loop:           mov     @r0,a               ; *****  Von mov r0,#128 -1 bis djnz r0,loop dient zum Lschen des RAM's
		djnz    r0,loop             ; Ist der Zhler noch nicht auf Null dann Spring nach loop
		mov     sp,#4fh             ; Setze den Stackpointer auf die vorne genannte Adresse
		ljmp    hite

		
		
		
		;------------- Auswertung 1s Pause (Funksignal) ------------
		
		org 100h
		
hite:           lcall   init_lcd            ; Sprg. UP nach init_lcd
		lcall   put_data            ; Sprg. UP nach put_data
		mov     a,#6                ; Whlt die Stelle an die am Display
		lcall   Set_adr             ; angezeigt werden soll.
		mov     a,#0b7h             ; spez. ausgeben
		lcall   put_data            ; Sprg. UP
		mov     a,#' '              ; _ ausgeben
		lcall   put_data            ; Sprg. UP
		mov     a,#'F'              ; Buchstabe F wird ausgegeben
		lcall   put_data            ; Sprg. UP nach put_data
		mov     a,#'u'              ; u ausgeben
		lcall   put_data            ; Sprg. UP
		mov     a,#'n'              ; n ausgeben
		lcall   put_data            ; Sprg. UP
		mov     a,#'k'              ; k ausgeben
		lcall   put_data            ; Sprg. UP
		mov     a,#' '              ; _ ausgeben
		lcall   put_data            ; Sprg. UP
		mov     a,#'U'              ; u ausgeben
		lcall   put_data            ; Sprg.  UP
		mov     a,#'h'              ; h ausgeben
		lcall   put_data            ; Sprg. UP
		mov     a,#'r'              ; r ausgeben
		lcall   put_data            ; Sprg. UP
		mov     a,#' '              ; _ ausgeben
		lcall   put_data            ; Sprg. UP
		mov     a,#0b7h             ; Spez. ausgeben
		lcall   put_data            ; Sprg. UP
	       
		

		jnb     P1.0,junk           ; Springe auf junk wenn P1.0 auf 1 ist
		ljmp    hite                ; Dient zum genauen abfragen des Taktes
		
		
junk:           mov     r7,#0c8h            ; Ldt das Register mit 100ms
		lcall   zeit                ; Springt zum Label zeit
		jnb     P1.0,lion           ; Springe wenn LOW zu lion 
		ljmp    hite                
		
lion:           mov     r7,#0c8h            ; Setze Zhler auf 100ms                   * * *
		lcall   zeit                ; lasse Zeit 100ms laufen
		jnb     P1.0,lion1          ; Springe wenn nicht Bit gesetzt auf lion1
		ljmp    hite

lion1:          mov     r7,#0c8h            ; Setze Zhler auf 100ms                   * * *
		lcall   zeit                ; lasse 100ms ablaufen
		jnb     P1.0,lion2          ; Springe wenn nicht Bit gesetzt auf lion2
		ljmp    hite

lion2:          mov     r7,#0c8h            ; Setze Zhler auf 100ms                   * * *
		lcall   zeit                ; lasse 100ms ablaufen
		jnb     P1.0,lion3          ; Springe wenn nicht Bit gesetzt auf lion3
		ljmp    hite
		
lion3:          mov     r7,#0c8h            ; Setze Zhler auf 100ms                   * * *
		lcall   zeit                ; lasse 100ms ablaufen 
		jnb     P1.0,lion4          ; Springe wenn nicht Bit gesetzt auf lion3a
		ljmp    hite

lion4:          mov     r7,#0c8h            ; Setze Zhler auf 100ms                   * * *
		lcall   zeit                ; lasse 100ms ablaufen
		jnb     P1.0,lion5          ; Springe wenn nicht Bit gesetzt auf lion4
		ljmp    hite

lion5:          mov     r7,#0c8h            ; Setze Zhler auf 100ms                   * * *
		lcall   zeit                ; lasse 100ms ablaufen
		jnb     P1.0,lion6          ; Springe wenn nicht Bit gesetzt auf lion5
		ljmp    hite

lion6:          mov     r7,#0c8h            ; Setze Zhler auf 100ms                   * * *
		lcall   zeit                ; lasse 100ms ablaufen
		jnb     P1.0,lion7          ; Springe wenn nicht Bit gesetzt auf lion6
		ljmp    hite

lion7:          mov     r7,#0c8h            ; Setze Zhler auf 100ms                   * * *
		lcall   zeit                ; lasse 100ms ablaufen
		jnb     P1.0,lion8          ; Springe wenn nicht Bit gesetzt auf lion7
		ljmp    hite

lion8:          mov     r7,#03ch            ; Setze Zhler auf 60ms                   * * *
		lcall   zeit                ; lasse 100ms ablaufen        
		jnb     P1.0,min            ; Springe wenn nicht Bit gesetzt auf out
		ljmp    hite
		
		
		
		;--------- 1 Minute warten und 1s Pause erneut messen  -----


min:            mov     r7,#0bah            ; Mit 20s laden
		lcall   uhr                 ; Zeit ablaufen lassem
		mov     r7,#0b9h            ; Mit 20s laden
		lcall   uhr                 ; Zeit ablaufen lassen
		mov     r7,#0b9h            ; Mit 20s laden
		lcall   uhr                 ; Zeit ablaufen lassen
		jnb     P1.0,SEC            ; Springe wenn P1.0=0 nach sec
		ljmp    hite                ; anstonsten sprung nach hite

SEC:            mov     r7,#07h             ; 1s -
		lcall   uhr                 ; Zeitablausen
		jnb     P1.0,jump           ; Ist Signal noch 0 ?
		ljmp    hite                ; Sprg. zu hite


jump:           ljmp    main                ; Sprg. zu main
		


	       

		
		
		;***********************************
		;**                               **
		;**    LCD - Initialisierung      **
		;**        fr 8051               **
		;**                               **
		;**    by Alexander Schneider     **
		;**                               **
		;***********************************
		
		;------- Zeitschleifenprogramm fr Wait_125ms --------------

uhr:            mov     r6,#0c0h
uhr1:           mov     r5,#0ffh
uhr2:           djnz    r5,uhr2
		djnz    r6,uhr1
		djnz    r7,uhr
		ret


		;------- Zeitschleifenprogramm fr Wait_0.5ms --------------

zeit:           mov     r6,#0dfh
zeit1:          djnz    r6,zeit1
		djnz    r7,zeit
		ret     

		
		;------- Zeitschleifenprogramm fr Wait_100mys -------------

time:           mov     r6,#01h                
time1:          djnz    r6,time1
		djnz    r7,time
		ret
		
		
		
		;------- Initialisierung fr LCD (Unterprogramm) -----------
		    

init_lcd:       mov     dptr,#0c000h        ;+++++++++++++++++++++++++++++++
		mov     a,#038h             ;+                             +  
		movx    @dptr,a             ;+                             +  
		mov     r7,#09h             ;+                             +  
		lcall   zeit                ;+                             +  
		mov     dptr,#0c000h        ;+   Dieser Prozess dient zum  +                         
		mov     a,#038h             ;+   Abfragen ob die LCD -     +                       
		movx    @dptr,a             ;+   gerade am lesen           +
		mov     r7,#09h             ;+   (am  arbeiten) ist        +                                        
		lcall   zeit                ;+                             +                   
		mov     dptr,#0c000h        ;+                             +
		mov     a,#038h             ;+                             +
		movx    @dptr,a             ;+                             +
		mov     r7,#09h             ;+                             +
		lcall   zeit                ;+                             +
		mov     dptr,#0c000h        ;+                             +
		mov     a,#038h             ;+                             +
		movx    @dptr,a             ;+                             +
		mov     r7,#09h             ;+                             +
		lcall   zeit                ;+++++++++++++++++++++++++++++++

		
		mov     a,#08h              ; Display OFF
		lcall   put_com             ; Springe zu put_com
		mov     a,#01h              ; Display clear/on
		lcall   put_com             ; Springe zu put_com 
		mov     a,#04h              ; Entry mode set  
		lcall   put_com             ; Springe zu put_com  
		mov     a,#01h              ; curser home
		lcall   put_com             ; Springe zu put_com 
		mov     a,#38h              ; zwei Zeilen Modus
		lcall   put_com             ; Springe zu put_com 
		mov     a,#0ch              ; curser home
		lcall   put_com             ; Springe zu put_com 
		mov     a,#06h              ; Richtung des curser's
		lcall   put_com             ; Springe zu put_com 
		mov     a,#01h              ; Anzeige lschen
		lcall   put_com             ; Springe zu put_com 
		ret                  
	 
Clear_dsp:      mov     a,#1                ;Display lschen
		lcall   put_com
		ret

					     
					     
					     
Set_adr:        orl     a,#80h              ; setzen der x-pos am Display, bergabe der position in a
		lcall   put_com             ; a=0 Zeichen bei Position 0, a= 5 Zeichen bei Position 5 
		ret                         ; Bit 7 setzen



put_data:       push    acc                ;********************************
		mov     dptr,#0c200h       ;* voher 0c002h
		movx    a,@dptr            ;*                              *
		anl     a,#080h            ;*                              *
		xrl     a,#080h            ;*       Dient zur Initia -     *
		lcall   time               ;*                              *
		mov     dptr,#0c100h       ;*       lisierung des LCD      *
		pop     acc                ;*                              *
		movx    @dptr,a            ;*       Displays               *
		ret                        ;*                              *
					   ;*                              *
put_com:        push    acc                ;*                              *
		mov     dptr,#0c200h       ;*                              *
		movx    a,@dptr            ;*                              *
		anl     a,#080h            ;*                              *
		lcall   time               ;*                              *
		mov     dptr,#0c000h       ;*                              *
		pop     acc                ;*                              *
		movx    @dptr,a            ;*                              *
		ret                        ;********************************

		
		;---------- Nochmals Warten fr LCD - Ansteuerung ----------


main:           lcall   init_lcd            ; Sprg. UP
		lcall   put_data            ; Sprg. UP
		mov     a,#10               ; Whlt die Stelle an die am Display
		lcall   Set_adr             ; angezeigt werden soll.
		mov     a,#'W'              ; w ausgeben
		lcall   put_data            ; Sprg. UP    
		mov     a,#'a'              ; a ausgeben
		lcall   put_data            ; Sprg. UP    
		mov     a,#'i'              ; i ausgeben
		lcall   put_data            ; Sprg. UP    
		mov     a,#'t'              ; t ausgeben
		lcall   put_data            ; Sprg. UP    
		
		
		;----------- Auswertung der 21 Takte ----------------------- 
		
tak2:           mov     r1,#015h            ; Lade R1 mit 20 (dec.)
tog:            jnb     P1.0,tos            ; Ist P1.0 auf 0 dann sprg auf tos
		ljmp    tog                 ; ansonsten Sprung auf tog
tos:            jb      P1.0,loos           ; Ist P1.0 auf 1 dann sprg auf loos
		ljmp    tos                 ; ansonsten Sprung auf tos
loos:           djnz    r1,tog              ; R1-1=0 ? dann weiter
					    ; ansonsten sprung auf tog
		
		
		;----- Auswertung High - Low Signale (Min. einer) ----------

tes:            jnb     P1.0,loft           ; Ist P1.0 auf 0 dann sprg auf tos
		ljmp    tes                 ; ansonsten Sprung auf tog
loft:           mov     r7,#0f0h            ; Lade eine Zeit von 125ms
spr:            jb      P1.0,imp            ; Sprg. wenn P1.0 = 1 sonst
		sjmp    spr                 ; Sprung auf sich selber
imp:            lcall   zeit                ; Lasse 125 ms ablaufen
		jnb     P1.0,flag0          ; Sprg. wenn P1.0 = 1 sonst
		mov     r7,#20h             ; Lade eine Zeit 30ms
		lcall   zeit                ; Lasse 30ms ablaufen
		jb      P1.0,flag1          ; Sprg. wenn P1.0 = 1 sonst
		ljmp    run                 ; Sprg. zu run

flag0:          mov     r0,#eine_m          ; Lade R0 mit Hexadr. 20
		mov     a,@R0               ; Schreiber R0 in ACCU
		anl     a,#0eh              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    tes1                ; Sprung 

flag1:          mov     r0,#eine_m          ; Lade R0 mit Hexadr. 20
		mov     a,@r0               ; R0 ---> ACCU
		orl     a,#01h              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    tes1                ; Sprung
		
		
		;------------ Abtasten zweites Bit -------------------------

tes1:           jnb     P1.0,loft1          ; Ist P1.0 auf 0 dann sprg auf tos
		ljmp    tes1                ; ansonsten Sprung auf tog
loft1:          mov     r7,#0f0h            ; Lade eine Zeit von 125ms
spr1:           jb      P1.0,imp1           ; Sprg. wenn P1.0 = 1 sonst
		sjmp    spr1                ; Sprung auf sich selber
imp1:           lcall   zeit                ; Lasse 125 ms ablaufen
		jnb     P1.0,flags0         ; Sprg. wenn P1.0 = 1 sonst
		mov     r7,#020h            ; Lade eine Zeit 30ms
		lcall   zeit                ; Lasse 30ms ablaufen
		jb      P1.0,flags1         ; Sprg. wenn P1.0 = 1 sonst
		ljmp    run                 ; Sprg. zu run

flags0:         mov     r0,#eine_m          ; Lade R0 mit Hexadr. 20
		mov     a,@r0               ; R0 ---> ACCU
		anl     a,#0dh              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    tes2                ; Sprung

flags1:         mov     r0,#eine_m          ; Lade R0 mit Hexadr. 20  
		mov     a,@r0               ; R0 ---> ACCU
		orl     a,#02h              ; Bit ausmaskieren 
		mov     @r0,a               ; ACCU ---> R0
		sjmp    tes2                ; Sprung 
		
		
		;------------ Abtasten drittes Bit -------------------------


tes2:           jnb     P1.0,loft2          ; Ist P1.0 auf 0 dann sprg auf tos
		ljmp    tes2                ; ansonsten Sprung auf tog
loft2:          mov     r7,#0f0h            ; Lade eine Zeit von 125ms
spr2:           jb      P1.0,imp2           ; Sprg. wenn P1.0 = 1 sonst
		sjmp    spr2                ; Sprung auf sich selber
imp2:           lcall   zeit                ; Lasse 125 ms ablaufen
		jnb     P1.0,fl0            ; Sprg. wenn P1.0 = 1 sonst
		mov     r7,#020h            ; Lade eine Zeit 30ms
		lcall   zeit                ; Lasse 30ms ablaufen
		jb      P1.0,fl1            ; Sprg. wenn P1.0 = 1 sonst
		ljmp    run                 ; Sprg. zu run

		
fl0:            mov     r0,#eine_m          ; Lade R0 mit Hexadr. 20
		mov     a,@r0               ; R0 ---> ACCU
		anl     a,#0bh              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    tes3                ; Sprung

fl1:            mov     r0,#eine_m          ; Lade R0 mit Hexadr. 20
		mov     a,@r0               ; R0 ---> ACCU
		orl     a,#04h              ; Bit ausmaskieren
		mov     @r0,a               ; R0 ---> ACCU
		sjmp    tes3                ; Sprung
		
		;------------ Abtasten viertes Bit    ----------------------

tes3:           jnb     P1.0,loft3          ; Ist P1.0 auf 0 dann sprg auf tos
		ljmp    tes3                ; ansonsten Sprung auf tog
loft3:          mov     r7,#0f0h            ; Lade eine Zeit von 125ms
spr3:           jb      P1.0,imp3           ; Sprg. wenn P1.0 = 1 sonst
		sjmp    spr3                ; Sprung auf sich selber
imp3:           lcall   zeit                ; Lasse 125 ms ablaufen
		jnb     P1.0,fla0           ; Sprg. wenn P1.0 = 1 sonst
		mov     r7,#020h            ; Lade eine Zeit 30ms
		lcall   zeit                ; Lasse 30ms ablaufen
		jb      P1.0,fla1           ; Sprg. wenn P1.0 = 1 sonst
		ljmp    run                 ; Sprg. zu run

fla0:           mov     r0,#eine_m          ; Lade R0 mit Hexadr. 20
		mov     a,@r0               ; R0 ---> ACCU
		anl     a,#07h              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    tes4

fla1:           mov     r0,#eine_m          ; Lade R0 mit Hexadr. 20
		mov     a,@r0               ; R0 ---> ACCU
		orl     a,#08h              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    tes4
		
		;------------ Abtasten  Minuten (zehner)  ------------------

tes4:           jnb     P1.0,loft4          ; Ist P1.0 auf 0 dann sprg auf tos
		ljmp    tes4                ; ansonsten Sprung auf tog
loft4:          mov     r7,#0f0h            ; Lade eine Zeit von 125ms
spr4:           jb      P1.0,imp4           ; Sprg. wenn P1.0 = 1 sonst
		sjmp    spr4                ; Sprung auf sich selber
imp4:           lcall   zeit                ; Lasse 125 ms ablaufen
		jnb     P1.0,z0             ; Sprg. wenn P1.0 = 1 sonst
		mov     r7,#020h            ; Lade eine Zeit 30ms
		lcall   zeit                ; Lasse 30ms ablaufen
		jb      P1.0,z1             ; Sprg. wenn P1.0 = 1 sonst
		ljmp    run                 ; Sprg. zu run

z0:             mov     r0,#zehn_m          ; Lade R0 mit Hexadr. 20
		mov     a,@r0               ; R0 ---> ACCU
		anl     a,#0eh              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    tes5                ; Sprung

z1:             mov     r0,#zehn_m          ; Lade R0 mit Hexadr. 20
		mov     a,@r0               ; R0 ---> ACCU
		orl     a,#01h              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    tes5                ; Sprung

		;------------ Abtasten  Minuten (zehner)  ------------------

tes5:           jnb     P1.0,loft5          ; Ist P1.0 auf 0 dann sprg auf tos
		ljmp    tes5                ; ansonsten Sprung auf tog
loft5:          mov     r7,#0f0h            ; Lade eine Zeit von 125ms
spr5:           jb      P1.0,imp5           ; Sprg. wenn P1.0 = 1 sonst
		sjmp    spr5                ; Sprung auf sich selber
imp5:           lcall   zeit                ; Lasse 125 ms ablaufen
		jnb     P1.0,ze0            ; Sprg. wenn P1.0 = 1 sonst
		mov     r7,#020h            ; Lade eine Zeit 30ms
		lcall   zeit                ; Lasse 30ms ablaufen
		jb      P1.0,ze1            ; Sprg. wenn P1.0 = 1 sonst
		ljmp    run                 ; Sprg. zu run

ze0:            mov     r0,#zehn_m          ; Lade R0 mit Hexadr. 20
		mov     a,@r0               ; R0 ---> ACCU
		anl     a,#0dh              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    tes6                ; Sprung

ze1:            mov     r0,#zehn_m          ; Lade R0 mit Hexadr. 20
		mov     a,@r0               ; R0 ---> ACCU
		orl     a,#02h              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    tes6                ; Sprung
		
		
		;------------ Abtasten  Minuten (zehner)  ------------------

tes6:           jnb     P1.0,loft6          ; Ist P1.0 auf 0 dann sprg auf tos
		ljmp    tes6                ; ansonsten Sprung auf tog
loft6:          mov     r7,#0f0h            ; Lade eine Zeit von 125ms
spr6:           jb      P1.0,imp6           ; Sprg. wenn P1.0 = 1 sonst
		sjmp    spr6                ; Sprung auf sich selber
imp6:           lcall   zeit                ; Lasse 125 ms ablaufen
		jnb     P1.0,zeh0           ; Sprg. wenn P1.0 = 1 sonst
		mov     r7,#020h            ; Lade eine Zeit 30ms
		lcall   zeit                ; Lasse 30ms ablaufen
		jb      P1.0,zeh1           ; Sprg. wenn P1.0 = 1 sonst
		ljmp    run                 ; Sprg. zu run

zeh0:           mov     r0,#zehn_m          ; Lade R0 mit Hexadr. 20
		mov     a,@r0               ; R0 ---> ACCU
		anl     a,#0bh              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		ljmp    was

zeh1:           mov     r0,#zehn_m          ; Lade R0 mit Hexadr. 20
		mov     a,@r0               ; R0 ---> ACCU
		orl     a,#04h              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		ljmp    was
		
		
		
	      
		;-------------------- 1 Takt warten  ----------------------- 
		
was:            mov     r1,#01h             ; Lade R1 mit 20 (dec.)
ws:             jnb     P1.0,wa             ; Ist P1.0 auf 0 dann sprg auf tos
		ljmp    ws                  ; ansonsten Sprung auf tog
wa:             jb      P1.0,lo             ; Ist P1.0 auf 1 dann sprg auf loos
		ljmp    wa                  ; ansonsten Sprung auf tos
lo:             djnz    r1,ws               ; R1-1=0 ? dann weiter
					    ; ansonsten sprung auf tog
		
		
		;----- Auswertung High - Low Signale (Std. einer) ----------

ts:             jnb     P1.0,lot            ; Ist P1.0 auf 0 dann sprg auf tos
		ljmp    ts                  ; ansonsten Sprung auf tog
lot:            mov     r7,#0f0h            ; Lade eine Zeit von 125ms
sr:             jb      P1.0,isp            ; Sprg. wenn P1.0 = 1 sonst
		sjmp    sr                  ; Sprung auf sich selber
isp:            lcall   zeit                ; Lasse 125 ms ablaufen
		jnb     P1.0,s0             ; Sprg. wenn P1.0 = 1 sonst
		mov     r7,#20h             ; Lade eine Zeit 30ms
		lcall   zeit                ; Lasse 30ms ablaufen
		jb      P1.0,s1             ; Sprg. wenn P1.0 = 1 sonst
		ljmp    run                 ; Sprg. zu run

s0:             mov     r0,#eine_s          ; Lade R0 mit Hexadr. 20
		mov     a,@R0               ; Schreiber R0 in ACCU
		anl     a,#0eh              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    ts1                 ; Sprung 

s1:             mov     r0,#eine_s          ; Lade R0 mit Hexadr. 20
		mov     a,@r0               ; R0 ---> ACCU
		orl     a,#01h              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    ts1                 ; Sprung
		
		;----- Auswertung 2 Bit (Std. einer) --------------

ts1:            jnb     P1.0,lot1           ; Ist P1.0 auf 0 dann sprg auf tos
		ljmp    ts1                 ; ansonsten Sprung auf tog
lot1:           mov     r7,#0f0h            ; Lade eine Zeit von 125ms
sr1:            jb      P1.0,ip1            ; Sprg. wenn P1.0 = 1 sonst
		sjmp    sr1                 ; Sprung auf sich selber
ip1:            lcall   zeit                ; Lasse 125 ms ablaufen
		jnb     P1.0,st0            ; Sprg. wenn P1.0 = 1 sonst
		mov     r7,#20h             ; Lade eine Zeit 30ms
		lcall   zeit                ; Lasse 30ms ablaufen
		jb      P1.0,st1            ; Sprg. wenn P1.0 = 1 sonst
		ljmp    run                 ; Sprg. zu run

st0:            mov     r0,#eine_s          ; Lade R0 mit Hexadr. 20
		mov     a,@R0               ; Schreiber R0 in ACCU
		anl     a,#0dh              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    ts2                 ; Sprung 

st1:            mov     r0,#eine_s          ; Lade R0 mit Hexadr. 20
		mov     a,@r0               ; R0 ---> ACCU
		orl     a,#02h              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    ts2                 ; Sprung
		
		
		;----- Auswertung 3 Bit (Std. einer) --------------

ts2:            jnb     P1.0,lot2           ; Ist P1.0 auf 0 dann sprg auf tos
		ljmp    ts2                 ; ansonsten Sprung auf tog
lot2:           mov     r7,#0f0h            ; Lade eine Zeit von 125ms
sr2:            jb      P1.0,ip2            ; Sprg. wenn P1.0 = 1 sonst
		sjmp    sr2                 ; Sprung auf sich selber
ip2:            lcall   zeit                ; Lasse 125 ms ablaufen
		jnb     P1.0,stu0           ; Sprg. wenn P1.0 = 1 sonst
		mov     r7,#20h             ; Lade eine Zeit 30ms
		lcall   zeit                ; Lasse 30ms ablaufen
		jb      P1.0,stu1           ; Sprg. wenn P1.0 = 1 sonst
		ljmp    run                 ; Sprg. zu run

stu0:           mov     r0,#eine_s          ; Lade R0 mit Hexadr. 20
		mov     a,@R0               ; Schreiber R0 in ACCU
		anl     a,#0bh              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    ts3                 ; Sprung 

stu1:           mov     r0,#eine_s          ; Lade R0 mit Hexadr. 20
		mov     a,@r0               ; R0 ---> ACCU
		orl     a,#04h              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    ts3                 ; Sprung
		
		;----- Auswertung 4 Bit (Std. einer) --------------

ts3:            jnb     P1.0,lot3           ; Ist P1.0 auf 0 dann sprg auf tos
		ljmp    ts3                 ; ansonsten Sprung auf tog
lot3:           mov     r7,#0f0h            ; Lade eine Zeit von 125ms
sr3:            jb      P1.0,ip3            ; Sprg. wenn P1.0 = 1 sonst
		sjmp    sr3                 ; Sprung auf sich selber
ip3:            lcall   zeit                ; Lasse 125 ms ablaufen
		jnb     P1.0,stun0          ; Sprg. wenn P1.0 = 1 sonst
		mov     r7,#20h             ; Lade eine Zeit 30ms
		lcall   zeit                ; Lasse 30ms ablaufen
		jb      P1.0,stun1          ; Sprg. wenn P1.0 = 1 sonst
		ljmp    run                 ; Sprg. zu run

stun0           mov     r0,#eine_s          ; Lade R0 mit Hexadr. 20
		mov     a,@R0               ; Schreiber R0 in ACCU
		anl     a,#07h              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    ts4

stun1:          mov     r0,#eine_s          ; Lade R0 mit Hexadr. 20
		mov     a,@r0               ; R0 ---> ACCU
		orl     a,#08h              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    ts4
		
		
		;----- Auswertung High - Low Signale (Std. zehner) ---------

ts4:            jnb     P1.0,lot4           ; Ist P1.0 auf 0 dann sprg auf tos
		ljmp    ts4                 ; ansonsten Sprung auf tog
lot4:           mov     r7,#0f0h            ; Lade eine Zeit von 125ms
sr4:            jb      P1.0,isp4           ; Sprg. wenn P1.0 = 1 sonst
		sjmp    sr4                 ; Sprung auf sich selber
isp4:           lcall   zeit                ; Lasse 125 ms ablaufen
		jnb     P1.0,std0           ; Sprg. wenn P1.0 = 1 sonst
		mov     r7,#20h             ; Lade eine Zeit 30ms
		lcall   zeit                ; Lasse 30ms ablaufen
		jb      P1.0,std1           ; Sprg. wenn P1.0 = 1 sonst
		ljmp    run                 ; Sprg. zu run

std0:           mov     r0,#zehn_s          ; Lade R0 mit Hexadr. 20
		mov     a,@R0               ; Schreiber R0 in ACCU
		anl     a,#0eh              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    ts5                 ; Sprung 

std1:           mov     r0,#zehn_s          ; Lade R0 mit Hexadr. 20
		mov     a,@r0               ; R0 ---> ACCU
		orl     a,#01h              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    ts5                 ; Sprung
		
		;----- Auswertung 2 Bit (Std. einer) --------------

ts5:            jnb     P1.0,lot5           ; Ist P1.0 auf 0 dann sprg auf tos
		ljmp    ts5                 ; ansonsten Sprung auf tog
lot5:           mov     r7,#0f0h            ; Lade eine Zeit von 125ms
sr5:            jb      P1.0,ip5            ; Sprg. wenn P1.0 = 1 sonst
		sjmp    sr5                 ; Sprung auf sich selber
ip5:            lcall   zeit                ; Lasse 125 ms ablaufen
		jnb     P1.0,sd0            ; Sprg. wenn P1.0 = 1 sonst
		mov     r7,#20h             ; Lade eine Zeit 30ms
		lcall   zeit                ; Lasse 30ms ablaufen
		jb      P1.0,sd1            ; Sprg. wenn P1.0 = 1 sonst
		ljmp    run                 ; Sprg. zu run

sd0:            mov     r0,#zehn_s          ; Lade R0 mit Hexadr. 20
		mov     a,@R0               ; Schreiber R0 in ACCU
		anl     a,#0dh              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    was1                ; Sprung 

sd1:            mov     r0,#zehn_s          ; Lade R0 mit Hexadr. 20
		mov     a,@r0               ; R0 ---> ACCU
		orl     a,#02h              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    was1                ; Sprung
		
		
		;-------------------- 1 Takt warten  ----------------------- 
		
was1:           mov     r1,#01h             ; Lade R1 mit 20 (dec.)
ws1:            jnb     P1.0,wa1            ; Ist P1.0 auf 0 dann sprg auf tos
		ljmp    ws1                 ; ansonsten Sprung auf tog
wa1:            jb      P1.0,lo1            ; Ist P1.0 auf 1 dann sprg auf loos
		ljmp    wa1                 ; ansonsten Sprung auf tos
lo1:            djnz    r1,ws1              ; R1-1=0 ? dann weiter
					    ; ansonsten sprung auf tog
		
		
		;----- Auswertung High - Low Signale (Monat Tag)   ----------

ms:             jnb     P1.0,gs             ; Ist P1.0 auf 0 dann sprg auf tos
		ljmp    ms                  ; ansonsten Sprung auf tog
gs:             mov     r7,#0f0h            ; Lade eine Zeit von 125ms
rt:             jb      P1.0,lf             ; Sprg. wenn P1.0 = 1 sonst
		sjmp    rt                  ; Sprung auf sich selber
lf:             lcall   zeit                ; Lasse 125 ms ablaufen
		jnb     P1.0,m0             ; Sprg. wenn P1.0 = 1 sonst
		mov     r7,#20h             ; Lade eine Zeit 30ms
		lcall   zeit                ; Lasse 30ms ablaufen
		jb      P1.0,m1             ; Sprg. wenn P1.0 = 1 sonst
		ljmp    run                 ; Sprg. zu run

m0:             mov     r0,#datu_t          ; Lade R0 mit Hexadr. 20
		mov     a,@R0               ; Schreiber R0 in ACCU
		anl     a,#0eh              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    ms1                 ; Sprung 

m1:             mov     r0,#datu_t          ; Lade R0 mit Hexadr. 20
		mov     a,@r0               ; R0 ---> ACCU
		orl     a,#01h              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    ms1                 ; Sprung
		
		
		;----- Auswertung 2 Bit (Monat Tag)  ----------------------

ms1:            jnb     P1.0,gs1            ; Ist P1.0 auf 0 dann sprg auf tos
		ljmp    ms1                 ; ansonsten Sprung auf tog
gs1:            mov     r7,#0f0h            ; Lade eine Zeit von 125ms
rt1:            jb      P1.0,lf1            ; Sprg. wenn P1.0 = 1 sonst
		sjmp    rt1                 ; Sprung auf sich selber
lf1:            lcall   zeit                ; Lasse 125 ms ablaufen
		jnb     P1.0,mo0            ; Sprg. wenn P1.0 = 1 sonst
		mov     r7,#20h             ; Lade eine Zeit 30ms
		lcall   zeit                ; Lasse 30ms ablaufen
		jb      P1.0,mo1            ; Sprg. wenn P1.0 = 1 sonst
		ljmp    run                 ; Sprg. zu run

mo0:            mov     r0,#datu_t          ; Lade R0 mit Hexadr. 20
		mov     a,@R0               ; Schreiber R0 in ACCU
		anl     a,#0dh              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    ms2                 ; Sprung 

mo1:            mov     r0,#datu_t          ; Lade R0 mit Hexadr. 20
		mov     a,@r0               ; R0 ---> ACCU
		orl     a,#02h              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    ms2                 ; Sprung
		
		
		;----- Auswertung 3 Bit (Monat Tag)  ----------------------

ms2:            jnb     P1.0,gs2            ; Ist P1.0 auf 0 dann sprg auf tos
		ljmp    ms2                 ; ansonsten Sprung auf tog
gs2:            mov     r7,#0f0h            ; Lade eine Zeit von 125ms
rt2:            jb      P1.0,lf2            ; Sprg. wenn P1.0 = 1 sonst
		sjmp    rt2                 ; Sprung auf sich selber
lf2:            lcall   zeit                ; Lasse 125 ms ablaufen
		jnb     P1.0,mon0           ; Sprg. wenn P1.0 = 1 sonst
		mov     r7,#20h             ; Lade eine Zeit 30ms
		lcall   zeit                ; Lasse 30ms ablaufen
		jb      P1.0,mon1           ; Sprg. wenn P1.0 = 1 sonst
		ljmp    run                 ; Sprg. zu run

mon0:           mov     r0,#datu_t          ; Lade R0 mit Hexadr. 20
		mov     a,@R0               ; Schreiber R0 in ACCU
		anl     a,#0bh              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    ms3                 ; Sprung 

mon1:           mov     r0,#datu_t          ; Lade R0 mit Hexadr. 20
		mov     a,@r0               ; R0 ---> ACCU
		orl     a,#04h              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    ms3                 ; Sprung
		
		
		;----- Auswertung 4 Bit (Monat Tag)  ----------------------

ms3:            jnb     P1.0,gs3            ; Ist P1.0 auf 0 dann sprg auf tos
		ljmp    ms3                 ; ansonsten Sprung auf tog
gs3:            mov     r7,#0f0h            ; Lade eine Zeit von 125ms
rt3:            jb      P1.0,lf3            ; Sprg. wenn P1.0 = 1 sonst
		sjmp    rt3                 ; Sprung auf sich selber
lf3:            lcall   zeit                ; Lasse 125 ms ablaufen
		jnb     P1.0,mona0          ; Sprg. wenn P1.0 = 1 sonst
		mov     r7,#20h             ; Lade eine Zeit 30ms
		lcall   zeit                ; Lasse 30ms ablaufen
		jb      P1.0,mona1          ; Sprg. wenn P1.0 = 1 sonst
		ljmp    run                 ; Sprg. zu run

mona0:          mov     r0,#datu_t          ; Lade R0 mit Hexadr. 20
		mov     a,@R0               ; Schreiber R0 in ACCU
		anl     a,#07h              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    ms4                 ; Sprung 

mona1:          mov     r0,#datu_t          ; Lade R0 mit Hexadr. 20
		mov     a,@r0               ; R0 ---> ACCU
		orl     a,#08h              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    ms4                 ; Sprung
		
		;----- Auswertung 1 Bit (Monat Tag zehner)   ----------------

ms4:            jnb     P1.0,gs4            ; Ist P1.0 auf 0 dann sprg auf tos
		ljmp    ms4                 ; ansonsten Sprung auf tog
gs4:            mov     r7,#0f0h            ; Lade eine Zeit von 125ms
rt4:            jb      P1.0,lf4            ; Sprg. wenn P1.0 = 1 sonst
		sjmp    rt4                 ; Sprung auf sich selber
lf4:            lcall   zeit                ; Lasse 125 ms ablaufen
		jnb     P1.0,monat0         ; Sprg. wenn P1.0 = 1 sonst
		mov     r7,#20h             ; Lade eine Zeit 30ms
		lcall   zeit                ; Lasse 30ms ablaufen
		jb      P1.0,monat1         ; Sprg. wenn P1.0 = 1 sonst
		ljmp    run                 ; Sprg. zu run

monat0:         mov     r0,#datt_z          ; Lade R0 mit Hexadr. 20
		mov     a,@R0               ; Schreiber R0 in ACCU
		anl     a,#0eh              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    ms5                 ; Sprung 

monat1:         mov     r0,#datt_z          ; Lade R0 mit Hexadr. 20
		mov     a,@r0               ; R0 ---> ACCU
		orl     a,#01h              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    ms5                 ; Sprung
		
		;----- Auswertung 2 Bit (Monat Tag zehner)   ----------------

ms5:            jnb     P1.0,gs5            ; Ist P1.0 auf 0 dann sprg auf tos
		ljmp    ms5                 ; ansonsten Sprung auf tog
gs5:            mov     r7,#0f0h            ; Lade eine Zeit von 125ms
rt5:            jb      P1.0,lf5            ; Sprg. wenn P1.0 = 1 sonst
		sjmp    rt5                 ; Sprung auf sich selber
lf5:            lcall   zeit                ; Lasse 125 ms ablaufen
		jnb     P1.0,d0             ; Sprg. wenn P1.0 = 1 sonst
		mov     r7,#20h             ; Lade eine Zeit 30ms
		lcall   zeit                ; Lasse 30ms ablaufen
		jb      P1.0,d1            ; Sprg. wenn P1.0 = 1 sonst
		ljmp    run                 ; Sprg. zu run

d0:             mov     r0,#datt_z          ; Lade R0 mit Hexadr. 20
		mov     a,@R0               ; Schreiber R0 in ACCU
		anl     a,#0dh              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    was2                ; Sprung 

d1:             mov     r0,#datt_z          ; Lade R0 mit Hexadr. 20
		mov     a,@r0               ; R0 ---> ACCU
		orl     a,#02h              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    was2                ; Sprung
		
		
		
		;-------------------- 3 Takt warten  ----------------------- 
		
was2:           mov     r1,#03h             ; Lade R1 mit 03 (dec.)
ws2:            jnb     P1.0,wa2            ; Ist P1.0 auf 0 dann sprg auf tos
		ljmp    ws2                 ; ansonsten Sprung auf tog
wa2:            jb      P1.0,lo2            ; Ist P1.0 auf 1 dann sprg auf loos
		ljmp    wa2                 ; ansonsten Sprung auf tos
lo2:            djnz    r1,ws2              ; R1-1=0 ? dann weiter
					    ; ansonsten sprung auf tog
		
		
		
		;----- Auswertung 1 Bit (Monat Monat einer) --------------

ms6:            jnb     P1.0,gs6            ; Ist P1.0 auf 0 dann sprg auf tos
		ljmp    ms6                 ; ansonsten Sprung auf tog
gs6:            mov     r7,#0f0h            ; Lade eine Zeit von 125ms
rt6:            jb      P1.0,lf6            ; Sprg. wenn P1.0 = 1 sonst
		sjmp    rt6                 ; Sprung auf sich selber
lf6:            lcall   zeit                ; Lasse 125 ms ablaufen
		jnb     P1.0,da0            ; Sprg. wenn P1.0 = 1 sonst
		mov     r7,#20h             ; Lade eine Zeit 30ms
		lcall   zeit                ; Lasse 30ms ablaufen
		jb      P1.0,da1            ; Sprg. wenn P1.0 = 1 sonst
		ljmp    run                 ; Sprg. zu run

da0:            mov     r0,#datu_e          ; Lade R0 mit Hexadr. 20
		mov     a,@R0               ; Schreiber R0 in ACCU
		anl     a,#0eh              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    ms7                 ; Sprung 

da1:            mov     r0,#datu_e          ; Lade R0 mit Hexadr. 20
		mov     a,@r0               ; R0 ---> ACCU
		orl     a,#01h              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    ms7                 ; Sprung
		
		
		;----- Auswertung 2 Bit (Monat Monat einer) --------------

ms7:            jnb     P1.0,gs7            ; Ist P1.0 auf 0 dann sprg auf tos
		ljmp    ms7                 ; ansonsten Sprung auf tog
gs7:            mov     r7,#0f0h            ; Lade eine Zeit von 125ms
rt7:            jb      P1.0,lf7            ; Sprg. wenn P1.0 = 1 sonst
		sjmp    rt7                 ; Sprung auf sich selber
lf7:            lcall   zeit                ; Lasse 125 ms ablaufen
		jnb     P1.0,dat0           ; Sprg. wenn P1.0 = 1 sonst
		mov     r7,#20h             ; Lade eine Zeit 30ms
		lcall   zeit                ; Lasse 30ms ablaufen
		jb      P1.0,dat1           ; Sprg. wenn P1.0 = 1 sonst
		ljmp    run                 ; Sprg. zu run

dat0:           mov     r0,#datu_e          ; Lade R0 mit Hexadr. 20
		mov     a,@R0               ; Schreiber R0 in ACCU
		anl     a,#0dh              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    ms8                 ; Sprung 
		
dat1:           mov     r0,#datu_e          ; Lade R0 mit Hexadr. 20
		mov     a,@r0               ; R0 ---> ACCU
		orl     a,#02h              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    ms8                 ; Sprung
		
		
		;----- Auswertung 3 Bit (Monat Monat einer) --------------

ms8:            jnb     P1.0,gs8            ; Ist P1.0 auf 0 dann sprg auf tos
		ljmp    ms8                 ; ansonsten Sprung auf tog
gs8:            mov     r7,#0f0h            ; Lade eine Zeit von 125ms
rt8:            jb      P1.0,lf8            ; Sprg. wenn P1.0 = 1 sonst
		sjmp    rt8                 ; Sprung auf sich selber
lf8:            lcall   zeit                ; Lasse 125 ms ablaufen
		jnb     P1.0,datu0          ; Sprg. wenn P1.0 = 1 sonst
		mov     r7,#20h             ; Lade eine Zeit 30ms
		lcall   zeit                ; Lasse 30ms ablaufen
		jb      P1.0,datu1          ; Sprg. wenn P1.0 = 1 sonst
		ljmp    run                 ; Sprg. zu run

datu0:          mov     r0,#datu_e          ; Lade R0 mit Hexadr. 20
		mov     a,@R0               ; Schreiber R0 in ACCU
		anl     a,#0bh              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    ms9                 ; Sprung 

datu1:          mov     r0,#datu_e          ; Lade R0 mit Hexadr. 20
		mov     a,@r0               ; R0 ---> ACCU
		orl     a,#04h              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    ms9                 ; Sprung
		
		
		;----- Auswertung 4 Bit (Monat Monat einer) --------------

ms9:            jnb     P1.0,gs9            ; Ist P1.0 auf 0 dann sprg auf tos
		ljmp    ms9                 ; ansonsten Sprung auf tog
gs9:            mov     r7,#0f0h            ; Lade eine Zeit von 125ms
rt9:            jb      P1.0,lf9            ; Sprg. wenn P1.0 = 1 sonst
		sjmp    rt9                 ; Sprung auf sich selber
lf9:            lcall   zeit                ; Lasse 125 ms ablaufen
		jnb     P1.0,datum0         ; Sprg. wenn P1.0 = 1 sonst
		mov     r7,#20h             ; Lade eine Zeit 30ms
		lcall   zeit                ; Lasse 30ms ablaufen
		jb      P1.0,datum1         ; Sprg. wenn P1.0 = 1 sonst
		ljmp    run                 ; Sprg. zu run

datum0:         mov     r0,#datu_e          ; Lade R0 mit Hexadr. 20
		mov     a,@R0               ; Schreiber R0 in ACCU
		anl     a,#07h              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    msa                 ; Sprung 

datum1:         mov     r0,#datu_e          ; Lade R0 mit Hexadr. 20
		mov     a,@r0               ; R0 ---> ACCU
		orl     a,#08h              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    msa                 ; Sprung
		
		
		;----- Auswertung 1 Bit (Monat Monat zehner) --------------

msa:            jnb     P1.0,gsa            ; Ist P1.0 auf 0 dann sprg auf tos
		ljmp    msa                 ; ansonsten Sprung auf tog
gsa:            mov     r7,#0f0h            ; Lade eine Zeit von 125ms
rta:            jb      P1.0,lfa            ; Sprg. wenn P1.0 = 1 sonst
		sjmp    rta                 ; Sprung auf sich selber
lfa:            lcall   zeit                ; Lasse 125 ms ablaufen
		jnb     P1.0,tm0            ; Sprg. wenn P1.0 = 1 sonst
		mov     r7,#20h             ; Lade eine Zeit 30ms
		lcall   zeit                ; Lasse 30ms ablaufen
		jb      P1.0,tm1            ; Sprg. wenn P1.0 = 1 sonst
		ljmp    run                 ; Sprg. zu run

tm0:            mov     r0,#datu_z          ; Lade R0 mit Hexadr. 20
		mov     a,@R0               ; Schreiber R0 in ACCU
		anl     a,#0eh              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    msc                 ; Sprung 

tm1:            mov     r0,#datu_z          ; Lade R0 mit Hexadr. 20
		mov     a,@r0               ; R0 ---> ACCU
		orl     a,#01h              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    msc                 ; Sprung
		
		
		
		;----- Auswertung 1 Bit (Monat jahr einer) --------------

msc:            jnb     P1.0,gsc            ; Ist P1.0 auf 0 dann sprg auf tos
		ljmp    msc                 ; ansonsten Sprung auf tog
gsc:            mov     r7,#0f0h            ; Lade eine Zeit von 125ms
rtc:            jb      P1.0,lfc            ; Sprg. wenn P1.0 = 1 sonst
		sjmp    rtc                 ; Sprung auf sich selber
lfc:            lcall   zeit                ; Lasse 125 ms ablaufen
		jnb     P1.0,tat0           ; Sprg. wenn P1.0 = 1 sonst
		mov     r7,#20h             ; Lade eine Zeit 30ms
		lcall   zeit                ; Lasse 30ms ablaufen
		jb      P1.0,tat1           ; Sprg. wenn P1.0 = 1 sonst
		ljmp    run                 ; Sprg. zu run

tat0:           mov     r0,#datj_e          ; Lade R0 mit Hexadr. 20
		mov     a,@R0               ; Schreiber R0 in ACCU
		anl     a,#0eh              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    msd                 ; Sprung 

tat1:           mov     r0,#datj_e          ; Lade R0 mit Hexadr. 20
		mov     a,@r0               ; R0 ---> ACCU
		orl     a,#01h              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    msd                 ; Sprung
		
		
		;----- Auswertung 2 Bit (Monat jahr einer) --------------

msd:            jnb     P1.0,gsd            ; Ist P1.0 auf 0 dann sprg auf tos
		ljmp    msd                 ; ansonsten Sprung auf tog
gsd:            mov     r7,#0f0h            ; Lade eine Zeit von 125ms
rtd:            jb      P1.0,lfd            ; Sprg. wenn P1.0 = 1 sonst
		sjmp    rtd                 ; Sprung auf sich selber
lfd:            lcall   zeit                ; Lasse 125 ms ablaufen
		jnb     P1.0,tatu0          ; Sprg. wenn P1.0 = 1 sonst
		mov     r7,#20h             ; Lade eine Zeit 30ms
		lcall   zeit                ; Lasse 30ms ablaufen
		jb      P1.0,tatu1          ; Sprg. wenn P1.0 = 1 sonst
		ljmp    run                 ; Sprg. zu run

tatu0:          mov     r0,#datj_e          ; Lade R0 mit Hexadr. 20
		mov     a,@R0               ; Schreiber R0 in ACCU
		anl     a,#0dh              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    msf                 ; Sprung 

tatu1:          mov     r0,#datj_e          ; Lade R0 mit Hexadr. 20
		mov     a,@r0               ; R0 ---> ACCU
		orl     a,#02h              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    msf                 ; Sprung
		
		;----- Auswertung 3 Bit (Monat jahr einer) --------------

msf:            jnb     P1.0,gsf            ; Ist P1.0 auf 0 dann sprg auf tos
		ljmp    msf                 ; ansonsten Sprung auf tog
gsf:            mov     r7,#0f0h            ; Lade eine Zeit von 125ms
rtf:            jb      P1.0,lff            ; Sprg. wenn P1.0 = 1 sonst
		sjmp    rtf                 ; Sprung auf sich selber
lff:            lcall   zeit                ; Lasse 125 ms ablaufen
		jnb     P1.0,tatum0         ; Sprg. wenn P1.0 = 1 sonst
		mov     r7,#20h             ; Lade eine Zeit 30ms
		lcall   zeit                ; Lasse 30ms ablaufen
		jb      P1.0,tatum1         ; Sprg. wenn P1.0 = 1 sonst
		ljmp    run                 ; Sprg. zu run

tatum0:         mov     r0,#datj_e          ; Lade R0 mit Hexadr. 20
		mov     a,@R0               ; Schreiber R0 in ACCU
		anl     a,#0bh              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    ms10                ; Sprung 

tatum1:         mov     r0,#datj_e          ; Lade R0 mit Hexadr. 20
		mov     a,@r0               ; R0 ---> ACCU
		orl     a,#04h              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    ms10                ; Sprung
		
		;----- Auswertung 4 Bit (Monat jahr einer) --------------

ms10:           jnb     P1.0,gs10           ; Ist P1.0 auf 0 dann sprg auf tos
		ljmp    ms10                ; ansonsten Sprung auf tog
gs10:           mov     r7,#0f0h            ; Lade eine Zeit von 125ms
rt10:           jb      P1.0,lf10           ; Sprg. wenn P1.0 = 1 sonst
		sjmp    rt10                ; Sprung auf sich selber
lf10:           lcall   zeit                ; Lasse 125 ms ablaufen
		jnb     P1.0,q0             ; Sprg. wenn P1.0 = 1 sonst
		mov     r7,#20h             ; Lade eine Zeit 30ms
		lcall   zeit                ; Lasse 30ms ablaufen
		jb      P1.0,q1             ; Sprg. wenn P1.0 = 1 sonst
		ljmp    run                 ; Sprg. zu run

q0:             mov     r0,#datj_e          ; Lade R0 mit Hexadr. 20
		mov     a,@R0               ; Schreiber R0 in ACCU
		anl     a,#07h              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    ms11                ; Sprung 

q1:             mov     r0,#datj_e          ; Lade R0 mit Hexadr. 20
		mov     a,@r0               ; R0 ---> ACCU
		orl     a,#08h              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    ms11                ; Sprung
		
		
		;----- Auswertung 1 Bit (Monat jahr zehner)  --------------

ms11:           jnb     P1.0,gs11           ; Ist P1.0 auf 0 dann sprg auf tos
		ljmp    ms11                ; ansonsten Sprung auf tog
gs11:           mov     r7,#0f0h            ; Lade eine Zeit von 125ms
rt11:           jb      P1.0,lf11           ; Sprg. wenn P1.0 = 1 sonst
		sjmp    rt11                ; Sprung auf sich selber
lf11:           lcall   zeit                ; Lasse 125 ms ablaufen
		jnb     P1.0,qu0            ; Sprg. wenn P1.0 = 1 sonst
		mov     r7,#20h             ; Lade eine Zeit 30ms
		lcall   zeit                ; Lasse 30ms ablaufen
		jb      P1.0,qu1            ; Sprg. wenn P1.0 = 1 sonst
		ljmp    run                 ; Sprg. zu run

qu0:            mov     r0,#datj_z          ; Lade R0 mit Hexadr. 20
		mov     a,@R0               ; Schreiber R0 in ACCU
		anl     a,#0eh              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    ms12                ; Sprung 

qu1:            mov     r0,#datj_z          ; Lade R0 mit Hexadr. 20
		mov     a,@r0               ; R0 ---> ACCU
		orl     a,#01h              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    ms12                ; Sprung
		
		;----- Auswertung 2 Bit (Monat jahr zehner)  --------------

ms12:           jnb     P1.0,gs12           ; Ist P1.0 auf 0 dann sprg auf tos
		ljmp    ms12                ; ansonsten Sprung auf tog
gs12:           mov     r7,#0f0h            ; Lade eine Zeit von 125ms
rt12:           jb      P1.0,lf12           ; Sprg. wenn P1.0 = 1 sonst
		sjmp    rt12                ; Sprung auf sich selber
lf12:           lcall   zeit                ; Lasse 125 ms ablaufen
		jnb     P1.0,qut0           ; Sprg. wenn P1.0 = 1 sonst
		mov     r7,#20h             ; Lade eine Zeit 30ms
		lcall   zeit                ; Lasse 30ms ablaufen
		jb      P1.0,qut1           ; Sprg. wenn P1.0 = 1 sonst
		ljmp    run                 ; Sprg. zu run

qut0:           mov     r0,#datj_z          ; Lade R0 mit Hexadr. 20
		mov     a,@R0               ; Schreiber R0 in ACCU
		anl     a,#0dh              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    ms13                ; Sprung 

qut1:           mov     r0,#datj_z          ; Lade R0 mit Hexadr. 20
		mov     a,@r0               ; R0 ---> ACCU
		orl     a,#02h              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    ms13                ; Sprung
		
		;----- Auswertung 3 Bit (Monat jahr zehner)  --------------

ms13:           jnb     P1.0,gs13           ; Ist P1.0 auf 0 dann sprg auf tos
		ljmp    ms13                ; ansonsten Sprung auf tog
gs13:           mov     r7,#0f0h            ; Lade eine Zeit von 125ms
rt13:           jb      P1.0,lf13           ; Sprg. wenn P1.0 = 1 sonst
		sjmp    rt13                ; Sprung auf sich selber
lf13:           lcall   zeit                ; Lasse 125 ms ablaufen
		jnb     P1.0,qutu0          ; Sprg. wenn P1.0 = 1 sonst
		mov     r7,#20h             ; Lade eine Zeit 30ms
		lcall   zeit                ; Lasse 30ms ablaufen
		jb      P1.0,qutu1          ; Sprg. wenn P1.0 = 1 sonst
		ljmp    run                 ; Sprg. zu run

qutu0:          mov     r0,#datj_z          ; Lade R0 mit Hexadr. 20
		mov     a,@R0               ; Schreiber R0 in ACCU
		anl     a,#0bh              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    ms14                ; Sprung 

qutu1:          mov     r0,#datj_z          ; Lade R0 mit Hexadr. 20
		mov     a,@r0               ; R0 ---> ACCU
		orl     a,#04h              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    ms14                ; Sprung
		
		
		;----- Auswertung 3 Bit (Monat jahr zehner)  --------------

ms14:           jnb     P1.0,gs14           ; Ist P1.0 auf 0 dann sprg auf tos
		ljmp    ms14                ; ansonsten Sprung auf tog
gs14:           mov     r7,#0f0h            ; Lade eine Zeit von 125ms
rt14:           jb      P1.0,lf14           ; Sprg. wenn P1.0 = 1 sonst
		sjmp    rt14                ; Sprung auf sich selber
lf14:           lcall   zeit                ; Lasse 125 ms ablaufen
		jnb     P1.0,qutum0         ; Sprg. wenn P1.0 = 1 sonst
		mov     r7,#20h             ; Lade eine Zeit 30ms
		lcall   zeit                ; Lasse 30ms ablaufen
		jb      P1.0,qutum1         ; Sprg. wenn P1.0 = 1 sonst
		ljmp    run                 ; Sprg. zu run

qutum0:         mov     r0,#datj_z          ; Lade R0 mit Hexadr. 20
		mov     a,@R0               ; Schreiber R0 in ACCU
		anl     a,#07h              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    output              ; Sprung 

qutum1:         mov     r0,#datj_z          ; Lade R0 mit Hexadr. 20
		mov     a,@r0               ; R0 ---> ACCU
		orl     a,#08h              ; Bit ausmaskieren
		mov     @r0,a               ; ACCU ---> R0
		sjmp    output              ; Sprung
		
		
		
		;------- Ausgabe Kalendertag (einerstelle) ----------------

output:         mov     r0,#datt_z          ; Lade r0 mit Hexadr. 20
		mov     a,@r0
		add     a,#030h             ; Addiere ACCU mit 30 Hex     
		mov     @r0,a               ; ACCU ---> R0
		clr     a                   ; Lsche ACCU
		lcall   init_lcd            ; Sprg. UP
		lcall   put_data            ; Sprg. UP
		mov     a,#02               ; Whlt die Stelle an die am Display
		lcall   Set_adr             ; angezeigt werden soll. 
		mov     a,@r0               ; Zeichen An LCD ausgeben
		call    put_data            ; Sprg. UP                                                                                                              
	
		
		; ------- Ausgabe Kalendertag (zehnerstelle) ------------------
		
		mov     r0,#datu_t
		mov     a,@r0
		add     a,#30h
		mov     @r0,a
		mov     a,@r0
		lcall   put_data
		mov     a,#'.'
		lcall   put_data
		
		
		
		; ------ Ausgabe Kalendermonat (einerstelle) --------------

		mov     r0,#datu_z
		mov     a,@r0
		add     a,#30h
		mov     @r0,a
		mov     a,@r0
		lcall   put_data
		
		
		
		
		; ------ Ausgabe Kalendermonat (zehnerstelle) -------------

		mov     r0,#datu_e
		mov     a,@r0
		add     a,#30h
		mov     @r0,a
		mov     a,@r0
		lcall   put_data
		mov     a,#'.'
		lcall   put_data
		
		
		; ------ Ausgabe Kalenderjahr (einerstelle) -------------

		mov     r0,#datj_e
		mov     a,@r0
		add     a,#30h
		mov     @r0,a
		mov     a,@r0
		lcall   put_data
		

		
		; ----- Ausgabe Kalenderjahr (zehnerstelle) ----------------- 

		mov     r0,#datj_z
		mov     a,@r0
		add     a,#30h
		mov     @r0,a
		mov     a,@r0
		lcall   put_data
		mov     a,#' '
		lcall   put_data
		mov     a,#' '
		lcall   put_data
		mov     a,#' '
		lcall   put_data
		mov     a,#' '
		lcall   put_data
		mov     a,#' '
		lcall   put_data
		mov     a,#' '
		lcall   put_data
		
		
		; ------ Ausgabe Stunde (zehnerstelle) -------------

		mov     r0,#zehn_s
		mov     a,@r0
		add     a,#30h
		mov     @r0,a
		mov     a,@r0
		lcall   put_data
		
		
		; ------ Ausgabe Stunde (einerstelle) -------------

		mov     r0,#eine_s
		mov     a,@r0
		add     a,#30h
		mov     @r0,a
		mov     a,@r0
		lcall   put_data
		mov     a,#':'
		lcall   put_data
		
		; ------ Ausgabe Minute (zehnerstelle) -------------

		mov     r0,#zehn_m
		mov     a,@r0
		add     a,#30h
		mov     @r0,a
		mov     a,@r0
		lcall   put_data
		
		
		; ------ Ausgabe Minute (einerstelle) -------------

		mov     r0,#eine_m
		mov     a,@r0
		add     a,#30h
		mov     @r0,a
		mov     a,@r0
		lcall   put_data

		;----------- Auswertung der 22 Takte ----------------------- 
		
		mov     r1,#016h            ; Lade R1 mit 20 (dec.)
togs:           jnb     P1.0,tom            ; Ist P1.0 auf 0 dann sprg auf tos
		ljmp    tog                 ; ansonsten Sprung auf tog
tom:            jb      P1.0,los            ; Ist P1.0 auf 1 dann sprg auf loos
		ljmp    tos                 ; ansonsten Sprung auf tos
los:            djnz    r1,togs             ; R1-1=0 ? dann weiter
					    ; ansonsten sprung auf tog
		
		ljmp    tes
		end
