;****************************************************************************
;* Programm zur Zeitmessung zwischen 2 Lichtschranken mit Umrechnung in V   *
;* und Ausgabe auf LC-Display von gemessener Zeit, Durchschnittsgeschwindig-*
;* keit in m/s und km/h.                                                    *
;****************************************************************************

        ORG     0000H           ;Startadresse

;****************************************************************************
;* Initialisierungen                                                        *
;****************************************************************************

        LXI     SP,  3FFFH      ;Stackpointer auf hchste RAM-Adresse
        MVI     A,   82H        ;PIO Steuerwort
        OUT     13H             ;Steuerwort an PIO
        LXI     B,   0401H      ;Steuerwort fr Display lschen
        CALL    DISINI          ;UP fr Steuerwort an Display
        LXI     B,   0402H      ;Steuerwort fr Cursor-Home position
        CALL    DISINI
        LXI     B,   0406H      ;Steuerwort fr Mode Set
        CALL    DISINI
        LXI     B,   040CH      ;Steuerwort fr Display Ein/Aus
        CALL    DISINI
        LXI     B,   0438H      ;Steuerwort fr Funktion setzen
        CALL    DISINI

;       CALL    INTRO           ;UP fr Programmstart-Intro

;****************************************************************************
;* Programmstart der Endlosschleife  (Hauptprogramm)                        *
;****************************************************************************

START:  IN      11H             ;Port B einlesen
        XRI     00H             ;Port B maskieren (alle Signale 0?)
        JNZ     START           ;Wenn nicht alle Signale 0, dann sprung Start
        CALL    BEREIT          ;UP fr Ausgabe "Bereit" auf Display
LICHT1: IN      11H             ;Port B einlesen
        XRI     01H             ;Port B0 maskieren
        JNZ     LICHT1          ;Wenn nicht Port B=01H, dann sprung Licht1
        CALL    DISMES          ;UP fr Ausgabe "Messung" auf Display
        LXI     D,   0000H      ;Zhlregister auf 0000H setzen
MESS:   CALL    ZEIT1           ;Zeitschleife fr Messung aufrufen
        NOP                     ;Zeitkorrektur fr Abweichung
        NOP                     ;Gesamtfehler bei 60s ist dann 20ms
        INX     D               ;Zhlregister=Zhlregister+1

;****************************************************************************
;* berlaufabfrage                                                          *
;****************************************************************************

        MOV     A,   D          ;High-Nibble von Zhlregister in Akku
        CPI     0EAH            ;Vergleich High-Nibble mit EA (D > 59904 ?)
        JNZ     LICHT2          ;Wenn nicht gleich, dann sprung Licht2
        MOV     A,   E          ;Low-Nibble von Zhlregister in Akku
        CPI     61H             ;Vergleich Low-Nibble mit 61 (E > 97 ?)
        JZ      UEBER           ;Wenn gleich, dann sprung Ueber

;****************************************************************************
;* berlaufabfrage ENDE                                                     *
;****************************************************************************

LICHT2: IN      11H             ;Port B einlesen
        XRI     02H             ;Port B1 maskieren
        JNZ     MESS            ;Wenn nicht Port B=02H, dann sprung Mess
UEBER:  CALL    AUSG            ;UP Ausgabe (berlaufabfrage, Tasterabfrage,
                                ;            Berechnungen, Konvertierungen)
        JMP     START           ;Endlosschleife ab Start

;****************************************************************************
;* ENDE vom Hauptprogramm                                                   *
;****************************************************************************




;****************************************************************************
;* Unterprogramm fr bernahme des Steuerwortes und der Daten ins Display   *
;****************************************************************************

DISINI: MOV     A,   C          ;Low-Nibble in den Akku (Daten)
        OUT     10H             ;An Port A ausgeben
        MOV     A,   B          ;High-Nibble in den Akku (Enable, R/W, RS)
        OUT     12H             ;AN Port C ausgeben
        CALL    Zeit2           ;UP Zeitschleife fr sichere Datenbernahme
        MVI     A,00H           ;Akku lschen
        OUT     12H             ;Port C lschen (Enable, R/W, RS lschen)
        RET                     ;UP verlassen

;****************************************************************************
;* Unterprogramm fr Zeitschleife1 (wird fr Zeitmessung bentigt)          *
;* Bentigt etwa eine Zeit von 974s                                        *
;****************************************************************************

ZEIT1:  PUSH    D               ;DE-Register in Stack ablegen (sichern)
        MVI     D,   0CEH       ;D-Register mit CEH laden
ZLOOP1: DCR     D               ;Schleifenzhler=Schleifenzhler-1
        JNZ     ZLOOP1          ;Wenn D > 0, dann sprung ZLoop1
        POP     D               ;DE-Register aus Stack holen
        RET                     ;UP verlassen

;****************************************************************************
;* Unterprogramm fr Zeitschleife2 (wird fr Datenbernahme im Disp bentigt*
;* Bentigt etwa eine Zeit von 82s                                         *
;****************************************************************************

ZEIT2:  PUSH    D               ;DE-Register in Stack ablegen (sichern)
        MVI     D,   7FH        ;D-Register mit 0FH laden
ZLOOP2: DCR     D               ;Schleifenzhler=SchleifenZhler-1
        JNZ     ZLOOP2          ;Wenn D > 0, dann sprung ZLoop2
        POP     D               ;DE-Register aus Stack holen
        RET                     ;UP verlassen

;****************************************************************************
;* Unterprogramm fr Zeitschleife3 (wird fr Disp-Anzeige-Wechsel bentigt) *
;* Die Schleife ist geschachtelt und bentigt etwa eine Zeit von 2,1s       *
;****************************************************************************

ZEIT3:  PUSH    D               ;DE-Register in Stack ablegen (sichern)
        MVI     D,   07H        ;D-Register mit 07H laden
ZLOOP3: PUSH    D               ;DE-Register in Stack ablegen (sichern)
        LXI     D,   0FFFFH     ;DE-Register mit FFFFH laden
Z3:     DCX     D               ;Schleifenzhler=Schleifenzhler-1
        JNZ     Z3              ;Wenn DE > 0, dann sprung Z3
        POP     D               ;DE-Register aus Stack holen
        DCR     D               ;Schleifenzhler=Schleifenzhler-1
        JNZ     ZLOOP3          ;Wenn D > 0, dann sprung ZLoop3
        POP     D               ;DE-Register aus Stack holen
        RET                     ;UP verlassen

;****************************************************************************
;* Unterprogramm zur Ausgabe des Wortes "Bereit" ans Display                *
;****************************************************************************

BEREIT: CALL    CLEARD          ;UP fr Display lschen und Cursor an Pos1
        LXI     B,   0480H      ;Datenwort fr DD-RAM Adresse 1. Zeile
        CALL    DISINI          ;Datenwort ausgeben
        LXI     H,   TEXT1      ;Adresse von Texttabelle von "Bereit" ins HL
        MVI     B,   06H        ;Datenwort fr Textausgabe ins B-Register
        CALL    AUSLES          ;UP fr Texttabelle auslesen und Ausgabe
        RET                     ;UP verlassen

;****************************************************************************
;* Unterprogramm zur Ausgabe des Wortes "Messung" ans Display               *
;****************************************************************************

DISMES: CALL    CLEARD          ;UP fr Display lschen und Cursor an Pos1
        LXI     B,   0480H      ;Datenwort fr DD-RAM Adresse 1. Zeile
        CALL    DISINI          ;Datenwort ausgeben
        LXI     H,   TEXT2      ;Adresse von Texttabelle von "Messung" ins HL
        MVI     B,   06H        ;Datenwort fr Textausgabe ins B-Register
        CALL    AUSLES          ;UP fr Texttabelle auslesen und Ausgabe
        RET                     ;UP verlassen

;****************************************************************************
;* Unterprogramm zur Ausgabe des Wortes "berlauf" ans Display              *
;****************************************************************************

BIGTIM: CALL    CLEARD          ;UP fr Display lschen und Cursor an Pos1
        LXI     B,   0480H      ;Datenwort fr DD-RAM Adresse 1. Zeile
        CALL    DISINI          ;Datenwort ausgeben
        LXI     H,   TEXT3      ;Adresse von Texttabelle von "berlauf" ins HL
        MVI     B,   06H        ;Datenwort fr Textausgabe ins B-Register
        CALL    AUSLES          ;UP fr Texttabelle auslesen und Ausgabe
        RET                     ;UP verlassen

;****************************************************************************
;* Unterprogramm zum Display lschen und Cursor an Position 1 setzen        *
;****************************************************************************

CLEARD: LXI     B,   0401H      ;Steuerwort fr Display lschen
        CALL    DISINI          ;UP fr Steuerwort an Display
        LXI     B,   0402H      ;Steuerwort fr Cursor Home-Position
        CALL    DISINI  
        RET                     ;UP verlassen

;****************************************************************************
;* Unterprogramm zum auslesen der Texttabelle und ausgeben auf das Display  *
;****************************************************************************

AUSLES: MOV     C,   M          ;Asciizeichen von Texttabelle ins B-Register
        MVI     A,   00H        ;Akku mit 00H laden
        ORA     C               ;Wenn Asciizeichen 00H, dann Tabellenende
        JZ      RETURN          ;Wenn Tabellenende, dann sprung Return
        CALL    DISINI          ;Asciizeichen ans Display ausgeben
        INX     H               ;Adressenzeiger+1
        JMP     AUSLES          ;Sprung auf Ausles
RETURN: RET                     ;UP verlassen

;****************************************************************************
;* Unterprogramm zum auslesen der Texttabelle und ausgeben auf das Display  *
;* (von hinten nach vorne)                                                  *
;****************************************************************************

AUSLE1: MOV     C,   M          ;Asciizeichen von Texttabelle ins B-Register
        MVI     A,   00H        ;Akku mit 00H laden
        ORA     C               ;Wenn Asciizeichen 00H, dann Tabellenende
        JZ      RETUR1          ;Wenn Tabellenende, dann sprung Return
        CALL    DISINI          ;Asciizeichen ans Display ausgeben
        DCX     H               ;Adressenzeiger-1
        JMP     AUSLE1          ;Sprung auf Ausles
RETUR1: RET                     ;UP verlassen


;****************************************************************************
;* Texttabellen                                                             *
;****************************************************************************

Text1:  DB      'Bereit'        ;Text "Bereit"
        DB      00H             ;Textende

Text2:  DB      'Messung'       ;Text "Messung"
        DB      00H             ;Textende

Text3:  DB      0F5H            ;Text ()
        DB      'berlauf'       ;Text
        DB      00H             ;Textende

Text4:  DB      'sm '           ;Text
        DB      00H             ;Textende

Text5:  DB      'V < 1m/s'      ;Text
        DB      00H             ;Textende

Text6:  DB      's/m '          ;Text
        DB      00H             ;Textende

Text7:  DB      'h/mk '         ;Text
        DB      00H             ;Textende




;****************************************************************************
;* Unterprogramm zur Auswertung und Anzeige der Messergebnisse              *
;****************************************************************************

AUSG:   MOV     A,   D          ;High-Nibble von Zhlregister in Akku
        CPI     0EAH            ;Vergleich High-Nibble mit EAH
        JNZ     AUSG1           ;Wenn nicht gleich, dann sprung Ausg1 
                                ;(eigentliche Ausgabe)
        MOV     A,   E          ;Low-Nibble von Zhlregister in Akku
        CPI     61H             ;Vergleich Low-Nibble mit 61H
        JNZ     AUSG1           ;Wenn nicht gleich, dann sprung Ausg1
        CALL    BIGTIM          ;Wenn Zhlerstand > 60000, dann UP Bigtim
                                ;(UP zur Ausgabe von "berlauf")
AUSGX1: IN      11H             ;Port B einlesen
        XRI     04H             ;Port B2 maskieren
        JNZ     AUSGX1          ;Wenn nicht Taster, dann AusgB2
        RET                     ;UP verlassen

AUSG1:  MOV     A,   D          ;High-Nibble von Zhlregister in Akku
        CPI     01H             ;Vergleich High-Nibble mit 01H
        JNZ     AUSG2           ;Wenn nicht gleich, dann sprung Ausg2
        MOV     A,   E          ;Low-Nibble von Zhlregister in Akku
        CPI     91H             ;Vergleich Low-Nibble mit 91H (t > s ?)
        JNZ     AUSG2           ;Wenn nicht gleich, dann sprung Ausg2
        CALL    AUSGA           ;UP zur Ausgabe von Zeit und V < 1m/s
        RET                     ;UP verlassen
AUSG2:  CALL    AUSGB           ;UP zur Ausgabe von Zeit und Geschwindigkeit
        RET                     ;UP verlassen

;****************************************************************************
;* Unterprogramm zur Ausgabe der Zeit bei Geschwindigkeit < 1m/s            *
;****************************************************************************

AUSGA:  LXI     H,   2000H      ;Adresse fr Ergebnis der Konvertierung
        PUSH    D               ;DE-Register sichern
        PUSH    B               ;BC-Register sichern
        CALL    KONV            ;UP zur Konvertierung der Zahlen aufrufen
        POP     B               ;BC-Register vom Stack holen
        POP     D               ;DE-Register vom Stack holen
        CALL    CLEARD          ;UP Display lschen
        LXI     B,   0404H      ;Steuerwort fr von re. nach li. schreiben
        CALL    DISINI          ;Steuerwort ans Display ausgeben
        LXI     B,   0480H      ;Steuerwort fr DD-RAM 1. Zeile
        CALL    DISINI
        LXI     H,   TEXT4      ;HL-Register auf Adresse von Text4
        MVI     B,   06H        ;Datenwort fr Displaybernahme
        CALL    AUSLES          ;Texttabelle an Display ausgeben
        LXI     H,   2005H      ;HL-Register auf Adresse von umgew. Zeit
        CALL    AUSLE1          ;UP zum auslesen (Rckwrts)
        LXI     B,   0406H      ;Steuerwort fr schreiben von li. nach re.
        CALL    DISINI
        LXI     B,   04C0H      ;Steuerwort fr DD-RAM 2. Zeile
        CALL    DISINI
        LXI     H,   TEXT5      ;HL-Register auf Adresse von Text5
        MVI     B,   06H        ;Datenwort fr Displaybernahme
        CALL    AUSLES          ;Texttabelle an Display ausgeben
        
AUSGA1: IN      11H             ;Port B einlesen
        XRI     04H             ;Port B2 maskieren
        JNZ     AUSGA1          ;Wenn nicht Taster, dann AusgB2
        RET                     ;UP verlassen

;****************************************************************************
;* Unterprogramm zur Ausgabe der Zeit und Geschwindigkeit in m/s und km/h   *
;****************************************************************************

AUSGB:  LXI     H,   2000H      ;Adresse fr Ergebnis der Konvertierung
        PUSH    D               ;DE-Register sichern
        PUSH    B               ;BC-Register sichern
        CALL    KONV            ;UP zur Konvertierung der Zahlen aufrufen
        POP     B               ;BC-Register vom Stack holen
        POP     D               ;DE-Register vom Stack holen

        PUSH    D               ;DE-Register sichern
        PUSH    B               ;BC-Register sichern
        XCHG                    ;Vertausche HL mit DE-Register
        LXI     D,   0190H      ;DE-Register mit 0190H laden (400mm)
        CALL    DIVIDE          ;UP zur Berechnung der Durchschnittsgeschw.
        LXI     H,   2010H      ;Adresse fr Ergebnis der Konvertierung
        CALL    KONV            ;UP zur Konvertierung der Zahlen aufrufen
        POP     B               ;BC-Register vom Stack holen
        POP     D               ;DE-Register vom Stack holen

        PUSH    D               ;DE-Register sichern
        PUSH    B               ;BC-Register sichern
        XCHG                    ;Vertausche HL mit DE-Register
        LXI     D,   05A0H      ;DE-Register mit 05A0H laden (400mm*3,6)
        CALL    DIVIDE          ;UP zur Berechnung der Durchschnittsgeschw.
        LXI     H,   2020H      ;Adresse fr Ergebnis der Konvertierung
        CALL    KONV            ;UP zur Konvertierung der Zahlen aufrufen
        POP     B               ;BC-Register vom Stack holen
        POP     D               ;DE-Register vom Stack holen

AUSGB1: CALL    CLEARD          ;UP Display lschen
        LXI     B,   0404H      ;Steuerwort fr von re. nach li. schreiben
        CALL    DISINI          ;Steuerwort ans Display ausgeben
        LXI     B,   0480H      ;Steuerwort fr DD-RAM 1. Zeile
        CALL    DISINI
        LXI     H,   TEXT4      ;HL-Register auf Adresse von Text4
        MVI     B,   06H        ;Datenwort fr Displaybernahme
        CALL    AUSLES          ;Texttabelle an Display ausgeben
        LXI     H,   2005H      ;HL-Register auf Adresse von umgew. Zeit
        CALL    AUSLE1          ;UP zum auslesen (Rckwrts)

        LXI     B,   04C0H      ;Steuerwort fr DD-RAM 2. Zeile
        CALL    DISINI
        LXI     H,   TEXT6      ;HL-Register auf Adresse von Text6
        MVI     B,   06H        ;Datenwort fr Displaybernahme
        CALL    AUSLES          ;Texttabelle an Display ausgeben
        LXI     H,   2015H      ;HL-Register auf Adresse von umgew. Gechw.
        CALL    AUSLE1          ;UP zum auslesen (Rckwrts)
        CALL    ZEIT3           ;UP fr Zeitprogramm (2s) aufrufen

        IN      11H             ;Port B einlesen
        XRI     04H             ;Port B2 maskieren
        JNZ     AUSGB2          ;Wenn nicht Taster, dann AusgB2
        RET

AUSGB2: CALL    CLEARD          ;UP Display lschen
        LXI     B,   0404H      ;Steuerwort fr von re. nach li. schreiben
        CALL    DISINI          ;Steuerwort ans Display ausgeben
        LXI     B,   0480H      ;Steuerwort fr DD-RAM 1. Zeile
        CALL    DISINI
        LXI     H,   TEXT4      ;HL-Register auf Adresse von Text4
        MVI     B,   06H        ;Datenwort fr Displaybernahme
        CALL    AUSLES          ;Texttabelle an Display ausgeben
        LXI     H,   2005H      ;HL-Register auf Adresse von umgew. Zeit
        CALL    AUSLE1          ;UP zum auslesen (Rckwrts)

        LXI     B,   04C0H      ;Steuerwort fr DD-RAM 2. Zeile
        CALL    DISINI
        LXI     H,   TEXT7      ;HL-Register auf Adresse von Text7
        MVI     B,   06H        ;Datenwort fr Displaybernahme
        CALL    AUSLES          ;Texttabelle an Display ausgeben
        LXI     H,   2025H      ;HL-Register auf Adresse von umgew. Gechw.
        CALL    AUSLE1          ;UP zum auslesen (Rckwrts)
        CALL    ZEIT3           ;UP fr Zeitprogramm (2s) aufrufen
        
        IN      11H             ;Port B einlesen
        XRI     04H             ;Port B2 maskieren
        JNZ     AUSGB1          ;Wenn nicht Taster, dann AusgB1
        RET                     ;UP verlassen

;****************************************************************************
;* Unterprogramm zur Konvertierung der 16 Bit Zahl in eine 5 stellige       *
;* BCD-Zahl                                                                 *
;****************************************************************************

KONV:   LXI     B,   0005H      ;*Setze BC auf 05H  
        DAD     B               ;Addiere BC und HL
        XCHG                    ;Vertausche HL mit DE-Register
        LXI     B,   0D8F0H     ;Lade BC mit -10000 (Stellenwert)
        CALL    KONV1           ;UP Konv1 aufrufen
        LXI     B,   0FC18H     ;Lade BC mit -1000 (Stellenwert)
        CALL    KONV1           ;UP Konv1 aufrufen
        LXI     B,   0FF9CH     ;Lade BC mit -100 (Stellenwert)
        CALL    KONV1           ;UP Konv1 aufrufen
        LXI     B,   0FFF6H     ;Lade BC mit -10 (Stellenwert)
        CALL    KONV1           ;UP Konv1 aufrufen
        MOV     A,   L          ;Lade Akku mit Inhalt des L-Registers
        STAX    D               ;Akku im RAM abspeichern
        DCX     D               ;*Adresse fr nchste Stelle zuweisen
        MVI     A,   00H        ;*Akku mit 00H laden (Textende)
        STAX    D               ;Wert im RAM abspeichern
        XCHG                    ;Vertausche HL mit DE-Register
        RET                     ;UP verlassen

KONV1:  XRA     A               ;Stelleninhalt in A mit 0 initialisieren
        PUSH    D               ;Register DE sichern
KONV2:  MOV     E,   L          ;L-Register in E-Register schreiben
        MOV     D,   H          ;H-Register in D-Register Schreiben
        INR     A               ;Stelleninhalt=Stelleninhalt+1
        DAD     B               ;Binrzahl-Stellenwert
        JC      KONV2           ;Wenn kein bertrag, dann sprung Konv2
        DCR     A               ;berlauf korrigieren
        MOV     L,E             ;Divisionsrest in HL speichern
        MOV     H,D             
        POP     D               ;Hole DE-Register vom Stack
        ADI     30H             ;*30H zum Akku addieren, wegen Ascii-Tabelle
        STAX    D               ;Adresse fr nchste Stelle zuweisen
        DCX     D
        RET                     ;UP verlassen

;****************************************************************************
;* Unterprogramm zur Berechnung der Durchschnittsgechwindigkeit             *
;****************************************************************************

DIVIDE: SHLD    2500H           ;Speicheradresse des Hilfsspeichers
        LXI     B,   0000H      ;Hilfsgre
        PUSH    B               ;BC-Register im Stack sichern
        LXI     H,   2502H      ;HL-Register auf 2502 setzen
        MVI     M,   17H        
DIVID1: MOV     A,   E          ;E-Register in Akku holen
        RAL                     ;Links schieben
        MOV     E,   A          ;Akku in E-Register schreiben
        MOV     A,   D          ;D-Register in Akku holen
        RAL                     ;Links schieben
        MOV     D,   A          ;Akku in D-Register schreiben
        LXI     H,   2502H      ;Schleifenzhler
        DCR     M               ;dekrementieren
        POP     H               ;Vorher gesichertes BC-Regist in HL-Regist
        JZ      DIVID2          ;Wenn null, dann sprung Divid2
        MVI     A,   00H        ;00H in Akku laden
        RAL                     ;Links schieben
        DAD     H               ;HL in Bit nach Links
        MOV     B,   H          ;Ergebnis von H in B schreiben
        ADD     L               ;Addiere L
        LHLD    2500H           ;Lade HL-Register mit Inhalt der Adressen
        SUB     L               ;Subtrahiere L
        MOV     C,   A          ;Akkuinhalt in C-Register
        MOV     A,   B          ;B-Register in Akku holen
        SBB     H               ;HL-Register subtrahieren
        MOV     B,   A          ;Akkuinhalt in B-Register
        PUSH    B               ;BC-Register in Stack sichern
        JNC     DIVID1          ;Wenn nicht Carry, dann Divid1
        DAD     B               ;Addiere rp und HL
        XTHL                    ;Vertausche HL mit Stack
        JMP     DIVID1          ;Sprung Divid1
DIVID2: MOV     A,   D          ;D-Register in Akku holen
        CMA                     ;Akku negieren
        MOV     D,   A          ;Akkuinhalt in D-Register schreiben
        MOV     A,   E          ;E-Register in Akku holen
        CMA                     ;Akku negieren
        MOV     E,   A          ;Akkuinhalt in E-Register schreiben
        RET                     ;UP verlassen




;****************************************************************************
;* Programmende                                                             *
;****************************************************************************

        END
